from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBService");
  exportedObject.put("roleName", "WebSphereSIBService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibservice.startcra", objid, "startCRA","SIBService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibservice.enable", objid, "enable","SIBService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibservice.configurationreloadenabled", objid, "configurationReloadEnabled","SIBService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SIBService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('SIBService')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "startCRA", roleProperties.optString("websphere.sibservice.startcra", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.sibservice.enable", None));
  Util.addIfNotNone(properties, "configurationReloadEnabled", roleProperties.optString("websphere.sibservice.configurationreloadenabled", None));
  print "Creating SIBService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBService", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIBService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('SIBService')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibservice.startcra", None), "startCRA","SIBService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibservice.enable", None), "enable","SIBService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibservice.configurationreloadenabled", None), "configurationReloadEnabled","SIBService");
  if len(atts) != 0:
    print "Modifying SIBService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBService configuration up to date.";

  Property.removeProperties(objid, 'properties',"SIBService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIBService');
