from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIPRoutingRule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIPRoutingRule");
  exportedObject.put("roleName", "WebSphereSIPRoutingRule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siproutingrule.isenabled", objid, "isEnabled","SIPRoutingRule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.siproutingrule.clustername", objid, "clusterName","SIPRoutingRule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SIPRoutingRule");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIPRoutingRule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIPRoutingRule')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIPRoutingRule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "isEnabled", roleProperties.optString("websphere.siproutingrule.isenabled", None));
  Util.addIfNotNone(properties, "clusterName", roleProperties.optString("websphere.siproutingrule.clustername", None));
  print "Creating SIPRoutingRule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIPRoutingRule", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIPRoutingRule');

def update(objid,jsonobject):
  Util.pushPathElement('SIPRoutingRule')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIPRoutingRule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siproutingrule.isenabled", None), "isEnabled","SIPRoutingRule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.siproutingrule.clustername", None), "clusterName","SIPRoutingRule");
  if len(atts) != 0:
    print "Modifying SIPRoutingRule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIPRoutingRule configuration up to date.";

  Property.removeProperties(objid, 'properties',"SIPRoutingRule");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIPRoutingRule');
