from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AuthenticationTarget')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAuthenticationTarget");
  exportedObject.put("roleName", "WebSphereAuthenticationTarget");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authenticationtarget.realmname", objid, "realmName","AuthenticationTarget");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authenticationtarget.password", objid, "password","AuthenticationTarget");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authenticationtarget.enabled", objid, "enabled","AuthenticationTarget");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authenticationtarget.userid", objid, "userId","AuthenticationTarget");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AuthenticationTarget');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AuthenticationTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthenticationTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "realmName", roleProperties.optString("websphere.authenticationtarget.realmname", None));
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.authenticationtarget.password", None));
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.authenticationtarget.enabled", None));
  Util.addIfNotNone(properties, "userId", roleProperties.optString("websphere.authenticationtarget.userid", None));
  print "Creating AuthenticationTarget with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AuthenticationTarget", parentid, properties);
  Util.popPathElement('AuthenticationTarget');

def update(objid,jsonobject):
  Util.pushPathElement('AuthenticationTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthenticationTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authenticationtarget.realmname", None), "realmName","AuthenticationTarget");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authenticationtarget.password", None), "password","AuthenticationTarget");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authenticationtarget.enabled", None), "enabled","AuthenticationTarget");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authenticationtarget.userid", None), "userId","AuthenticationTarget");
  if len(atts) != 0:
    print "Modifying AuthenticationTarget with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AuthenticationTarget configuration up to date.";

  Util.popPathElement('AuthenticationTarget');
