from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CTIGateway')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCTIGateway");
  exportedObject.put("roleName", "WebSphereCTIGateway");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ctigateway.gatewayaddress", objid, "gatewayAddress","CTIGateway");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ctigateway.gatewayprotocol", objid, "gatewayProtocol","CTIGateway");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ctigateway.gatewayport", objid, "gatewayPort","CTIGateway");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ctigateway.extractusernamefromrequest", objid, "extractUsernameFromRequest","CTIGateway");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ctigateway.superusername", objid, "superUsername","CTIGateway");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"CTIGateway");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CTIGateway');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CTIGateway')
  if not jsonobject.has("roleProperties"):
    raise Exception("CTIGateway resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "gatewayAddress", roleProperties.optString("websphere.ctigateway.gatewayaddress", None));
  Util.addIfNotNone(properties, "gatewayProtocol", roleProperties.optString("websphere.ctigateway.gatewayprotocol", None));
  Util.addIfNotNone(properties, "gatewayPort", roleProperties.optString("websphere.ctigateway.gatewayport", None));
  Util.addIfNotNone(properties, "extractUsernameFromRequest", roleProperties.optString("websphere.ctigateway.extractusernamefromrequest", None));
  Util.addIfNotNone(properties, "superUsername", roleProperties.optString("websphere.ctigateway.superusername", None));
  print "Creating CTIGateway with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CTIGateway", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CTIGateway');

def update(objid,jsonobject):
  Util.pushPathElement('CTIGateway')
  if not jsonobject.has("roleProperties"):
    raise Exception("CTIGateway resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ctigateway.gatewayaddress", None), "gatewayAddress","CTIGateway");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ctigateway.gatewayprotocol", None), "gatewayProtocol","CTIGateway");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ctigateway.gatewayport", None), "gatewayPort","CTIGateway");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ctigateway.extractusernamefromrequest", None), "extractUsernameFromRequest","CTIGateway");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ctigateway.superusername", None), "superUsername","CTIGateway");
  if len(atts) != 0:
    print "Modifying CTIGateway with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CTIGateway configuration up to date.";

  Property.removeProperties(objid, 'properties',"CTIGateway");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CTIGateway');
