from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = "websphere.cachingactionref.name"

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CachingActionRef')

  if name == "":
    name = Util.getRequiredAttribute(objid, "name", "CachingAction");
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered CachingActionRef");
  exportedObject.put("roleName", "WebSphereCachingActionRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cachingactionref.name", objid, "name","CachingAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CachingActionRef');
  return result;


def doImport(parentid, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WebSphereCachingActionRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.cachingactionref.name"):
    raise Exception("Resource role properties does not contain websphere.cachingactionref.name!");

  cachingActionRefName = roleProperties.optString("websphere.cachingactionref.name", None);
  serverName = parentid.split('/servers/')[1].split('|')[0];
  if serverName == None or len(serverName) == 0:
    clusterName = parentid.split('/clusters/')[1].split('|')[0];
    containmentPath = "/ServerCluster:" + clusterName + "/ProxyVirtualHostConfig:/CachingAction:" + cachingActionRefName + "/";
  else:
    containmentPath = "/Server:" + serverName + "/ProxyVirtualHostConfig:/CachingAction:" + cachingActionRefName + "/";
  cachingAction = Util.getid(containmentPath);
  if cachingAction == None or len(cachingAction) == 0:
      raise Exception("Could not determine the Caching Action for CachingActionRef " + cachingActionRefName + ". Searched on containment path " + containmentPath + ".");

  Util.pushPathElement("Server");
  Util.pushPathElement("ProxyVirtualHostConfig");
  Util.pushPathElement("ProxyRuleExpression");
  Util.modify(parentid, [['enabledProxyActions', cachingAction]]);
  Util.popPathElement("ProxyRuleExpression");
  Util.popPathElement("ProxyVirtualHostConfig");
  Util.popPathElement("Server");
