from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DPDevice')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDPDevice");
  exportedObject.put("roleName", "WebSphereDPDevice");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdevice.name", objid, "name","DPDevice");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdevice.hlmport", objid, "HLMPort","DPDevice");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdevice.devicetype", objid, "deviceType","DPDevice");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdevice.modeltype", objid, "modelType","DPDevice");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdevice.serialnumber", objid, "serialNumber","DPDevice");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdevice.hostname", objid, "Hostname","DPDevice");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdevice.userid", objid, "userId","DPDevice");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdevice.guiport", objid, "GUIPort","DPDevice");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdevice.featurelicenses", objid, "featureLicenses","DPDevice");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdevice.password", objid, "password","DPDevice");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DPDevice");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DPDevice');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DPDevice')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPDevice resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.dpdevice.name", None));
  Util.addIfNotNone(properties, "HLMPort", roleProperties.optString("websphere.dpdevice.hlmport", None));
  Util.addIfNotNone(properties, "deviceType", roleProperties.optString("websphere.dpdevice.devicetype", None));
  Util.addIfNotNone(properties, "modelType", roleProperties.optString("websphere.dpdevice.modeltype", None));
  Util.addIfNotNone(properties, "serialNumber", roleProperties.optString("websphere.dpdevice.serialnumber", None));
  Util.addIfNotNone(properties, "Hostname", roleProperties.optString("websphere.dpdevice.hostname", None));
  Util.addIfNotNone(properties, "userId", roleProperties.optString("websphere.dpdevice.userid", None));
  Util.addIfNotNone(properties, "GUIPort", roleProperties.optString("websphere.dpdevice.guiport", None));
  Util.addIfNotNone(properties, "featureLicenses", roleProperties.optString("websphere.dpdevice.featurelicenses", None));
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.dpdevice.password", None));
  print "Creating DPDevice with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DPDevice", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPDevice');

def update(objid,jsonobject):
  Util.pushPathElement('DPDevice')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPDevice resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdevice.name", None), "name","DPDevice");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdevice.hlmport", None), "HLMPort","DPDevice");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdevice.devicetype", None), "deviceType","DPDevice");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdevice.modeltype", None), "modelType","DPDevice");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdevice.serialnumber", None), "serialNumber","DPDevice");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdevice.hostname", None), "Hostname","DPDevice");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdevice.userid", None), "userId","DPDevice");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdevice.guiport", None), "GUIPort","DPDevice");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdevice.featurelicenses", None), "featureLicenses","DPDevice");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdevice.password", None), "password","DPDevice");
  if len(atts) != 0:
    print "Modifying DPDevice with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DPDevice configuration up to date.";

  Property.removeProperties(objid, 'properties',"DPDevice");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPDevice');
