from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GenericServerEndpoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGenericServerEndpoint");
  exportedObject.put("roleName", "WebSphereGenericServerEndpoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericserverendpoint.port", objid, "port","GenericServerEndpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericserverendpoint.host", objid, "host","GenericServerEndpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericserverendpoint.weight", objid, "weight","GenericServerEndpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericserverendpoint.protocol", objid, "protocol","GenericServerEndpoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"GenericServerEndpoint");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GenericServerEndpoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GenericServerEndpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericServerEndpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.genericserverendpoint.port", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.genericserverendpoint.host", None));
  Util.addIfNotNone(properties, "weight", roleProperties.optString("websphere.genericserverendpoint.weight", None));
  Util.addIfNotNone(properties, "protocol", roleProperties.optString("websphere.genericserverendpoint.protocol", None));
  print "Creating GenericServerEndpoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GenericServerEndpoint", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('GenericServerEndpoint');

def update(objid,jsonobject):
  Util.pushPathElement('GenericServerEndpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericServerEndpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericserverendpoint.port", None), "port","GenericServerEndpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericserverendpoint.host", None), "host","GenericServerEndpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericserverendpoint.weight", None), "weight","GenericServerEndpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericserverendpoint.protocol", None), "protocol","GenericServerEndpoint");
  if len(atts) != 0:
    print "Modifying GenericServerEndpoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GenericServerEndpoint configuration up to date.";

  Property.removeProperties(objid, 'properties',"GenericServerEndpoint");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('GenericServerEndpoint');
