from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('InboundTransportChannel')

  name = Util.getRequiredAttribute(objid, "name", 'InboundTransportChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereInboundTransportChannel");
  exportedObject.put("roleName", "WebSphereInboundTransportChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.inboundtransportchannel.name", objid, "name","InboundTransportChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.inboundtransportchannel.discriminationweight", objid, "discriminationWeight","InboundTransportChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"InboundTransportChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('InboundTransportChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('InboundTransportChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("InboundTransportChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.inboundtransportchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.inboundtransportchannel.discriminationweight", None));
  print "Creating InboundTransportChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("InboundTransportChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('InboundTransportChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('InboundTransportChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("InboundTransportChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.inboundtransportchannel.name", None), "name","InboundTransportChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.inboundtransportchannel.discriminationweight", None), "discriminationWeight","InboundTransportChannel");
  if len(atts) != 0:
    print "Modifying InboundTransportChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "InboundTransportChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"InboundTransportChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('InboundTransportChannel');
