from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JAXWSHandler')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJAXWSHandler");
  exportedObject.put("roleName", "WebSphereJAXWSHandler");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaxwshandler.name", objid, "name","JAXWSHandler");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaxwshandler.description", objid, "description","JAXWSHandler");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaxwshandler.handlerclassname", objid, "handlerClassName","JAXWSHandler");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JAXWSHandler');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('JAXWSHandler')
  if not jsonobject.has("roleProperties"):
    raise Exception("JAXWSHandler resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.jaxwshandler.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.jaxwshandler.description", None));
  Util.addIfNotNone(properties, "handlerClassName", roleProperties.optString("websphere.jaxwshandler.handlerclassname", None));
  print "Creating JAXWSHandler with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JAXWSHandler", parentid, properties);
  Util.popPathElement('JAXWSHandler');

def update(objid,jsonobject):
  Util.pushPathElement('JAXWSHandler')
  if not jsonobject.has("roleProperties"):
    raise Exception("JAXWSHandler resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaxwshandler.name", None), "name","JAXWSHandler");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaxwshandler.description", None), "description","JAXWSHandler");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaxwshandler.handlerclassname", None), "handlerClassName","JAXWSHandler");
  if len(atts) != 0:
    print "Modifying JAXWSHandler with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JAXWSHandler configuration up to date.";

  Util.popPathElement('JAXWSHandler');
