from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('LifecycleCallbackType')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLifecycleCallbackType");
  exportedObject.put("roleName", "WebSphereLifecycleCallbackType");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.lifecyclecallbacktype.methodname", objid, "methodName","LifecycleCallbackType");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LifecycleCallbackType');
  return result;



def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('LifecycleCallbackType')
  if not jsonobject.has("roleProperties"):
    raise Exception("LifecycleCallbackType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "methodName", roleProperties.optString("websphere.lifecyclecallbacktype.methodname", None));
  print "Creating LifecycleCallbackType with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("LifecycleCallbackType", parentid, properties, attName);
  Util.popPathElement('LifecycleCallbackType');

def update(objid,jsonobject):
  Util.pushPathElement('LifecycleCallbackType')
  if not jsonobject.has("roleProperties"):
    raise Exception("LifecycleCallbackType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.lifecyclecallbacktype.methodname", None), "methodName","LifecycleCallbackType");
  if len(atts) != 0:
    print "Modifying LifecycleCallbackType with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "LifecycleCallbackType configuration up to date.";

  Util.popPathElement('LifecycleCallbackType');
