from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MessageQOP')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMessageQOP");
  exportedObject.put("roleName", "WebSphereMessageQOP");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messageqop.establishtrustinclient", objid, "establishTrustInClient","MessageQOP");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messageqop.enablereplaydetection", objid, "enableReplayDetection","MessageQOP");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messageqop.enableoutofsequencedetection", objid, "enableOutOfSequenceDetection","MessageQOP");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MessageQOP');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MessageQOP')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageQOP resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "establishTrustInClient", roleProperties.optString("websphere.messageqop.establishtrustinclient", None));
  Util.addIfNotNone(properties, "enableReplayDetection", roleProperties.optString("websphere.messageqop.enablereplaydetection", None));
  Util.addIfNotNone(properties, "enableOutOfSequenceDetection", roleProperties.optString("websphere.messageqop.enableoutofsequencedetection", None));
  print "Creating MessageQOP with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MessageQOP", parentid, properties);
  Util.popPathElement('MessageQOP');

def update(objid,jsonobject):
  Util.pushPathElement('MessageQOP')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageQOP resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messageqop.establishtrustinclient", None), "establishTrustInClient","MessageQOP");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messageqop.enablereplaydetection", None), "enableReplayDetection","MessageQOP");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messageqop.enableoutofsequencedetection", None), "enableOutOfSequenceDetection","MessageQOP");
  if len(atts) != 0:
    print "Modifying MessageQOP with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MessageQOP configuration up to date.";

  Util.popPathElement('MessageQOP');
