from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('NamingContext')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereNamingContext");
  exportedObject.put("roleName", "WebSphereNamingContext");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.namingcontext.contextid", objid, "contextId","NamingContext");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.namingcontext.parentcontextid", objid, "parentContextId","NamingContext");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('NamingContext');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('NamingContext')
  if not jsonobject.has("roleProperties"):
    raise Exception("NamingContext resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "contextId", roleProperties.optString("websphere.namingcontext.contextid", None));
  Util.addIfNotNone(properties, "parentContextId", roleProperties.optString("websphere.namingcontext.parentcontextid", None));
  print "Creating NamingContext with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("NamingContext", parentid, properties);
  Util.popPathElement('NamingContext');

def update(objid,jsonobject):
  Util.pushPathElement('NamingContext')
  if not jsonobject.has("roleProperties"):
    raise Exception("NamingContext resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.namingcontext.contextid", None), "contextId","NamingContext");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.namingcontext.parentcontextid", None), "parentContextId","NamingContext");
  if len(atts) != 0:
    print "Modifying NamingContext with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "NamingContext configuration up to date.";

  Util.popPathElement('NamingContext');
