from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.LoginMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscommonbnd.LoginMapping");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscommonbnd.LoginMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonbnd.loginmapping.authmethod", objid, "authMethod","com.ibm.etools.webservice.wscommonbnd.LoginMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonbnd.loginmapping.makesoapmessageavailable", objid, "makeSOAPMessageAvailable","com.ibm.etools.webservice.wscommonbnd.LoginMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonbnd.loginmapping.configname", objid, "configName","com.ibm.etools.webservice.wscommonbnd.LoginMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"com.ibm.etools.webservice.wscommonbnd.LoginMapping");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.LoginMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.LoginMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonbnd.LoginMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "authMethod", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.loginmapping.authmethod", None));
  Util.addIfNotNone(properties, "makeSOAPMessageAvailable", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.loginmapping.makesoapmessageavailable", None));
  Util.addIfNotNone(properties, "configName", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.loginmapping.configname", None));
  print "Creating com.ibm.etools.webservice.wscommonbnd.LoginMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscommonbnd.LoginMapping", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.LoginMapping');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.LoginMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonbnd.LoginMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.loginmapping.authmethod", None), "authMethod","com.ibm.etools.webservice.wscommonbnd.LoginMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.loginmapping.makesoapmessageavailable", None), "makeSOAPMessageAvailable","com.ibm.etools.webservice.wscommonbnd.LoginMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.loginmapping.configname", None), "configName","com.ibm.etools.webservice.wscommonbnd.LoginMapping");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscommonbnd.LoginMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscommonbnd.LoginMapping configuration up to date.";

  Property.removeProperties(objid, 'properties',"com.ibm.etools.webservice.wscommonbnd.LoginMapping");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.LoginMapping');
