/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.client.rest.internal;

import com.ibm.ws.jmx.connector.client.rest.internal.NotificationListenerEntry;
import com.ibm.ws.jmx.connector.client.rest.internal.RESTMBeanServerConnection;
import com.ibm.ws.jmx.connector.client.rest.internal.resources.RESTClientMessagesUtil;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.ConversionException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;

public class Connector
implements JMXConnector {
    private static final Logger logger = Logger.getLogger(Connector.class.getName());
    private final JMXServiceURL serviceURL;
    private Map<String, ?> environment;
    private long connectionId;
    private List<String> wlmList;
    private String currentEndpoint;
    private boolean hostnameVerificationDisabled;
    private int notificationDeliveryInterval;
    private int notificationFetchInterval;
    private int notificationInboxExpiry;
    private int readTimeout;
    private int notificationReadTimeout;
    private int serverFailoverInterval;
    private int maxServerWaitTime;
    private int serverStatusPollingInterval;
    private String user;
    private String basicAuthHeader = null;
    private RESTMBeanServerConnection connection = null;
    private boolean closed = false;
    private List<NotificationListenerEntry> connectionListeners = null;
    private static long nextConnectionNumber = 1L;
    private SSLSocketFactory customSSLSocketFactory = null;
    private static long nextNotificationNumber = 1L;

    public SSLSocketFactory getCustomSSLSocketFactory() {
        return this.customSSLSocketFactory;
    }

    public void setCustomSSLSocketFactory(SSLSocketFactory customSSLSocketFactory) {
        this.customSSLSocketFactory = customSSLSocketFactory;
    }

    private static synchronized long getConnectionNumber() {
        return nextConnectionNumber++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNotificationNumber() {
        Class<Connector> clazz = Connector.class;
        synchronized (Connector.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return nextNotificationNumber++;
        }
    }

    public Connector(JMXServiceURL serviceURL, Map<String, ?> environment) {
        this.serviceURL = serviceURL;
        this.environment = environment;
        if (serviceURL == null) {
            throw new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.illegal.argument", new Object[0]));
        }
        this.wlmList = new ArrayList<String>();
        this.wlmList.add(serviceURL.getHost() + ":" + serviceURL.getPort());
    }

    @Override
    public void connect() throws IOException {
        this.connect(null);
    }

    private Object getCredentials() {
        Object credentials = this.environment.get("jmx.remote.credentials");
        if (credentials != null) {
            return credentials;
        }
        credentials = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("jmx.remote.credentials");
            }
        });
        return credentials;
    }

    private boolean getBooleanSetting(final String key, boolean defaultValue) {
        Object setting;
        if (this.environment != null && (setting = this.environment.get(key)) != null && setting instanceof Boolean) {
            return (Boolean)setting;
        }
        setting = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
        if (setting != null) {
            return Boolean.parseBoolean(setting);
        }
        return defaultValue;
    }

    private int getIntegerSetting(final String key, int defaultValue) {
        Object setting;
        if (this.environment != null && (setting = this.environment.get(key)) != null && setting instanceof Integer) {
            return (Integer)setting;
        }
        setting = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
        if (setting != null) {
            try {
                return Integer.parseInt(setting);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private void validatePossibleEndpoint(String possibleEndpoint) throws IllegalArgumentException {
        if (!possibleEndpoint.contains(":")) {
            throw new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.invalid.endpoint", possibleEndpoint));
        }
        String[] components = possibleEndpoint.split(":");
        if (components.length != 2) {
            throw new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.invalid.endpoint", possibleEndpoint));
        }
        try {
            Integer.valueOf(components[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.invalid.endpoint", possibleEndpoint));
        }
    }

    private void validateEndpointList(List<?> list) throws IllegalArgumentException {
        if (list.isEmpty()) {
            return;
        }
        for (Object element : list) {
            if (element == null) {
                throw new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.invalid.endpoint", "null"));
            }
            if (element instanceof String) {
                String elemStr = (String)element;
                this.validatePossibleEndpoint((String)element);
                if (this.wlmList.contains(elemStr)) continue;
                this.wlmList.add(elemStr);
                continue;
            }
            throw new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.invalid.endpoint", element.toString()));
        }
        if (this.wlmList.size() > 1) {
            Collections.shuffle(this.wlmList, new Random(System.currentTimeMillis()));
        }
        this.wlmList = Collections.unmodifiableList(this.wlmList);
    }

    List<String> getEndpointList() {
        return this.wlmList;
    }

    @Override
    public synchronized void connect(Map<String, ?> env) throws IOException {
        Object credentials;
        if (this.closed) {
            throw new IOException();
        }
        if (this.connection != null) {
            return;
        }
        if (env != null) {
            this.environment = env;
        }
        if (!this.areRequiedCredentialsSet(credentials = this.getCredentials())) {
            throw new IOException("jmx.remote.credentials not provided. Set to a String[2] {user,password}.");
        }
        if (!"com.ibm.ws.jmx.connector.client.CLIENT_CERT_AUTH".equals(credentials)) {
            String[] userPass = (String[])credentials;
            this.user = userPass[0];
            JSONConverter converter = JSONConverter.getConverter();
            try {
                this.basicAuthHeader = "Basic " + converter.encodeStringAsBase64(this.user + ":" + userPass[1]);
            }
            catch (ConversionException ce) {
                throw new IOException("Failure encoding credentials", ce);
            }
            finally {
                JSONConverter.returnConverter(converter);
            }
        }
        this.hostnameVerificationDisabled = this.getBooleanSetting("com.ibm.ws.jmx.connector.client.disableURLHostnameVerification", false);
        this.notificationDeliveryInterval = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.notificationDeliveryInterval", 0);
        this.notificationFetchInterval = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.notificationFetchInterval", 1000);
        this.notificationInboxExpiry = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.notificationInboxExpiry", 300000);
        this.readTimeout = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.readTimeout", 60000);
        this.notificationReadTimeout = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.notificationReadTimeout", this.notificationDeliveryInterval > 0 ? 2 * this.notificationDeliveryInterval : 60000);
        this.serverFailoverInterval = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.failoverInterval", 30000);
        this.maxServerWaitTime = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.maxServerWaitTime", 120000);
        this.serverStatusPollingInterval = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.serverStatusPollingInterval", 4000);
        Object list = this.environment.get("com.ibm.ws.jmx.connector.client.wlm.endpoints");
        if (list != null && list instanceof List) {
            this.validateEndpointList((List)list);
        }
        if (logger.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Endpoints:");
            for (String endpoint : this.wlmList) {
                sb.append(endpoint);
                sb.append("  ");
            }
            logger.logp(Level.FINER, logger.getName(), "connect", sb.toString());
            if (logger.isLoggable(Level.FINEST)) {
                sb = new StringBuilder();
                sb.append("notificationDeliveryInterval");
                sb.append("=");
                sb.append(this.notificationDeliveryInterval);
                sb.append("\n");
                sb.append("notificationFetchInterval");
                sb.append("=");
                sb.append(this.notificationFetchInterval);
                sb.append("\n");
                sb.append("notificationInboxExpiry");
                sb.append("=");
                sb.append(this.notificationInboxExpiry);
                sb.append("\n");
                sb.append("readTimeout");
                sb.append("=");
                sb.append(this.readTimeout);
                sb.append("\n");
                sb.append("notificationReadTimeout");
                sb.append("=");
                sb.append(this.notificationReadTimeout);
                sb.append("\n");
                sb.append("serverFailoverInterval");
                sb.append("=");
                sb.append(this.serverFailoverInterval);
                sb.append("\n");
                sb.append("maxServerWaitTime");
                sb.append("=");
                sb.append(this.maxServerWaitTime);
                sb.append("\n");
                sb.append("serverStatusPollingInterval");
                sb.append("=");
                sb.append(this.serverStatusPollingInterval);
                sb.append("\n");
                logger.logp(Level.FINEST, logger.getName(), "connect", sb.toString());
            }
        }
        this.connectionId = Connector.getConnectionNumber();
        Object o = this.environment.get("com.ibm.ws.jmx.connector.client.CUSTOM_SSLSOCKETFACTORY");
        if (o != null && o instanceof SSLSocketFactory) {
            SSLSocketFactory sslf = (SSLSocketFactory)o;
            this.setCustomSSLSocketFactory(sslf);
        }
        this.environment = null;
        this.connection = new RESTMBeanServerConnection(this);
        this.connectionOpened();
    }

    private boolean areRequiedCredentialsSet(Object credentials) {
        if (credentials == null) {
            return false;
        }
        if ("com.ibm.ws.jmx.connector.client.CLIENT_CERT_AUTH".equals(credentials)) {
            return true;
        }
        return credentials instanceof String[] && ((String[])credentials).length == 2;
    }

    @Override
    public synchronized MBeanServerConnection getMBeanServerConnection() throws IOException {
        if (this.connection == null) {
            throw new IOException();
        }
        return this.connection;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        throw new IOException();
    }

    @Override
    public synchronized void close() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "close", "Closing connector");
        }
        if (!this.closed) {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
            this.closed = true;
            if (this.connectionListeners != null) {
                JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.closed", this, this.getConnectionId(), Connector.getNotificationNumber(), null, null);
                for (NotificationListenerEntry entry : this.connectionListeners) {
                    entry.handleNotification(notification);
                }
            }
        }
    }

    synchronized void connectionOpened() {
        if (this.connectionListeners != null) {
            JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.opened", this, this.getConnectionId(), Connector.getNotificationNumber(), null, null);
            for (NotificationListenerEntry entry : this.connectionListeners) {
                entry.handleNotification(notification);
            }
        }
    }

    synchronized void connectionFailed(Throwable t) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "connectionFailed", "Failed connection: " + t);
        }
        this.closed = true;
        if (this.connectionListeners != null) {
            JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.failed", this, this.getConnectionId(), Connector.getNotificationNumber(), RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.failed", new Object[0]), t);
            for (NotificationListenerEntry entry : this.connectionListeners) {
                entry.handleNotification(notification);
            }
        }
    }

    synchronized void notificationLost(Notification n) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "notificationLost", "Lost notification: " + n);
        }
        if (this.connectionListeners != null) {
            JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.notifs.lost", this, this.getConnectionId(), Connector.getNotificationNumber(), RESTClientMessagesUtil.getMessage("jmx.rest.client.notification.lost", new Object[0]), n);
            for (NotificationListenerEntry entry : this.connectionListeners) {
                entry.handleNotification(notification);
            }
        }
    }

    synchronized void connectionTemporarilyLost(Throwable t) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "connectionTemporarilyLost", "Lost connection:" + t.getMessage());
        }
        if (this.connectionListeners != null) {
            JMXConnectionNotification notification = new JMXConnectionNotification("com.ibm.ws.jmx.connector.client.rest.connectionTemporarilyLost", this, this.getConnectionId(), Connector.getNotificationNumber(), RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.temporarily.lost", new Object[0]), t);
            for (NotificationListenerEntry entry : this.connectionListeners) {
                entry.handleNotification(notification);
            }
        }
    }

    synchronized void connectionRestored(Exception[] exceptions) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "connectionRestored", "Connection restored");
        }
        if (this.connectionListeners != null) {
            JMXConnectionNotification notification = exceptions != null ? new JMXConnectionNotification("com.ibm.ws.jmx.connector.client.rest.connectionRestoredWithExceptions", this, this.getConnectionId(), Connector.getNotificationNumber(), RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.restored.with.exceptions", new Object[0]), exceptions) : new JMXConnectionNotification("com.ibm.ws.jmx.connector.client.rest.connectionRestored", this, this.getConnectionId(), Connector.getNotificationNumber(), RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.restored", new Object[0]), null);
            for (NotificationListenerEntry entry : this.connectionListeners) {
                entry.handleNotification(notification);
            }
        }
    }

    @Override
    public synchronized void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addConnectionNotificationListener", "listener: " + listener + " | filter: " + filter + " | handback: " + handback);
        }
        if (this.connectionListeners == null) {
            this.connectionListeners = new ArrayList<NotificationListenerEntry>();
        }
        this.connectionListeners.add(new NotificationListenerEntry(listener, filter, handback));
    }

    @Override
    public synchronized void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "removeConnectionNotificationListener", "listener: " + listener);
        }
        boolean listenerFound = false;
        if (this.connectionListeners != null) {
            Iterator<NotificationListenerEntry> entryIterator = this.connectionListeners.iterator();
            while (entryIterator.hasNext()) {
                if (entryIterator.next().listener != listener) continue;
                listenerFound = true;
                entryIterator.remove();
            }
        }
        if (!listenerFound) {
            throw new ListenerNotFoundException();
        }
    }

    @Override
    public synchronized void removeConnectionNotificationListener(NotificationListener l, NotificationFilter f, Object handback) throws ListenerNotFoundException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "removeConnectionNotificationListener", "listener: " + l + " | filter: " + f + " | handback: " + handback);
        }
        boolean listenerFound = false;
        if (this.connectionListeners != null) {
            listenerFound = this.connectionListeners.remove(new NotificationListenerEntry(l, f, handback));
        }
        if (!listenerFound) {
            throw new ListenerNotFoundException();
        }
    }

    @Override
    public synchronized String getConnectionId() {
        return this.serviceURL.getProtocol() + ":" + this.getCurrentEndpoint() + " " + this.user + " " + this.connectionId;
    }

    JMXServiceURL getServiceURL() {
        return this.serviceURL;
    }

    boolean isHostnameVerificationDisabled() {
        return this.hostnameVerificationDisabled;
    }

    int getNotificationDeliveryInterval() {
        return this.notificationDeliveryInterval;
    }

    int getNotificationFetchInterval() {
        return this.notificationFetchInterval;
    }

    int getNotificationInboxExpiry() {
        return this.notificationInboxExpiry;
    }

    int getReadTimeout() {
        return this.readTimeout;
    }

    int getNotificationReadTimeout() {
        return this.notificationReadTimeout;
    }

    int getMaxServerWaitTime() {
        return this.maxServerWaitTime;
    }

    int getServerFailoverInterval() {
        return this.serverFailoverInterval;
    }

    int getServerStatusPollingInterval() {
        return this.serverStatusPollingInterval;
    }

    String getBasicAuthHeader() {
        return this.basicAuthHeader;
    }

    String getCurrentEndpoint() {
        return this.currentEndpoint;
    }

    void setCurrentEndpoint(String currentEndpoint) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setCurrentEndpoint", "Changing endpoint from " + this.currentEndpoint + " to " + currentEndpoint);
        }
        this.currentEndpoint = currentEndpoint;
    }
}

