/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphereliberty.WebSphereLibertyJMXHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1])

def props = apTool.getStepProperties();

/* All properties are required */
def zipFile = props['zipFile'].trim();
def installDir = props['installDir'].trim();
def targetHost = props['targetHost'].trim();
def controllerHostName = props['controllerHostName'].trim();
def controllerPort = props['controllerPort'].trim();
def adminUser = props['adminUser'].trim();
def adminPassword = props['adminPassword'].trim();
def trustStorePath = props['trustStorePath'].trim();
def trustStorePassword = props['trustStorePassword'].trim();

def jmxHelper = new WebSphereLibertyJMXHelper(adminUser, adminPassword, controllerHostName, controllerPort, trustStorePath, trustStorePassword);
jmxHelper.uploadFileToCollectiveHost(targetHost, zipFile, installDir, zipFile.endsWith(".zip"));


