/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.client.rest.internal;

import com.ibm.ws.jmx.connector.client.rest.internal.NotificationListenerEntry;
import com.ibm.ws.jmx.connector.client.rest.internal.RESTMBeanServerConnection;
import com.ibm.ws.jmx.connector.client.rest.internal.resources.RESTClientMessagesUtil;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.ConversionException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

public class Connector
implements JMXConnector {
    private final JMXServiceURL serviceURL;
    private Map<String, ?> environment;
    private boolean hostnameVerificationDisabled;
    private int notificationDeliveryInterval;
    private int notificationInboxExpiry;
    private int readTimeout;
    private int notificationReadTimeout;
    private int maxServerWaitTime;
    private int serverStatusPollingInterval;
    private String user;
    private String basicAuthHeader;
    private RESTMBeanServerConnection connection;
    private boolean closed;
    private String connectionId;
    private List<NotificationListenerEntry> connectionListeners;
    private static long nextConnectionNumber = 1L;
    private static long nextNotificationNumber = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getConnectionNumber() {
        Class<Connector> clazz = Connector.class;
        synchronized (Connector.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return nextConnectionNumber++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNotificationNumber() {
        Class<Connector> clazz = Connector.class;
        synchronized (Connector.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return nextNotificationNumber++;
        }
    }

    public Connector(JMXServiceURL serviceURL, Map<String, ?> environment) {
        this.serviceURL = serviceURL;
        this.environment = environment;
    }

    @Override
    public void connect() throws IOException {
        this.connect(null);
    }

    private boolean getBooleanSetting(final String key, boolean defaultValue) {
        Object setting;
        if (this.environment != null && (setting = this.environment.get(key)) != null && setting instanceof Boolean) {
            return (Boolean)setting;
        }
        setting = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
        if (setting != null) {
            return Boolean.parseBoolean(setting);
        }
        return defaultValue;
    }

    private int getIntegerSetting(final String key, int defaultValue) {
        Object setting;
        if (this.environment != null && (setting = this.environment.get(key)) != null && setting instanceof Integer) {
            return (Integer)setting;
        }
        setting = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
        if (setting != null) {
            try {
                return Integer.parseInt(setting);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public synchronized void connect(Map<String, ?> env) throws IOException {
        Object credentials;
        if (this.closed) {
            throw new IOException();
        }
        if (this.connection != null) {
            return;
        }
        if (env != null) {
            this.environment = env;
        }
        if ((credentials = this.environment.get("jmx.remote.credentials")) == null || !(credentials instanceof String[]) || ((String[])credentials).length != 2) {
            throw new IOException("jmx.remote.credentials not provided");
        }
        String[] userPass = (String[])credentials;
        this.user = userPass[0];
        JSONConverter converter = JSONConverter.getConverter();
        try {
            this.basicAuthHeader = "Basic " + converter.encodeStringAsBase64(this.user + ":" + userPass[1]);
        }
        catch (ConversionException ce) {
            throw new IOException("Failure encoding credentials", ce);
        }
        finally {
            JSONConverter.returnConverter(converter);
        }
        this.hostnameVerificationDisabled = this.getBooleanSetting("com.ibm.ws.jmx.connector.client.disableURLHostnameVerification", false);
        this.notificationDeliveryInterval = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.notificationDeliveryInterval", 60000);
        this.notificationInboxExpiry = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.notificationInboxExpiry", 300000);
        this.readTimeout = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.readTimeout", 60000);
        this.notificationReadTimeout = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.notificationReadTimeout", 120000);
        this.maxServerWaitTime = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.maxServerWaitTime", 120000);
        this.serverStatusPollingInterval = this.getIntegerSetting("com.ibm.ws.jmx.connector.client.rest.serverStatusPollingInterval", 4000);
        this.environment = null;
        int port = this.serviceURL.getPort();
        this.connectionId = this.serviceURL.getProtocol() + ":" + this.serviceURL.getHost() + (port > 0 ? ":" + this.serviceURL.getPort() : "") + " " + this.user + " " + Connector.getConnectionNumber();
        this.connection = new RESTMBeanServerConnection(this);
        if (this.connectionListeners != null) {
            JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.opened", this, this.connectionId, Connector.getNotificationNumber(), null, null);
            for (NotificationListenerEntry entry : this.connectionListeners) {
                entry.handleNotification(notification);
            }
        }
    }

    @Override
    public synchronized MBeanServerConnection getMBeanServerConnection() throws IOException {
        if (this.connection == null) {
            throw new IOException();
        }
        return this.connection;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        throw new IOException();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.connection.close();
            this.connection = null;
            this.closed = true;
            if (this.connectionListeners != null) {
                JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.closed", this, this.connectionId, Connector.getNotificationNumber(), null, null);
                for (NotificationListenerEntry entry : this.connectionListeners) {
                    entry.handleNotification(notification);
                }
            }
        }
    }

    synchronized void connectionFailed(Throwable t) {
        this.closed = true;
        if (this.connectionListeners != null) {
            JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.failed", this, this.connectionId, Connector.getNotificationNumber(), RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.failed", new Object[0]), t);
            for (NotificationListenerEntry entry : this.connectionListeners) {
                entry.handleNotification(notification);
            }
        }
    }

    synchronized void notificationLost(Notification n) {
        if (this.connectionListeners != null) {
            JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.notifs.lost", this, this.connectionId, Connector.getNotificationNumber(), RESTClientMessagesUtil.getMessage("jmx.rest.client.notification.lost", new Object[0]), n);
            for (NotificationListenerEntry entry : this.connectionListeners) {
                entry.handleNotification(notification);
            }
        }
    }

    synchronized void connectionTemporarilyLost(Throwable t) {
        if (this.connectionListeners != null) {
            JMXConnectionNotification notification = new JMXConnectionNotification("com.ibm.ws.jmx.connector.client.rest.connectionTemporarilyLost", this, this.connectionId, Connector.getNotificationNumber(), RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.temporarily.lost", new Object[0]), t);
            for (NotificationListenerEntry entry : this.connectionListeners) {
                entry.handleNotification(notification);
            }
        }
    }

    synchronized void connectionRestored(Exception[] exceptions) {
        if (this.connectionListeners != null) {
            JMXConnectionNotification notification = exceptions != null ? new JMXConnectionNotification("com.ibm.ws.jmx.connector.client.rest.connectionRestoredWithExceptions", this, this.connectionId, Connector.getNotificationNumber(), RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.restored.with.exceptions", new Object[0]), exceptions) : new JMXConnectionNotification("com.ibm.ws.jmx.connector.client.rest.connectionRestored", this, this.connectionId, Connector.getNotificationNumber(), RESTClientMessagesUtil.getMessage("jmx.rest.client.connection.restored", new Object[0]), null);
            for (NotificationListenerEntry entry : this.connectionListeners) {
                entry.handleNotification(notification);
            }
        }
    }

    @Override
    public synchronized void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new ArrayList<NotificationListenerEntry>();
        }
        this.connectionListeners.add(new NotificationListenerEntry(listener, filter, handback));
    }

    @Override
    public synchronized void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        boolean listenerFound = false;
        if (this.connectionListeners != null) {
            Iterator<NotificationListenerEntry> entryIterator = this.connectionListeners.iterator();
            while (entryIterator.hasNext()) {
                if (entryIterator.next().listener != listener) continue;
                listenerFound = true;
                entryIterator.remove();
            }
        }
        if (!listenerFound) {
            throw new ListenerNotFoundException();
        }
    }

    @Override
    public synchronized void removeConnectionNotificationListener(NotificationListener l, NotificationFilter f, Object handback) throws ListenerNotFoundException {
        boolean listenerFound = false;
        if (this.connectionListeners != null) {
            listenerFound = this.connectionListeners.remove(new NotificationListenerEntry(l, f, handback));
        }
        if (!listenerFound) {
            throw new ListenerNotFoundException();
        }
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    JMXServiceURL getServiceURL() {
        return this.serviceURL;
    }

    boolean isHostnameVerificationDisabled() {
        return this.hostnameVerificationDisabled;
    }

    int getNotificationDeliveryInterval() {
        return this.notificationDeliveryInterval;
    }

    int getNotificationInboxExpiry() {
        return this.notificationInboxExpiry;
    }

    int getReadTimeout() {
        return this.readTimeout;
    }

    int getNotificationReadTimeout() {
        return this.notificationReadTimeout;
    }

    int getMaxServerWaitTime() {
        return this.maxServerWaitTime;
    }

    int getServerStatusPollingInterval() {
        return this.serverStatusPollingInterval;
    }

    String getBasicAuthHeader() {
        return this.basicAuthHeader;
    }
}

