/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.client.rest.internal;

import com.ibm.ws.jmx.connector.client.rest.internal.ClientConstants;
import com.ibm.ws.jmx.connector.client.rest.internal.DelayedURL;
import com.ibm.ws.jmx.connector.client.rest.internal.NotificationListenerEntry;
import com.ibm.ws.jmx.connector.client.rest.internal.ObjectIdentityCache;
import com.ibm.ws.jmx.connector.client.rest.internal.RESTMBeanServerConnection;
import com.ibm.ws.jmx.connector.client.rest.internal.ServerNotificationListenerEntry;
import com.ibm.ws.jmx.connector.client.rest.internal.resources.RESTClientMessagesUtil;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.NotificationArea;
import com.ibm.ws.jmx.connector.datatypes.NotificationRegistration;
import com.ibm.ws.jmx.connector.datatypes.NotificationSettings;
import com.ibm.ws.jmx.connector.datatypes.ServerNotificationRegistration;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.RuntimeOperationsException;
import javax.net.ssl.HttpsURLConnection;

class NotificationRegistry {
    private static final Logger logger = Logger.getLogger(NotificationRegistry.class.getName());
    private final RESTMBeanServerConnection serverConnection;
    private DelayedURL inboxURL;
    private DelayedURL registrationsURL;
    private DelayedURL serverRegistrationsURL;
    private final Map<ObjectName, ClientNotificationRegistration> registrationMap = Collections.synchronizedMap(new HashMap());
    private final List<ServerNotificationListenerEntry> serverRegistrationList = Collections.synchronizedList(new ArrayList());
    private NotificationThread notificationThread;
    private ObjectIdentityCache identityCache;
    private final JSONConverter converter = JSONConverter.getConverter();

    NotificationRegistry(RESTMBeanServerConnection serverConnection) throws IOException {
        this.serverConnection = serverConnection;
        try {
            this.setupNotificationArea();
        }
        catch (IOException io) {
            throw io;
        }
        catch (Throwable t) {
            throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
        }
        this.notificationThread = new NotificationThread();
        this.notificationThread.start();
    }

    private void setupNotificationArea() throws Throwable {
        String sourceMethod = "setupNotificationArea";
        URL notificationsURL = null;
        HttpsURLConnection connection = null;
        try {
            notificationsURL = this.serverConnection.getNotificationsURL();
            connection = this.serverConnection.getConnection(notificationsURL, ClientConstants.HttpMethod.POST);
            NotificationSettings ns = new NotificationSettings();
            ns.deliveryInterval = this.serverConnection.getConnector().getNotificationDeliveryInterval();
            ns.inboxExpiry = this.serverConnection.getConnector().getNotificationInboxExpiry();
            OutputStream output = connection.getOutputStream();
            this.converter.writeNotificationSettings(output, ns);
            output.flush();
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (IOException io) {
            throw this.serverConnection.getRequestErrorException("setupNotificationArea", io, notificationsURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    NotificationArea area = this.serverConnection.converter.readNotificationArea(connection.getInputStream());
                    this.inboxURL = new DelayedURL(notificationsURL, area.inboxURL);
                    this.registrationsURL = new DelayedURL(notificationsURL, area.registrationsURL);
                    this.serverRegistrationsURL = new DelayedURL(notificationsURL, area.serverRegistrationsURL);
                    break;
                }
                catch (Exception e) {
                    throw this.serverConnection.getResponseErrorException("setupNotificationArea", e, notificationsURL);
                }
            }
            case 404: {
                throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.url.not.found", new Object[0]));
            }
            case 400: 
            case 500: 
            case 503: {
                throw this.serverConnection.getServerThrowable("setupNotificationArea", connection);
            }
            case 401: 
            case 403: {
                throw this.serverConnection.getBadCredentialsException(responseCode, connection);
            }
            default: {
                throw this.serverConnection.getResponseCodeErrorException("setupNotificationArea", responseCode, connection);
            }
        }
    }

    synchronized void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        if (!this.serverConnection.isRegistered(name)) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.instance.not.found", name));
        }
        NotificationListenerEntry set = new NotificationListenerEntry(listener, filter, handback);
        ClientNotificationRegistration localRegistration = this.registrationMap.get(name);
        if (localRegistration == null) {
            localRegistration = new ClientNotificationRegistration(name);
            this.registrationMap.put(name, localRegistration);
        }
        localRegistration.addNotificationListenerEntry(set);
    }

    synchronized void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        try {
            this.updateServerNotificationRegistration(name, listener, filter, handback, ServerNotificationRegistration.Operation.Add);
            this.serverRegistrationList.add(new ServerNotificationListenerEntry(name, listener, filter, handback));
        }
        catch (ListenerNotFoundException lnf) {
            throw new IOException(lnf);
        }
    }

    synchronized void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.updateServerNotificationRegistration(name, listener, null, null, ServerNotificationRegistration.Operation.RemoveAll);
        Iterator<ServerNotificationListenerEntry> iterator = this.serverRegistrationList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().listener.equals(listener)) continue;
            iterator.remove();
        }
    }

    synchronized void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.updateServerNotificationRegistration(name, listener, filter, handback, ServerNotificationRegistration.Operation.RemoveSpecific);
        this.serverRegistrationList.remove(new ServerNotificationListenerEntry(name, listener, filter, handback));
    }

    synchronized void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.removeNotificationListener(name, listener, null, null, true);
    }

    synchronized void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.removeNotificationListener(name, listener, filter, handback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        if (this.notificationThread != null) {
            this.notificationThread.interrupt();
            try {
                this.notificationThread.join(2000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.notificationThread = null;
            }
        }
        JSONConverter.returnConverter(this.converter);
    }

    synchronized void connectionFailed(Throwable t) {
        this.serverConnection.connectionFailed(t);
        JSONConverter.returnConverter(this.converter);
    }

    private void updateServerNotificationRegistration(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback, ServerNotificationRegistration.Operation operation) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        String sourceMethod = "updateServerNotificationRegistration";
        URL serverRegistrationsURL = null;
        HttpsURLConnection connection = null;
        try {
            serverRegistrationsURL = this.getServerRegistrationsURL();
            connection = this.serverConnection.getConnection(serverRegistrationsURL, ClientConstants.HttpMethod.POST);
            ServerNotificationRegistration snr = new ServerNotificationRegistration();
            snr.objectName = name;
            snr.listener = listener;
            if (operation == ServerNotificationRegistration.Operation.Add) {
                snr.filter = filter;
                snr.handback = handback;
            }
            if (operation != ServerNotificationRegistration.Operation.RemoveAll) {
                if (this.identityCache == null) {
                    this.identityCache = new ObjectIdentityCache();
                }
                snr.filterID = this.identityCache.getObjectIdentity(filter);
                snr.handbackID = this.identityCache.getObjectIdentity(handback);
            }
            snr.operation = operation;
            OutputStream output = connection.getOutputStream();
            this.converter.writeServerNotificationRegistration(output, snr);
            output.flush();
            output.close();
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (IOException io) {
            throw this.serverConnection.getRequestErrorException("updateServerNotificationRegistration", io, serverRegistrationsURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 204: {
                break;
            }
            case 410: {
                try {
                    throw this.serverConnection.getServerThrowable("updateServerNotificationRegistration", connection);
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.converter.readThrowable(connection.getErrorStream());
                }
                catch (RuntimeOperationsException roe) {
                    throw roe;
                }
                catch (ListenerNotFoundException lnf) {
                    throw lnf;
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(cnf);
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.serverConnection.getBadCredentialsException(responseCode, connection);
            }
            default: {
                throw this.serverConnection.getResponseCodeErrorException("updateServerNotificationRegistration", responseCode, connection);
            }
        }
    }

    private void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback, boolean matchListenerOnly) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (!this.serverConnection.isRegistered(name)) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.instance.not.found", name));
        }
        ClientNotificationRegistration localRegistration = this.registrationMap.get(name);
        if (localRegistration == null) {
            throw new ListenerNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.listener.not.found", name));
        }
        localRegistration.removeNotificationListenerEntries(name, listener, filter, handback, matchListenerOnly);
        if (localRegistration.isEmpty()) {
            this.registrationMap.remove(name);
        }
    }

    private synchronized boolean waitForServer(Throwable t) {
        if (!this.serverConnection.isConnected()) {
            return true;
        }
        int maxServerRestartTime = this.serverConnection.getConnector().getMaxServerWaitTime();
        if (maxServerRestartTime > 0) {
            this.serverConnection.getConnector().connectionTemporarilyLost(t);
            int serverStatusPollingInterval = this.serverConnection.getConnector().getServerStatusPollingInterval();
            long endTime = System.currentTimeMillis() + (long)maxServerRestartTime;
            while (System.currentTimeMillis() < endTime) {
                long currentTime;
                try {
                    this.setupNotificationArea();
                    if (this.restoreNotificationRegistrations()) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if ((currentTime = System.currentTimeMillis()) >= endTime) continue;
                try {
                    Thread.sleep(Math.min(endTime - currentTime, (long)serverStatusPollingInterval));
                }
                catch (InterruptedException ie) {
                    return false;
                }
            }
        }
        return false;
    }

    private synchronized boolean restoreNotificationRegistrations() {
        ArrayList<ObjectName> clientRemovalList = new ArrayList<ObjectName>();
        ArrayList<ServerNotificationListenerEntry> serverRemovalList = new ArrayList<ServerNotificationListenerEntry>();
        ArrayList<OperationsException> exceptions = null;
        for (Map.Entry<ObjectName, ClientNotificationRegistration> entry : this.registrationMap.entrySet()) {
            try {
                entry.getValue().createNotificationRegistration();
            }
            catch (IOException io) {
                return false;
            }
            catch (InstanceNotFoundException inf) {
                if (exceptions == null) {
                    exceptions = new ArrayList<OperationsException>();
                }
                clientRemovalList.add(entry.getKey());
                exceptions.add(inf);
            }
        }
        for (ServerNotificationListenerEntry snl : this.serverRegistrationList) {
            try {
                this.updateServerNotificationRegistration(snl.name, snl.listener, snl.filter, snl.handback, ServerNotificationRegistration.Operation.Add);
            }
            catch (IOException io) {
                return false;
            }
            catch (OperationsException oe) {
                if (exceptions == null) {
                    exceptions = new ArrayList();
                }
                serverRemovalList.add(snl);
                exceptions.add(oe);
            }
        }
        if (exceptions != null) {
            for (ObjectName clientEntry : clientRemovalList) {
                this.registrationMap.remove(clientEntry);
            }
            for (ServerNotificationListenerEntry snl : serverRemovalList) {
                this.serverRegistrationList.remove(snl);
            }
        }
        this.serverConnection.getConnector().connectionRestored(exceptions != null ? exceptions.toArray(new Exception[exceptions.size()]) : null);
        return true;
    }

    private URL getInboxURL() throws IOException {
        return this.inboxURL.getURL();
    }

    private URL getRegistrationsURL() throws IOException {
        return this.registrationsURL.getURL();
    }

    private URL getServerRegistrationsURL() throws IOException {
        return this.serverRegistrationsURL.getURL();
    }

    private class ClientNotificationRegistration {
        private final ObjectName name;
        private DelayedURL registrationURL;
        private final List<NotificationListenerEntry> entries;
        private List<NotificationFilter> serverFilters;

        ClientNotificationRegistration(ObjectName name) {
            this.name = name;
            this.entries = new ArrayList<NotificationListenerEntry>();
        }

        synchronized void addNotificationListenerEntry(NotificationListenerEntry entry) throws InstanceNotFoundException, IOException {
            boolean serverFiltersUpdated;
            boolean receiveAllNotifications;
            boolean bl = receiveAllNotifications = entry.filter == null || !NotificationRegistry.this.converter.isSupportedNotificationFilter(entry.filter);
            if (receiveAllNotifications) {
                if (this.serverFilters != null) {
                    this.serverFilters = null;
                    serverFiltersUpdated = true;
                } else {
                    serverFiltersUpdated = false;
                }
            } else if (this.serverFilters != null || this.entries.size() == 0) {
                if (this.serverFilters == null) {
                    this.serverFilters = new ArrayList<NotificationFilter>();
                }
                this.serverFilters.add(entry.filter);
                serverFiltersUpdated = true;
            } else {
                serverFiltersUpdated = false;
            }
            this.entries.add(entry);
            if (this.registrationURL == null) {
                this.createNotificationRegistration();
            } else if (serverFiltersUpdated) {
                this.updateNotificationRegistration();
            }
        }

        synchronized void removeNotificationListenerEntries(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback, boolean matchListenerOnly) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            boolean serverFiltersUpdated;
            boolean listenerFound = false;
            Iterator<NotificationListenerEntry> entryIterator = this.entries.iterator();
            while (entryIterator.hasNext()) {
                NotificationListenerEntry entry = entryIterator.next();
                if (entry.listener != listener || !matchListenerOnly && (entry.filter != filter || entry.handback != handback)) continue;
                listenerFound = true;
                entryIterator.remove();
                if (matchListenerOnly) continue;
                break;
            }
            if (!listenerFound) {
                throw new ListenerNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.listener.not.found", name));
            }
            ArrayList<NotificationFilter> newServerFilters = null;
            for (NotificationListenerEntry entry : this.entries) {
                if (entry.filter == null || !NotificationRegistry.this.converter.isSupportedNotificationFilter(entry.filter)) {
                    newServerFilters = null;
                    break;
                }
                if (newServerFilters == null) {
                    newServerFilters = new ArrayList<NotificationFilter>();
                }
                newServerFilters.add(entry.filter);
            }
            if (this.serverFilters != null && !((Object)this.serverFilters).equals(newServerFilters) || this.serverFilters == null && newServerFilters != null) {
                serverFiltersUpdated = true;
                this.serverFilters = newServerFilters;
            } else {
                serverFiltersUpdated = false;
            }
            if (this.isEmpty()) {
                this.deleteNotificationRegistration();
            } else if (serverFiltersUpdated) {
                this.updateNotificationRegistration();
            }
        }

        private NotificationFilter[] getServerFilters() {
            if (this.serverFilters == null) {
                return null;
            }
            NotificationFilter[] serverFilterArray = new NotificationFilter[this.serverFilters.size()];
            return this.serverFilters.toArray(serverFilterArray);
        }

        private URL getRegistrationURL() throws IOException {
            return this.registrationURL.getURL();
        }

        boolean isEmpty() {
            return this.entries.isEmpty();
        }

        synchronized void handleNotification(Notification notification) {
            boolean skipFilters = this.entries.size() == 1 && (this.serverFilters == null || this.serverFilters.size() == 1);
            for (NotificationListenerEntry entry : this.entries) {
                entry.handleNotification(notification, !skipFilters);
            }
        }

        synchronized void createNotificationRegistration() throws InstanceNotFoundException, IOException {
            String sourceMethod = "createNotificationRegistration";
            URL registrationsURL = null;
            HttpsURLConnection connection = null;
            try {
                registrationsURL = NotificationRegistry.this.getRegistrationsURL();
                connection = NotificationRegistry.this.serverConnection.getConnection(registrationsURL, ClientConstants.HttpMethod.POST);
                NotificationRegistration nr = new NotificationRegistration();
                nr.objectName = this.name;
                nr.filters = this.getServerFilters();
                OutputStream output = connection.getOutputStream();
                NotificationRegistry.this.converter.writeNotificationRegistration(output, nr);
                output.flush();
                output.close();
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (IOException io) {
                throw NotificationRegistry.this.serverConnection.getRequestErrorException("createNotificationRegistration", io, registrationsURL);
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: {
                    try {
                        String url = NotificationRegistry.this.converter.readString(connection.getInputStream());
                        this.registrationURL = new DelayedURL(registrationsURL, url);
                        break;
                    }
                    catch (Exception e) {
                        throw NotificationRegistry.this.serverConnection.getResponseErrorException("createNotificationRegistration", e, registrationsURL);
                    }
                }
                case 400: 
                case 410: 
                case 500: {
                    try {
                        throw NotificationRegistry.this.serverConnection.getServerThrowable("createNotificationRegistration", connection);
                    }
                    catch (RuntimeOperationsException roe) {
                        throw roe;
                    }
                    catch (InstanceNotFoundException inf) {
                        throw inf;
                    }
                    catch (IOException io) {
                        throw io;
                    }
                    catch (ClassNotFoundException cnf) {
                        throw new IOException(cnf);
                    }
                    catch (Throwable t) {
                        throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                    }
                }
                case 401: 
                case 403: {
                    throw NotificationRegistry.this.serverConnection.getBadCredentialsException(responseCode, connection);
                }
                default: {
                    throw NotificationRegistry.this.serverConnection.getResponseCodeErrorException("createNotificationRegistration", responseCode, connection);
                }
            }
        }

        private void updateNotificationRegistration() throws InstanceNotFoundException, IOException {
            String sourceMethod = "updateNotificationRegistration";
            URL registrationURL = null;
            HttpsURLConnection connection = null;
            try {
                registrationURL = this.getRegistrationURL();
                connection = NotificationRegistry.this.serverConnection.getConnection(registrationURL, ClientConstants.HttpMethod.PUT);
                OutputStream output = connection.getOutputStream();
                NotificationRegistry.this.converter.writeNotificationFilters(output, this.getServerFilters());
                output.flush();
                output.close();
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (IOException io) {
                throw NotificationRegistry.this.serverConnection.getRequestErrorException("updateNotificationRegistration", io, registrationURL);
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 204: {
                    break;
                }
                case 400: 
                case 410: 
                case 500: {
                    try {
                        throw NotificationRegistry.this.converter.readThrowable(connection.getErrorStream());
                    }
                    catch (InstanceNotFoundException inf) {
                        throw inf;
                    }
                    catch (IOException io) {
                        throw io;
                    }
                    catch (ClassNotFoundException cnf) {
                        throw new IOException(cnf);
                    }
                    catch (Throwable t) {
                        throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                    }
                }
                case 401: 
                case 403: {
                    throw NotificationRegistry.this.serverConnection.getBadCredentialsException(responseCode, connection);
                }
                default: {
                    throw NotificationRegistry.this.serverConnection.getResponseCodeErrorException("updateNotificationRegistration", responseCode, connection);
                }
            }
        }

        private void deleteNotificationRegistration() throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            String sourceMethod = "deleteNotificationRegistration";
            URL registrationURL = null;
            HttpsURLConnection connection = null;
            try {
                registrationURL = this.getRegistrationURL();
                connection = NotificationRegistry.this.serverConnection.getConnection(registrationURL, ClientConstants.HttpMethod.DELETE);
            }
            catch (IOException io) {
                throw NotificationRegistry.this.serverConnection.getRequestErrorException("deleteNotificationRegistration", io, registrationURL);
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 204: {
                    break;
                }
                case 400: 
                case 410: 
                case 500: {
                    try {
                        throw NotificationRegistry.this.converter.readThrowable(connection.getInputStream());
                    }
                    catch (InstanceNotFoundException inf) {
                        throw inf;
                    }
                    catch (ListenerNotFoundException lnf) {
                        throw lnf;
                    }
                    catch (IOException io) {
                        throw io;
                    }
                    catch (Throwable t) {
                        throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                    }
                }
                case 401: 
                case 403: {
                    throw NotificationRegistry.this.serverConnection.getBadCredentialsException(responseCode, connection);
                }
                default: {
                    throw NotificationRegistry.this.serverConnection.getResponseCodeErrorException("deleteNotificationRegistration", responseCode, connection);
                }
            }
        }
    }

    private class NotificationThread
    extends Thread {
        private NotificationThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            String sourceMethod = "run";
            JSONConverter converter = JSONConverter.getConverter();
            block19: while (!NotificationThread.interrupted() && NotificationRegistry.this.serverConnection.isConnected()) {
                URL inboxURL = null;
                HttpsURLConnection connection = null;
                try {
                    inboxURL = NotificationRegistry.this.getInboxURL();
                    connection = NotificationRegistry.this.serverConnection.getConnection(inboxURL, ClientConstants.HttpMethod.GET);
                    connection.setReadTimeout(NotificationRegistry.this.serverConnection.getConnector().getReadTimeout());
                }
                catch (IOException io) {
                    logger.logp(Level.FINE, logger.getName(), "run", io.getMessage(), io);
                    NotificationRegistry.this.connectionFailed(NotificationRegistry.this.serverConnection.getRequestErrorException("run", io, inboxURL));
                    break;
                }
                try {
                    int responseCode = 0;
                    try {
                        responseCode = connection.getResponseCode();
                    }
                    catch (IOException io) {
                        logger.logp(Level.FINE, logger.getName(), "run", io.getMessage(), io);
                        if (NotificationRegistry.this.waitForServer(io)) continue;
                        throw io;
                    }
                    switch (responseCode) {
                        case 200: {
                            try {
                                Notification[] notifications = converter.readNotifications(connection.getInputStream());
                                if (notifications == null || !NotificationRegistry.this.serverConnection.isConnected()) continue block19;
                                for (Notification n : notifications) {
                                    Object source = n.getSource();
                                    if (!(source instanceof ObjectName)) {
                                        NotificationRegistry.this.serverConnection.getConnector().notificationLost(n);
                                        continue;
                                    }
                                    ClientNotificationRegistration localRegistration = (ClientNotificationRegistration)NotificationRegistry.this.registrationMap.get(source);
                                    if (localRegistration != null) {
                                        try {
                                            localRegistration.handleNotification(n);
                                        }
                                        catch (Exception e) {
                                            NotificationRegistry.this.serverConnection.logSevereException("run", RESTClientMessagesUtil.getMessage("jmx.rest.client.notification.lost", new Object[0]), e);
                                            NotificationRegistry.this.serverConnection.getConnector().notificationLost(n);
                                        }
                                        continue;
                                    }
                                    NotificationRegistry.this.serverConnection.getConnector().notificationLost(n);
                                }
                                continue block19;
                            }
                            catch (ClassNotFoundException cnf) {
                                throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.result.exception", new Object[0]), cnf);
                            }
                            catch (Exception e) {
                                logger.logp(Level.FINE, logger.getName(), "run", e.getMessage(), e);
                                throw NotificationRegistry.this.serverConnection.getResponseErrorException("run", e, inboxURL);
                            }
                        }
                        case 404: {
                            IOException ex = new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.url.not.found", new Object[0]));
                            logger.logp(Level.FINE, logger.getName(), "run", ex.getMessage());
                            if (NotificationRegistry.this.waitForServer(ex)) break;
                            throw ex;
                        }
                        case 410: {
                            Throwable t = NotificationRegistry.this.serverConnection.getServerThrowable("run", connection);
                            logger.logp(Level.FINE, logger.getName(), "run", t.getMessage());
                            if (NotificationRegistry.this.waitForServer(t)) break;
                            throw t;
                        }
                        case 400: 
                        case 500: {
                            Throwable ie = converter.readThrowable(connection.getErrorStream());
                            logger.logp(Level.FINE, "run", logger.getName(), ie.getMessage());
                            throw ie;
                        }
                        case 401: 
                        case 403: {
                            throw NotificationRegistry.this.serverConnection.getBadCredentialsException(responseCode, connection);
                        }
                        default: {
                            throw NotificationRegistry.this.serverConnection.getResponseCodeErrorException("run", responseCode, connection);
                        }
                    }
                }
                catch (ClosedByInterruptException ie) {
                    break;
                }
                catch (Throwable t) {
                    logger.logp(Level.FINE, logger.getName(), "run", t.getMessage());
                    NotificationRegistry.this.connectionFailed(t);
                    break;
                }
            }
            JSONConverter.returnConverter(converter);
        }
    }
}

