/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.converter;

import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.ws.jmx.connector.datatypes.ConversionException;
import com.ibm.ws.jmx.connector.datatypes.CreateMBean;
import com.ibm.ws.jmx.connector.datatypes.Invocation;
import com.ibm.ws.jmx.connector.datatypes.JMXServerInfo;
import com.ibm.ws.jmx.connector.datatypes.MBeanInfoWrapper;
import com.ibm.ws.jmx.connector.datatypes.MBeanQuery;
import com.ibm.ws.jmx.connector.datatypes.NotificationArea;
import com.ibm.ws.jmx.connector.datatypes.NotificationRegistration;
import com.ibm.ws.jmx.connector.datatypes.NotificationSettings;
import com.ibm.ws.jmx.connector.datatypes.ObjectInstanceWrapper;
import com.ibm.ws.jmx.connector.datatypes.ServerNotificationRegistration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.AttributeList;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.relation.RelationNotification;
import javax.management.remote.JMXConnectionNotification;
import javax.management.timer.TimerNotification;

public class JSONConverter {
    private static final boolean USE_BASE64_FOR_POJO = false;
    private static final boolean USE_BASE64_FOR_MBEANINFO = false;
    private static final Map<Class<?>, TYPE> SupportedClasses;
    private static final Set<Class<?>> SimpleKeys;
    private static final Set<Class<?>> SimpleArrays;
    private static final Map<String, TYPE> SimpleValues;
    private static final Map<String, SimpleType<?>> Name2SimpleTypes;
    private static final Map<SimpleType<?>, TYPE> SimpleOpenTypes;
    private static final Map<String, TYPE> StructuredClasses;
    private static final String N_ATTRIBUTENAME = "attributeName";
    private static final byte[] OM_ATTRIBUTENAME;
    private static final String N_ATTRIBUTES = "attributes";
    private static final byte[] OM_ATTRIBUTES;
    private static final String N_ATTRIBUTES_URL = "attributes_URL";
    private static final byte[] OM_ATTRIBUTES_URL;
    private static final String N_ATTRIBUTETYPE = "attributeType";
    private static final byte[] OM_ATTRIBUTETYPE;
    private static final String N_CLASSNAME = "className";
    private static final byte[] OM_CLASSNAME;
    private static final String N_CONNECTIONID = "connectionId";
    private static final byte[] OM_CONNECTIONID;
    private static final String N_CONSTRUCTORS = "constructors";
    private static final byte[] OM_CONSTRUCTORS;
    private static final String N_CREATEMBEAN = "createMBean";
    private static final byte[] OM_CREATEMBEAN;
    private static final String N_DEFAULTDOMAIN = "defaultDomain";
    private static final byte[] OM_DEFAULTDOMAIN;
    private static final String N_DELIVERYINTERVAL = "deliveryInterval";
    private static final byte[] OM_DELIVERYINTERVAL;
    private static final String N_DESCRIPTION = "description";
    private static final byte[] OM_DESCRIPTION;
    private static final String N_DESCRIPTOR = "descriptor";
    private static final byte[] OM_DESCRIPTOR;
    private static final String N_DIMENSION = "dimension";
    private static final byte[] OM_DIMENSION;
    private static final String N_DISABLED = "disabled";
    private static final byte[] OM_DISABLED;
    private static final String N_DOMAINS = "domains";
    private static final byte[] OM_DOMAINS;
    private static final String N_ELEMENTTYPE = "elementType";
    private static final byte[] OM_ELEMENTTYPE;
    private static final String N_ENABLED = "enabled";
    private static final byte[] OM_ENABLED;
    private static final String N_ENTRIES = "entries";
    private static final byte[] OM_ENTRIES;
    private static final String N_FILTER = "filter";
    private static final byte[] OM_FILTER;
    private static final String N_FILTERID = "filterID";
    private static final byte[] OM_FILTERID;
    private static final String N_FILTERS = "filters";
    private static final byte[] OM_FILTERS;
    private static final String N_HANDBACK = "handback";
    private static final byte[] OM_HANDBACK;
    private static final String N_HANDBACKID = "handbackID";
    private static final byte[] OM_HANDBACKID;
    private static final String N_IMPACT = "impact";
    private static final byte[] OM_IMPACT;
    private static final String N_INBOX = "inbox";
    private static final byte[] OM_INBOX;
    private static final String N_INBOXEXPIRY = "inboxExpiry";
    private static final byte[] OM_INBOXEXPIRTY;
    private static final String N_INDEXNAMES = "indexNames";
    private static final byte[] OM_INDEXNAMES;
    private static final String N_INSTANCEOF = "instanceOf";
    private static final byte[] OM_INSTANCEOF;
    private static final String N_ISIS = "isIs";
    private static final byte[] OM_ISIS;
    private static final String N_ISREADABLE = "isReadable";
    private static final byte[] OM_ISREADABLE;
    private static final String N_ISWRITABLE = "isWritable";
    private static final byte[] OM_ISWRITABLE;
    private static final String N_ITEMS = "items";
    private static final byte[] OM_ITEMS;
    private static final String N_LISTENER = "listener";
    private static final byte[] OM_LISTENER;
    private static final String N_LOADERNAME = "loaderName";
    private static final byte[] OM_LOADERNAME;
    private static final String N_KEY = "key";
    private static final byte[] OM_KEY;
    private static final String N_KEYTYPE = "keyType";
    private static final byte[] OM_KEYTYPE;
    private static final String N_MBEANCOUNT = "mbeanCount";
    private static final byte[] OM_MBEANCOUNT;
    private static final String N_MBEANNAME = "mbeanName";
    private static final byte[] OM_MBEANNAME;
    private static final String N_MBEANS = "mbeans";
    private static final byte[] OM_MBEANS;
    private static final String N_MBEANSTOUNREGISTER = "mbeansToUnregister";
    private static final byte[] OM_MBEANSTOUNREGISTER;
    private static final String N_MESSAGE = "message";
    private static final byte[] OM_MESSAGE;
    private static final String N_NAME = "name";
    private static final byte[] OM_NAME;
    private static final String N_NAMES = "names";
    private static final byte[] OM_NAMES;
    private static final String N_NEWROLEVALUE = "newRoleValue";
    private static final byte[] OM_NEWROLEVALUE;
    private static final String N_NEWVALUE = "newValue";
    private static final byte[] OM_NEWVALUE;
    private static final String N_NOTIFICATIONID = "notificationID";
    private static final byte[] OM_NOTIFICATIONID;
    private static final String N_NOTIFICATIONS = "notifications";
    private static final byte[] OM_NOTIFICATIONS;
    private static final String N_NOTIFTYPES = "notifTypes";
    private static final byte[] OM_NOTIFTYPES;
    private static final String N_OBJECTNAME = "objectName";
    private static final byte[] OM_OBJECTNAME;
    private static final String N_OLDROLEVALUE = "oldRoleValue";
    private static final byte[] OM_OLDROLEVALUE;
    private static final String N_OLDVALUE = "oldValue";
    private static final byte[] OM_OLDVALUE;
    private static final String N_OPENTYPE = "openType";
    private static final byte[] OM_OPENTYPE;
    private static final String N_OPENTYPECLASS = "openTypeClass";
    private static final byte[] OM_OPENTYPECLASS;
    private static final String N_OPENTYPES = "openTypes";
    private static final byte[] OM_OPENTYPES;
    private static final String N_OPERATION = "operation";
    private static final byte[] OM_OPERATION;
    private static final String N_OPERATIONS = "operations";
    private static final byte[] OM_OPERATIONS;
    private static final String N_PARAMS = "params";
    private static final byte[] OM_PARAMS;
    private static final String N_QUERYEXP = "queryExp";
    private static final byte[] OM_QUERYEXP;
    private static final String N_REGISTRATIONS = "registrations";
    private static final byte[] OM_REGISTRATIONS;
    private static final String N_RELATIONID = "relationId";
    private static final byte[] OM_RELATIONID;
    private static final String N_RELATIONTYPENAME = "relationTypeName";
    private static final byte[] OM_RELATIONTYPENAME;
    private static final String N_RETURNTYPE = "returnType";
    private static final byte[] OM_RETURNTYPE;
    private static final String N_ROLENAME = "roleName";
    private static final byte[] OM_ROLENAME;
    private static final String N_ROWTYPE = "rowType";
    private static final byte[] OM_ROWTYPE;
    private static final String N_SEQUENCENUMBER = "sequenceNumber";
    private static final byte[] OM_SEQUENCENUMBER;
    private static final String N_SERIALIZED = "serialized";
    private static final byte[] OM_SERIALIZED;
    private static final String N_SERVERREGISTRATIONS = "serverRegistrations";
    private static final byte[] OM_SERVERREGISTRATIONS;
    private static final String N_SIGNATURE = "signature";
    private static final byte[] OM_SIGNATURE;
    private static final String N_SIMPLEKEY = "simpleKey";
    private static final byte[] OM_SIMPLEKEY;
    private static final String N_SOURCE = "source";
    private static final byte[] OM_SOURCE;
    private static final byte[] OM_STACKTRACE;
    private static final String N_THROWABLE = "throwable";
    private static final byte[] OM_THROWABLE;
    private static final String N_TIMESTAMP = "timeStamp";
    private static final byte[] OM_TIMESTAMP;
    private static final String N_TYPE = "type";
    private static final byte[] OM_TYPE;
    private static final String N_TYPENAME = "typeName";
    private static final byte[] OM_TYPENAME;
    private static final String N_TYPES = "types";
    private static final byte[] OM_TYPES;
    private static final String N_URL = "URL";
    private static final byte[] OM_URL;
    private static final String N_USELOADER = "useLoader";
    private static final byte[] OM_USELOADER;
    private static final String N_USERDATA = "userData";
    private static final byte[] OM_USERDATA;
    private static final String N_USESIGNATURE = "useSignature";
    private static final byte[] OM_USESIGNATURE;
    private static final String N_VALUE = "value";
    private static final byte[] OM_VALUE;
    private static final String N_VALUES = "values";
    private static final byte[] OM_VALUES;
    private static final String N_VERSION = "version";
    private static final byte[] OM_VERSION;
    private static final byte[] LONG_MIN;
    private static final byte[] INT_MIN;
    private static final byte[] TRUE;
    private static final byte[] FALSE;
    private static final byte[] NULL;
    private static final Object OBJECT;
    private static final byte[] BASE64;
    private static final byte[] BASE64_D;
    private static final Stack<JSONConverter> POOL;
    private final byte[] BYTE_BUFFER = new byte[LONG_MIN.length / 3 * 3 + 3];
    private boolean firstItem;
    private final ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
    private final Base64OutputStream base64Stream = new Base64OutputStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONConverter getConverter() {
        Stack<JSONConverter> stack = POOL;
        synchronized (stack) {
            if (!POOL.empty()) {
                return POOL.pop();
            }
        }
        return new JSONConverter();
    }

    public static void returnConverter(JSONConverter converter) {
        POOL.push(converter);
    }

    private JSONConverter() {
    }

    public void writeInt(OutputStream out, int value) throws IOException {
        this.writeStartArray(out);
        this.writeIntInternal(out, value);
        this.writeEndArray(out);
    }

    public int readInt(InputStream in) throws ConversionException, IOException {
        JSONArray json = this.parseArray(in);
        if (json.size() != 1) {
            this.throwConversionException("readInt() expects one item in the array: [ Integer ].", (Object)json);
        }
        return this.readIntInternal(json.get(0));
    }

    public void writeBoolean(OutputStream out, boolean value) throws IOException {
        this.writeStartArray(out);
        this.writeBooleanInternal(out, value);
        this.writeEndArray(out);
    }

    public boolean readBoolean(InputStream in) throws ConversionException, IOException {
        JSONArray json = this.parseArray(in);
        if (json.size() != 1) {
            this.throwConversionException("readBoolean() expects one item in the array: [ true | false ].", (Object)json);
        }
        return this.readBooleanInternal(json.get(0));
    }

    public void writeString(OutputStream out, String value) throws IOException {
        this.writeStartArray(out);
        this.writeStringInternal(out, value);
        this.writeEndArray(out);
    }

    public String readString(InputStream in) throws ConversionException, IOException {
        JSONArray json = this.parseArray(in);
        if (json.size() != 1) {
            this.throwConversionException("readString() expects one item in the array: [ String ].", (Object)json);
        }
        return this.readStringInternal(json.get(0));
    }

    public void writeStringArray(OutputStream out, String[] value) throws IOException {
        assert (value != null);
        this.writeStringArrayInternal(out, value);
    }

    public String[] readStringArray(InputStream in) throws ConversionException, IOException {
        return this.readStringArrayInternal(this.parse(in));
    }

    public void writePOJO(OutputStream out, Object value) throws IOException {
        this.writePOJOInternal(out, value);
    }

    public Object readPOJO(InputStream in) throws ConversionException, IOException, ClassNotFoundException {
        return this.readPOJOInternal(this.parse(in));
    }

    public void writeJMX(OutputStream out, JMXServerInfo value) throws IOException {
        assert (value != null);
        this.writeStartObject(out);
        this.writeIntField(out, OM_VERSION, value.version);
        this.writeStringField(out, OM_MBEANS, value.mbeansURL);
        this.writeStringField(out, OM_CREATEMBEAN, value.createMBeanURL);
        this.writeStringField(out, OM_MBEANCOUNT, value.mbeanCountURL);
        this.writeStringField(out, OM_DEFAULTDOMAIN, value.defaultDomainURL);
        this.writeStringField(out, OM_DOMAINS, value.domainsURL);
        this.writeStringField(out, OM_NOTIFICATIONS, value.notificationsURL);
        this.writeStringField(out, OM_INSTANCEOF, value.instanceOfURL);
        this.writeEndObject(out);
    }

    public JMXServerInfo readJMX(InputStream in) throws ConversionException, IOException {
        JSONObject json = this.parseObject(in);
        JMXServerInfo ret = new JMXServerInfo();
        ret.version = this.readIntInternal(json.get(N_VERSION));
        ret.mbeansURL = this.readStringInternal(json.get(N_MBEANS));
        ret.createMBeanURL = this.readStringInternal(json.get(N_CREATEMBEAN));
        ret.mbeanCountURL = this.readStringInternal(json.get(N_MBEANCOUNT));
        ret.defaultDomainURL = this.readStringInternal(json.get(N_DEFAULTDOMAIN));
        ret.domainsURL = this.readStringInternal(json.get(N_DOMAINS));
        ret.notificationsURL = this.readStringInternal(json.get(N_NOTIFICATIONS));
        ret.instanceOfURL = this.readStringInternal(json.get(N_INSTANCEOF));
        return ret;
    }

    public void writeObjectInstance(OutputStream out, ObjectInstanceWrapper value) throws IOException {
        assert (value != null && value.objectInstance != null);
        this.writeStartObject(out);
        this.writeObjectNameField(out, OM_OBJECTNAME, value.objectInstance.getObjectName());
        this.writeStringField(out, OM_CLASSNAME, value.objectInstance.getClassName());
        this.writeStringField(out, OM_URL, value.mbeanInfoURL);
        this.writeEndObject(out);
    }

    public ObjectInstanceWrapper readObjectInstance(InputStream in) throws ConversionException, IOException {
        return this.readObjectInstanceInternal(this.parse(in));
    }

    public void writeObjectInstanceArray(OutputStream out, ObjectInstanceWrapper[] value) throws IOException {
        assert (value != null);
        this.writeStartArray(out);
        for (ObjectInstanceWrapper item : value) {
            this.writeArrayItem(out);
            this.writeObjectInstance(out, item);
        }
        this.writeEndArray(out);
    }

    public ObjectInstanceWrapper[] readObjectInstances(InputStream in) throws ConversionException, IOException {
        JSONArray json = this.parseArray(in);
        ObjectInstanceWrapper[] ret = new ObjectInstanceWrapper[json.size()];
        int pos = 0;
        for (Object item : json) {
            ret[pos++] = this.readObjectInstanceInternal(item);
        }
        return ret;
    }

    public void writeMBeanQuery(OutputStream out, MBeanQuery value) throws IOException {
        assert (value != null);
        this.writeStartObject(out);
        this.writeObjectNameField(out, OM_OBJECTNAME, value.objectName);
        this.writeSerializedField(out, OM_QUERYEXP, value.queryExp);
        this.writeStringField(out, OM_CLASSNAME, value.className);
        this.writeEndObject(out);
    }

    public MBeanQuery readMBeanQuery(InputStream in) throws ConversionException, IOException, ClassNotFoundException {
        JSONObject json = this.parseObject(in);
        MBeanQuery ret = new MBeanQuery();
        ret.objectName = this.readObjectName(json.get(N_OBJECTNAME));
        Object queryExp = this.readSerialized(json.get(N_QUERYEXP));
        if (queryExp != null && !(queryExp instanceof QueryExp)) {
            this.throwConversionException("readMBeanQuery() receives an instance that's not a QueryExp.", json.get(N_QUERYEXP));
        }
        ret.queryExp = (QueryExp)queryExp;
        ret.className = this.readStringInternal(json.get(N_CLASSNAME));
        return ret;
    }

    public void writeCreateMBean(OutputStream out, CreateMBean value) throws IOException {
        assert (value != null);
        this.writeStartObject(out);
        this.writeStringField(out, OM_CLASSNAME, value.className);
        this.writeObjectNameField(out, OM_OBJECTNAME, value.objectName);
        this.writeObjectNameField(out, OM_LOADERNAME, value.loaderName);
        this.writePOJOArrayField(out, OM_PARAMS, value.params);
        this.writeStringArrayField(out, OM_SIGNATURE, value.signature);
        this.writeBooleanField(out, OM_USELOADER, value.useLoader);
        this.writeBooleanField(out, OM_USESIGNATURE, value.useSignature);
        this.writeEndObject(out);
    }

    public CreateMBean readCreateMBean(InputStream in) throws ConversionException, IOException, ClassNotFoundException {
        JSONObject json = this.parseObject(in);
        CreateMBean ret = new CreateMBean();
        ret.objectName = this.readObjectName(json.get(N_OBJECTNAME));
        ret.className = this.readStringInternal(json.get(N_CLASSNAME));
        ret.loaderName = this.readObjectName(json.get(N_LOADERNAME));
        ret.params = this.readPOJOArray(json.get(N_PARAMS));
        ret.signature = this.readStringArrayInternal(json.get(N_SIGNATURE));
        ret.useLoader = this.readBooleanInternal(json.get(N_USELOADER));
        ret.useSignature = this.readBooleanInternal(json.get(N_USESIGNATURE));
        return ret;
    }

    public void writeMBeanInfo(OutputStream out, MBeanInfoWrapper value) throws IOException {
        assert (value != null && value.mbeanInfo != null && value.attributeURLs != null && value.operationURLs != null);
        this.writeStartObject(out);
        if (value.mbeanInfo.getClass() != MBeanInfo.class) {
            this.writeSerializedField(out, OM_SERIALIZED, value.mbeanInfo);
        }
        this.writeStringField(out, OM_CLASSNAME, value.mbeanInfo.getClassName());
        this.writeStringField(out, OM_DESCRIPTION, value.mbeanInfo.getDescription());
        this.writeDescriptor(out, OM_DESCRIPTOR, value.mbeanInfo.getDescriptor());
        this.writeAttributes(out, OM_ATTRIBUTES, value.mbeanInfo.getAttributes(), value.attributeURLs);
        this.writeStringField(out, OM_ATTRIBUTES_URL, value.attributesURL);
        this.writeConstructors(out, OM_CONSTRUCTORS, value.mbeanInfo.getConstructors());
        this.writeNotifications(out, OM_NOTIFICATIONS, value.mbeanInfo.getNotifications());
        this.writeOperations(out, OM_OPERATIONS, value.mbeanInfo.getOperations(), value.operationURLs);
        this.writeEndObject(out);
    }

    public MBeanInfoWrapper readMBeanInfo(InputStream in) throws ConversionException, IOException, ClassNotFoundException {
        JSONObject json = this.parseObject(in);
        MBeanInfoWrapper ret = new MBeanInfoWrapper();
        ret.attributeURLs = new HashMap<String, String>();
        ret.operationURLs = new HashMap<String, String>();
        String className = this.readStringInternal(json.get(N_CLASSNAME));
        String description = this.readStringInternal(json.get(N_DESCRIPTION));
        Descriptor descriptor = this.readDescriptor(json.get(N_DESCRIPTOR));
        MBeanAttributeInfo[] attributes = this.readAttributes(json.get(N_ATTRIBUTES), ret.attributeURLs);
        String attributeURL = this.readStringInternal(json.get(N_ATTRIBUTES_URL));
        MBeanConstructorInfo[] constructors = this.readConstructors(json.get(N_CONSTRUCTORS));
        MBeanNotificationInfo[] notifications = this.readNotifications(json.get(N_NOTIFICATIONS));
        MBeanOperationInfo[] operations = this.readOperations(json.get(N_OPERATIONS), ret.operationURLs);
        ret.attributesURL = attributeURL;
        Object o = json.get(N_SERIALIZED);
        if (o != null) {
            if (!((o = this.readSerialized(o)) instanceof MBeanInfo)) {
                this.throwConversionException("readMBeanInfo() receives an instance that's not a MBeanInfo.", json.get(N_SERIALIZED));
            }
            ret.mbeanInfo = (MBeanInfo)o;
        } else {
            ret.mbeanInfo = new MBeanInfo(className, description, attributes, constructors, operations, notifications, descriptor);
        }
        return ret;
    }

    public void writeAttributeList(OutputStream out, AttributeList value) throws IOException {
        this.writeStartArray(out);
        if (value != null) {
            for (Attribute item : value.asList()) {
                assert (item != null);
                this.writeArrayItem(out);
                this.writeStartObject(out);
                this.writeStringField(out, OM_NAME, item.getName());
                this.writePOJOField(out, OM_VALUE, item.getValue());
                this.writeEndObject(out);
            }
        }
        this.writeEndArray(out);
    }

    public AttributeList readAttributeList(InputStream in) throws ConversionException, IOException, ClassNotFoundException {
        JSONArray json = this.parseArray(in);
        AttributeList ret = new AttributeList();
        for (Object item : json) {
            if (!(item instanceof JSONObject)) {
                this.throwConversionException("readAttributeList() receives an items that's not a JSONObject.", item);
            }
            JSONObject jo = (JSONObject)item;
            String name = this.readStringInternal(jo.get(N_NAME));
            Object value = this.readPOJOInternal(jo.get(N_VALUE));
            ret.add(new Attribute(name, value));
        }
        return ret;
    }

    public void writeInvocation(OutputStream out, Invocation value) throws IOException {
        assert (value != null);
        this.writeStartObject(out);
        this.writePOJOArrayField(out, OM_PARAMS, value.params);
        this.writeStringArrayField(out, OM_SIGNATURE, value.signature);
        this.writeEndObject(out);
    }

    public Invocation readInvocation(InputStream in) throws ConversionException, IOException, ClassNotFoundException {
        JSONObject json = this.parseObject(in);
        Invocation ret = new Invocation();
        ret.params = this.readPOJOArray(json.get(N_PARAMS));
        ret.signature = this.readStringArrayInternal(json.get(N_SIGNATURE));
        return ret;
    }

    public void writeNotificationArea(OutputStream out, NotificationArea value) throws IOException {
        assert (value != null);
        this.writeStartObject(out);
        this.writeStringField(out, OM_REGISTRATIONS, value.registrationsURL);
        this.writeStringField(out, OM_SERVERREGISTRATIONS, value.serverRegistrationsURL);
        this.writeStringField(out, OM_INBOX, value.inboxURL);
        this.writeEndObject(out);
    }

    public NotificationArea readNotificationArea(InputStream in) throws ConversionException, IOException {
        JSONObject json = this.parseObject(in);
        NotificationArea ret = new NotificationArea();
        ret.registrationsURL = this.readStringInternal(json.get(N_REGISTRATIONS));
        ret.serverRegistrationsURL = this.readStringInternal(json.get(N_SERVERREGISTRATIONS));
        ret.inboxURL = this.readStringInternal(json.get(N_INBOX));
        return ret;
    }

    public void writeNotificationRegistration(OutputStream out, NotificationRegistration value) throws IOException {
        assert (value != null);
        this.writeStartObject(out);
        this.writeObjectNameField(out, OM_OBJECTNAME, value.objectName);
        this.writeNotificationFiltersField(out, OM_FILTERS, value.filters);
        this.writeEndObject(out);
    }

    public NotificationRegistration readNotificationRegistration(InputStream in) throws ConversionException, IOException, ClassNotFoundException {
        JSONObject json = this.parseObject(in);
        NotificationRegistration ret = new NotificationRegistration();
        ret.objectName = this.readObjectName(json.get(N_OBJECTNAME));
        ret.filters = this.readNotificationFiltersInternal(json.get(N_FILTERS));
        return ret;
    }

    public void writeServerNotificationRegistration(OutputStream out, ServerNotificationRegistration value) throws IOException {
        assert (value != null);
        this.writeStartObject(out);
        this.writeSimpleStringField(out, OM_OPERATION, value.operation.name());
        this.writeObjectNameField(out, OM_OBJECTNAME, value.objectName);
        this.writeObjectNameField(out, OM_LISTENER, value.listener);
        this.writeNotificationFilterField(out, OM_FILTER, value.filter);
        this.writePOJOField(out, OM_HANDBACK, value.handback);
        this.writeIntField(out, OM_FILTERID, value.filterID);
        this.writeIntField(out, OM_HANDBACKID, value.handbackID);
        this.writeEndObject(out);
    }

    public ServerNotificationRegistration readServerNotificationRegistration(InputStream in) throws ConversionException, IOException, ClassNotFoundException {
        JSONObject json = this.parseObject(in);
        ServerNotificationRegistration ret = new ServerNotificationRegistration();
        String name = this.readStringInternal(json.get(N_OPERATION));
        ret.operation = ServerNotificationRegistration.Operation.valueOf(name);
        ret.objectName = this.readObjectName(json.get(N_OBJECTNAME));
        ret.listener = this.readObjectName(json.get(N_LISTENER));
        ret.filter = this.readNotificationFilterInternal(json.get(N_FILTER), true);
        ret.handback = this.readPOJOInternal(json.get(N_HANDBACK));
        ret.filterID = this.readIntInternal(json.get(N_FILTERID));
        ret.handbackID = this.readIntInternal(json.get(N_HANDBACKID));
        return ret;
    }

    public boolean isSupportedNotificationFilter(NotificationFilter filter) {
        Class<?> clazz = filter.getClass();
        return clazz == AttributeChangeNotificationFilter.class || clazz == MBeanServerNotificationFilter.class || clazz == NotificationFilterSupport.class;
    }

    public void writeNotificationFilters(OutputStream out, NotificationFilter[] value) throws IOException {
        this.writeNotificationFiltersInternal(out, value);
    }

    public NotificationFilter[] readNotificationFilters(InputStream in) throws ConversionException, IOException, ClassNotFoundException {
        return this.readNotificationFiltersInternal(this.parseArray(in));
    }

    public void writeNotifications(OutputStream out, Notification[] value) throws IOException {
        this.writeStartArray(out);
        if (value == null) {
            this.writeEndArray(out);
            return;
        }
        for (Notification item : value) {
            assert (item != null);
            this.writeArrayItem(out);
            this.writeStartObject(out);
            Class<?> clazz = item.getClass();
            this.writeSimpleStringField(out, OM_CLASSNAME, clazz.getName());
            this.writeStringField(out, OM_TYPE, item.getType());
            assert (item.getSource() instanceof ObjectName);
            this.writeObjectNameField(out, OM_SOURCE, (ObjectName)item.getSource());
            this.writeLongField(out, OM_SEQUENCENUMBER, item.getSequenceNumber());
            this.writeLongField(out, OM_TIMESTAMP, item.getTimeStamp());
            this.writeStringField(out, OM_MESSAGE, item.getMessage());
            this.writePOJOField(out, OM_USERDATA, item.getUserData());
            if (clazz != Notification.class) {
                Notification v;
                if (clazz == AttributeChangeNotification.class) {
                    v = (AttributeChangeNotification)item;
                    this.writeStringField(out, OM_ATTRIBUTENAME, ((AttributeChangeNotification)v).getAttributeName());
                    this.writeStringField(out, OM_ATTRIBUTETYPE, ((AttributeChangeNotification)v).getAttributeType());
                    this.writePOJOField(out, OM_OLDVALUE, ((AttributeChangeNotification)v).getOldValue());
                    this.writePOJOField(out, OM_NEWVALUE, ((AttributeChangeNotification)v).getNewValue());
                } else if (clazz == JMXConnectionNotification.class) {
                    v = (JMXConnectionNotification)item;
                    this.writeStringField(out, OM_CONNECTIONID, ((JMXConnectionNotification)v).getConnectionId());
                } else if (clazz == MBeanServerNotification.class) {
                    v = (MBeanServerNotification)item;
                    this.writeObjectNameField(out, OM_MBEANNAME, ((MBeanServerNotification)v).getMBeanName());
                } else if (clazz == RelationNotification.class) {
                    v = (RelationNotification)item;
                    this.writeStringField(out, OM_RELATIONID, ((RelationNotification)v).getRelationId());
                    this.writeStringField(out, OM_RELATIONTYPENAME, ((RelationNotification)v).getRelationTypeName());
                    this.writeObjectNameField(out, OM_OBJECTNAME, ((RelationNotification)v).getObjectName());
                    String roleName = ((RelationNotification)v).getRoleName();
                    if (roleName == null) {
                        this.writeObjectNameListField(out, OM_MBEANSTOUNREGISTER, ((RelationNotification)v).getMBeansToUnregister());
                    } else {
                        this.writeStringField(out, OM_ROLENAME, ((RelationNotification)v).getRoleName());
                        this.writeObjectNameListField(out, OM_OLDROLEVALUE, ((RelationNotification)v).getOldRoleValue());
                        this.writeObjectNameListField(out, OM_NEWROLEVALUE, ((RelationNotification)v).getNewRoleValue());
                    }
                } else if (clazz == TimerNotification.class) {
                    v = (TimerNotification)item;
                    this.writeIntField(out, OM_NOTIFICATIONID, ((TimerNotification)v).getNotificationID());
                } else {
                    this.writeSerializedField(out, OM_SERIALIZED, item);
                }
            }
            this.writeEndObject(out);
        }
        this.writeEndArray(out);
    }

    public Notification[] readNotifications(InputStream in) throws ConversionException, IOException, ClassNotFoundException {
        JSONArray json = this.parseArray(in);
        int size = json.size();
        Notification[] ret = new Notification[size];
        for (int i = 0; i < size; ++i) {
            Notification n;
            Object o = json.get(i);
            if (!(o instanceof JSONObject)) {
                this.throwConversionException("readNotifications() expects a JSONObject.", o);
            }
            JSONObject obj = (JSONObject)o;
            String className = this.readStringInternal(obj.get(N_CLASSNAME));
            String type = this.readStringInternal(obj.get(N_TYPE));
            ObjectName source = this.readObjectName(obj.get(N_SOURCE));
            long sequenceNumber = this.readLongInternal(obj.get(N_SEQUENCENUMBER));
            long timeStamp = this.readLongInternal(obj.get(N_TIMESTAMP));
            String message = this.readStringInternal(obj.get(N_MESSAGE));
            Object userData = this.readPOJOInternal(obj.get(N_USERDATA));
            if ("javax.management.Notification".equals(className)) {
                n = new Notification(type, source, sequenceNumber, timeStamp, message);
            } else if ("javax.management.AttributeChangeNotification".equals(className)) {
                if (!"jmx.attribute.change".equals(type)) {
                    this.throwConversionException("Type for AttributeChangeNotification should be ATTRIBUTE_CHANGE", o);
                }
                String attributeName = this.readStringInternal(obj.get(N_ATTRIBUTENAME));
                String attributeType = this.readStringInternal(obj.get(N_ATTRIBUTETYPE));
                Object oldValue = this.readPOJOInternal(obj.get(N_OLDVALUE));
                Object newValue = this.readPOJOInternal(obj.get(N_NEWVALUE));
                n = new AttributeChangeNotification(source, sequenceNumber, timeStamp, message, attributeName, attributeType, oldValue, newValue);
            } else if ("javax.management.remote.JMXConnectionNotification".equals(className)) {
                String connectionId = this.readStringInternal(obj.get(N_CONNECTIONID));
                n = new JMXConnectionNotification(type, source, connectionId, sequenceNumber, message, userData);
                n.setTimeStamp(timeStamp);
            } else if ("javax.management.MBeanServerNotification".equals(className)) {
                ObjectName objectName = this.readObjectName(obj.get(N_MBEANNAME));
                n = new MBeanServerNotification(type, (Object)source, sequenceNumber, objectName);
                n.setTimeStamp(timeStamp);
            } else if ("javax.management.relation.RelationNotification".equals(className)) {
                String relationId = this.readStringInternal(obj.get(N_RELATIONID));
                String typeName = this.readStringInternal(obj.get(N_RELATIONTYPENAME));
                ObjectName objectName = this.readObjectName(obj.get(N_OBJECTNAME));
                String roleName = this.readStringInternal(obj.get(N_ROLENAME));
                if (roleName == null) {
                    List<ObjectName> mbeansToUnregister = this.readObjectNameList(obj.get(N_MBEANSTOUNREGISTER));
                    n = new RelationNotification(type, source, sequenceNumber, timeStamp, message, relationId, typeName, objectName, mbeansToUnregister);
                } else {
                    List<ObjectName> oldValue = this.readObjectNameList(obj.get(N_OLDROLEVALUE));
                    List<ObjectName> newValue = this.readObjectNameList(obj.get(N_NEWROLEVALUE));
                    n = new RelationNotification(type, source, sequenceNumber, timeStamp, message, relationId, typeName, objectName, roleName, oldValue, newValue);
                }
            } else if ("javax.management.timer.TimerNotification".equals(className)) {
                Integer notificationID = this.readIntInternal(obj.get(N_NOTIFICATIONID));
                n = new TimerNotification(type, source, sequenceNumber, timeStamp, message, notificationID);
            } else {
                Object serialized = this.readSerialized(obj.get(N_SERIALIZED));
                if (!(serialized instanceof Notification)) {
                    this.throwConversionException("readNotifications() expects a Notification.", o);
                }
                n = (Notification)serialized;
            }
            n.setUserData(userData);
            ret[i] = n;
        }
        return ret;
    }

    public void writeNotificationSettings(OutputStream out, NotificationSettings value) throws IOException {
        assert (value != null);
        this.writeStartObject(out);
        this.writeIntField(out, OM_DELIVERYINTERVAL, value.deliveryInterval);
        this.writeIntField(out, OM_INBOXEXPIRTY, value.inboxExpiry);
        this.writeEndObject(out);
    }

    public NotificationSettings readNotificationSettings(InputStream in) throws ConversionException, IOException {
        JSONObject json = this.parseObject(in);
        NotificationSettings ret = new NotificationSettings();
        ret.deliveryInterval = this.readIntInternal(json.get(N_DELIVERYINTERVAL));
        ret.inboxExpiry = this.readIntInternal(json.get(N_INBOXEXPIRY));
        return ret;
    }

    public void writeThrowable(OutputStream out, Throwable value) throws IOException {
        assert (value != null);
        this.writeStartObject(out);
        this.writeSerializedField(out, OM_THROWABLE, value);
        StringWriter sw = new StringWriter();
        value.printStackTrace(new PrintWriter(sw));
        this.writeStringField(out, OM_STACKTRACE, sw.toString());
        this.writeEndObject(out);
    }

    public Throwable readThrowable(InputStream in) throws ConversionException, IOException, ClassNotFoundException {
        JSONObject json = this.parseObject(in);
        Object t = this.readSerialized(json.get(N_THROWABLE));
        if (!(t instanceof Throwable)) {
            this.throwConversionException("readThrowable() receives an instance that's not a Throwable.", json.get(N_THROWABLE));
        }
        return (Throwable)t;
    }

    public String encodeStringAsBase64(String value) throws ConversionException {
        try {
            return this.encodeStringAsBase64Internal(value);
        }
        catch (IOException e) {
            return null;
        }
    }

    private String encodeStringAsBase64Internal(String value) throws ConversionException, IOException {
        Base64OutputStream out = this.base64Stream;
        this.byteArrayOS.reset();
        out.start(this.byteArrayOS);
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch < '\u0080') {
                out.write(ch);
                continue;
            }
            if (ch < '\u0800') {
                out.write(0xC0 | ch >> 6);
                out.write(0x80 | 0x3F & ch);
                continue;
            }
            if (ch < '\ud800' || ch >= '\ue000') {
                out.write(0xE0 | ch >> 12);
                out.write(0x80 | 0x3F & ch >> 6);
                out.write(0x80 | 0x3F & ch);
                continue;
            }
            if (ch < '\udc00') {
                if (i == value.length() - 1) {
                    this.utf8EncodeError(value);
                    continue;
                }
                char ch2 = value.charAt(i + 1);
                if (ch2 >= '\udc00' && ch2 < '\ue000') {
                    int c = 65536 + (ch - 55296 << 10) + (ch2 - 56320);
                    out.write(0xF0 | c >> 18);
                    out.write(0x80 | 0x3F & c >> 12);
                    out.write(0x80 | 0x3F & c >> 6);
                    out.write(0x80 | 0x3F & c);
                    ++i;
                    continue;
                }
                this.utf8EncodeError(value);
                continue;
            }
            this.utf8EncodeError(value);
        }
        out.end();
        return this.byteArrayOS.toString(0);
    }

    private void writeStartObject(OutputStream out) throws IOException {
        out.write(123);
        this.firstItem = true;
    }

    private void writeFieldName(OutputStream out, byte[] name) throws IOException {
        if (this.firstItem) {
            this.firstItem = false;
        } else {
            out.write(44);
        }
        out.write(name);
    }

    private void writeSimpleFieldName(OutputStream out, String name) throws IOException {
        if (this.firstItem) {
            this.firstItem = false;
        } else {
            out.write(44);
        }
        this.writeSimpleString(out, name);
        out.write(58);
    }

    private void escapeFieldName(OutputStream out, String name) throws IOException {
        if (this.firstItem) {
            this.firstItem = false;
        } else {
            out.write(44);
        }
        this.writeStringInternal(out, name);
        out.write(58);
    }

    private void writeEndObject(OutputStream out) throws IOException {
        out.write(125);
        this.firstItem = false;
    }

    private void writeStartArray(OutputStream out) throws IOException {
        out.write(91);
        this.firstItem = true;
    }

    private void writeArrayItem(OutputStream out) throws IOException {
        if (this.firstItem) {
            this.firstItem = false;
        } else {
            out.write(44);
        }
    }

    private void writeEndArray(OutputStream out) throws IOException {
        out.write(93);
        this.firstItem = false;
    }

    private Object parse(InputStream in) throws IOException {
        return JSON.parse(in);
    }

    private JSONObject parseObject(InputStream in) throws ConversionException, IOException {
        JSONArtifact json = JSON.parse(in);
        if (!(json instanceof JSONObject)) {
            this.throwConversionException("parseObject() receives an instance that's not a JSONObject.", (Object)json);
        }
        return (JSONObject)json;
    }

    private JSONArray parseArray(InputStream in) throws ConversionException, IOException {
        JSONArtifact json = JSON.parse(in);
        if (!(json instanceof JSONArray)) {
            this.throwConversionException("parseArray() receives an instance that's not a JSONArray.", (Object)json);
        }
        return (JSONArray)json;
    }

    private byte readByteInternal(Object in) throws ConversionException {
        int value = this.readIntInternal(in);
        if (value > 127 || value < -128) {
            this.throwConversionException("readByteInternal() receives an out-of-range value.", in);
        }
        return (byte)value;
    }

    private short readShortInternal(Object in) throws ConversionException {
        int value = this.readIntInternal(in);
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            this.throwConversionException("readShortInternal() receives an out-of-range value.", in);
        }
        return (short)value;
    }

    private void writeIntField(OutputStream out, byte[] name, int value) throws IOException {
        this.writeFieldName(out, name);
        this.writeIntInternal(out, value);
    }

    private void writeIntInternal(OutputStream out, int value) throws IOException {
        out.write(34);
        this.encodeInt(out, value);
        out.write(34);
    }

    private void encodeInt(OutputStream out, int value) throws IOException {
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                out.write(INT_MIN);
                return;
            }
            out.write(45);
            value = -value;
        }
        byte[] bytes = this.BYTE_BUFFER;
        int pos = this.BYTE_BUFFER.length;
        do {
            int q = value / 10;
            int r = value - (q << 3) - (q << 1);
            value = q;
            bytes[--pos] = (byte)(r + 48);
        } while (value != 0);
        out.write(bytes, pos, this.BYTE_BUFFER.length - pos);
    }

    private int readIntInternal(Object in) throws ConversionException {
        if (!(in instanceof String)) {
            this.throwConversionException("readIntInternal() expects a String.", in);
        }
        try {
            return Integer.parseInt((String)in);
        }
        catch (NumberFormatException e) {
            this.throwConversionException(e, in);
            return 0;
        }
    }

    private void writeLongField(OutputStream out, byte[] name, long value) throws IOException {
        this.writeFieldName(out, name);
        this.writeLongInternal(out, value);
    }

    private void writeLongInternal(OutputStream out, long value) throws IOException {
        out.write(34);
        this.encodeLong(out, value);
        out.write(34);
    }

    private void encodeLong(OutputStream out, long value) throws IOException {
        if (value < 0L) {
            if (value == Long.MIN_VALUE) {
                out.write(LONG_MIN);
                return;
            }
            out.write(45);
            value = -value;
        }
        byte[] bytes = this.BYTE_BUFFER;
        int pos = this.BYTE_BUFFER.length;
        do {
            long q = value / 10L;
            long r = value - (q << 3) - (q << 1);
            value = q;
            bytes[--pos] = (byte)(r + 48L);
        } while (value != 0L);
        out.write(bytes, pos, this.BYTE_BUFFER.length - pos);
    }

    private long readLongInternal(Object in) throws ConversionException {
        if (!(in instanceof String)) {
            this.throwConversionException("readLongInternal() expects a String.", in);
        }
        try {
            return Long.parseLong((String)in);
        }
        catch (NumberFormatException e) {
            this.throwConversionException(e, in);
            return 0L;
        }
    }

    private float readFloatInternal(Object in) throws ConversionException {
        if (!(in instanceof String)) {
            this.throwConversionException("readFloatInternal() expects a String.", in);
        }
        try {
            return Float.parseFloat((String)in);
        }
        catch (NumberFormatException e) {
            this.throwConversionException(e, in);
            return 0.0f;
        }
    }

    private double readDoubleInternal(Object in) throws ConversionException {
        if (!(in instanceof String)) {
            this.throwConversionException("readDoubleInternal() expects a String.", in);
        }
        try {
            return Double.parseDouble((String)in);
        }
        catch (NumberFormatException e) {
            this.throwConversionException(e, in);
            return 0.0;
        }
    }

    private char readCharInternal(Object in) throws ConversionException {
        String str;
        if (!(in instanceof String)) {
            this.throwConversionException("readCharInternal() expects a String.", in);
        }
        if ((str = (String)in).length() != 1) {
            this.throwConversionException("readCharInternal() expects a String of length 1.", in);
        }
        return str.charAt(0);
    }

    private void writeBooleanField(OutputStream out, byte[] name, boolean value) throws IOException {
        this.writeFieldName(out, name);
        this.writeBooleanInternal(out, value);
    }

    private void writeBooleanInternal(OutputStream out, boolean value) throws IOException {
        out.write(value ? TRUE : FALSE);
    }

    private boolean readBooleanInternal(Object in) throws ConversionException {
        if (!(in instanceof Boolean)) {
            this.throwConversionException("readBooleanInternal() expects a Boolean.", in);
        }
        return (Boolean)in;
    }

    private void writeSimpleStringField(OutputStream out, byte[] name, CharSequence value) throws IOException {
        this.writeFieldName(out, name);
        this.writeSimpleString(out, value);
    }

    private void writeSimpleString(OutputStream out, CharSequence value) throws IOException {
        out.write(34);
        for (int i = 0; i < value.length(); ++i) {
            out.write(value.charAt(i));
        }
        out.write(34);
    }

    private void writeStringField(OutputStream out, byte[] name, String value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeStringInternal(out, value);
    }

    private void writeStringInternal(OutputStream out, String value) throws IOException {
        if (value == null) {
            out.write(NULL);
            return;
        }
        out.write(34);
        this.escapeString(out, value);
        out.write(34);
    }

    private void escapeString(OutputStream out, String value) throws IOException {
        block7: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '\"') {
                out.write(92);
                out.write(34);
                continue;
            }
            if (ch == '\\') {
                out.write(92);
                out.write(92);
                continue;
            }
            if (ch >= '\u0080') {
                if (ch < '\u0800') {
                    out.write(0xC0 | ch >> 6);
                    out.write(0x80 | 0x3F & ch);
                    continue;
                }
                if (ch < '\ud800' || ch >= '\ue000') {
                    out.write(0xE0 | ch >> 12);
                    out.write(0x80 | 0x3F & ch >> 6);
                    out.write(0x80 | 0x3F & ch);
                    continue;
                }
                if (ch < '\udc00') {
                    if (i == value.length() - 1) {
                        this.writeInvalidChar(out, ch);
                        continue;
                    }
                    char ch2 = value.charAt(i + 1);
                    if (ch2 >= '\udc00' && ch2 < '\ue000') {
                        int c = 65536 + (ch - 55296 << 10) + (ch2 - 56320);
                        out.write(0xF0 | c >> 18);
                        out.write(0x80 | 0x3F & c >> 12);
                        out.write(0x80 | 0x3F & c >> 6);
                        out.write(0x80 | 0x3F & c);
                        ++i;
                        continue;
                    }
                    this.writeInvalidChar(out, ch);
                    continue;
                }
                this.writeInvalidChar(out, ch);
                continue;
            }
            if (ch >= ' ') {
                out.write(ch);
                continue;
            }
            out.write(92);
            switch (ch) {
                case '\b': {
                    out.write(98);
                    continue block7;
                }
                case '\t': {
                    out.write(116);
                    continue block7;
                }
                case '\n': {
                    out.write(110);
                    continue block7;
                }
                case '\f': {
                    out.write(102);
                    continue block7;
                }
                case '\r': {
                    out.write(114);
                    continue block7;
                }
                default: {
                    out.write(117);
                    out.write(48);
                    out.write(48);
                    out.write(this.hex(ch >> 4));
                    out.write(this.hex(ch & 0xF));
                }
            }
        }
    }

    private void writeInvalidChar(OutputStream out, char value) throws IOException {
        out.write(92);
        out.write(117);
        out.write(this.hex(value >> 12));
        out.write(this.hex(value >> 8 & 0xF));
        out.write(this.hex(value >> 4 & 0xF));
        out.write(this.hex(value & 0xF));
    }

    private byte hex(int value) {
        return (byte)(value < 10 ? value + 48 : value + 65 - 10);
    }

    private String readStringInternal(Object in) throws ConversionException {
        if (in == null) {
            return null;
        }
        if (!(in instanceof String)) {
            this.throwConversionException("readStringInternal() expects a String.", in);
        }
        return (String)in;
    }

    private void writeStringArrayField(OutputStream out, byte[] name, String[] value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeStringArrayInternal(out, value);
    }

    private void writeStringArrayInternal(OutputStream out, String[] value) throws IOException {
        this.writeStartArray(out);
        for (String s : value) {
            this.writeArrayItem(out);
            this.writeStringInternal(out, s);
        }
        this.writeEndArray(out);
    }

    private String[] readStringArrayInternal(Object in) throws ConversionException {
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONArray)) {
            this.throwConversionException("readStringArrayInternal() expects a JSONArray.", in);
        }
        JSONArray json = (JSONArray)in;
        int size = json.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.readStringInternal(json.get(i));
        }
        return ret;
    }

    private void writeSerializedField(OutputStream out, byte[] name, Object value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeSerialized(out, value);
    }

    private void writeSerialized(OutputStream out, Object value) throws IOException {
        if (value == null) {
            out.write(NULL);
            return;
        }
        out.write(34);
        this.base64Stream.start(out);
        ObjectOutputStream objectOut = new ObjectOutputStream(this.base64Stream);
        objectOut.writeObject(value);
        this.base64Stream.end();
        out.write(34);
    }

    private Object readSerialized(Object in) throws ConversionException, ClassNotFoundException {
        String value;
        int slen;
        if (in == null) {
            return null;
        }
        if (!(in instanceof String)) {
            this.throwConversionException("readSerialized() expects a String.", in);
        }
        if ((slen = (value = (String)in).length()) == 0 || slen / 4 * 4 != slen) {
            this.base64DecodeError(in);
        }
        int blen = slen / 4 * 3;
        byte[] binary = new byte[blen];
        char c1 = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        char c4 = '\u0000';
        int pos = 0;
        int i = 0;
        while (i < slen) {
            c1 = value.charAt(i++);
            c2 = value.charAt(i++);
            c3 = value.charAt(i++);
            c4 = value.charAt(i++);
            if (c1 >= BASE64_D.length || BASE64_D[c1] == -1 || c2 >= BASE64_D.length || BASE64_D[c2] == -1 || c2 >= BASE64_D.length || BASE64_D[c3] == -1 || c2 >= BASE64_D.length || BASE64_D[c4] == -1) {
                this.base64DecodeError(in);
            }
            c1 = BASE64_D[c1];
            c2 = BASE64_D[c2];
            c3 = BASE64_D[c3];
            c4 = BASE64_D[c4];
            binary[pos++] = (byte)(c1 << 2 | c2 >> 4);
            binary[pos++] = (byte)(c2 << 4 | c3 >> 2);
            binary[pos++] = (byte)(c3 << 6 | c4);
        }
        if (value.charAt(slen - 1) == '=') {
            if (binary[--blen] != 0) {
                this.base64DecodeError(in);
            }
            if (value.charAt(slen - 2) == '=' && binary[--blen] != 0) {
                this.base64DecodeError(in);
            }
        }
        try {
            return new ObjectInputStream(new ByteArrayInputStream(binary, 0, blen)).readObject();
        }
        catch (IOException e) {
            this.throwConversionException(e, in);
            return null;
        }
    }

    private void writePOJOField(OutputStream out, byte[] name, Object value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writePOJOInternal(out, value);
    }

    private void writePOJOInternal(OutputStream out, Object value) throws IOException {
        this.writeStartObject(out);
        if (this.hasCycle(value, new Stack<Object>())) {
            this.writeSerializedField(out, OM_SERIALIZED, value);
        } else {
            this.writeFieldName(out, OM_VALUE);
            this.writePOJOValue(out, value);
            this.writeFieldName(out, OM_TYPE);
            ArrayList openTypes = new ArrayList();
            this.writePOJOType(out, value, openTypes);
            this.writeOpenTypes(out, openTypes);
        }
        this.writeEndObject(out);
    }

    private boolean hasCycle(Object value, Stack<Object> seen) {
        if (value == null) {
            return false;
        }
        for (Object e : seen) {
            if (e != value) continue;
            return true;
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                return false;
            }
            Class<?> leaf = clazz2;
            while (leaf.isArray()) {
                leaf = leaf.getComponentType();
            }
            if (SupportedClasses.get(leaf) == null) {
                return false;
            }
            if (SimpleArrays.contains(leaf)) {
                return false;
            }
            seen.push(value);
            for (Object o : (Object[])value) {
                if (!this.hasCycle(o, seen)) continue;
                return true;
            }
            seen.pop();
            return false;
        }
        TYPE tYPE = SupportedClasses.get(clazz);
        if (tYPE == null) {
            return false;
        }
        switch (tYPE) {
            case Byte: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Character: 
            case Boolean: 
            case String: 
            case BigInteger: 
            case BigDecimal: 
            case Date: 
            case Object: {
                return false;
            }
            case Collection: {
                seen.push(value);
                for (Object o : (Collection)value) {
                    if (!this.hasCycle(o, seen)) continue;
                    return true;
                }
                seen.pop();
                return false;
            }
            case Map: {
                Map map = (Map)value;
                seen.push(value);
                for (Map.Entry entry : map.entrySet()) {
                    if (this.hasCycle(entry.getKey(), seen)) {
                        return true;
                    }
                    if (!this.hasCycle(entry.getValue(), seen)) continue;
                    return true;
                }
                seen.pop();
                return false;
            }
            case CompositeData: {
                CompositeData composite = (CompositeData)value;
                seen.push(value);
                for (String key : composite.getCompositeType().keySet()) {
                    if (!this.hasCycle(composite.get(key), seen)) continue;
                    return true;
                }
                seen.pop();
                return false;
            }
            case TabularData: {
                TabularData tabular = (TabularData)value;
                seen.push(value);
                for (Object o : tabular.values()) {
                    if (!this.hasCycle(o, seen)) continue;
                    return true;
                }
                seen.pop();
                return false;
            }
        }
        return false;
    }

    private void writePOJOValue(OutputStream out, Object value) throws IOException {
        if (value == null) {
            out.write(NULL);
            return;
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isPrimitive()) {
                this.writePrimitiveArray(out, value, componentType);
                return;
            }
            this.writeStartArray(out);
            for (Object object : (Object[])value) {
                this.writeArrayItem(out);
                this.writePOJOValue(out, object);
            }
            this.writeEndArray(out);
            return;
        }
        TYPE type = SupportedClasses.get(clazz);
        if (type == null) {
            if (value instanceof TabularData) {
                type = TYPE.TabularData;
            } else if (value instanceof CompositeData) {
                type = TYPE.CompositeData;
            } else if (value instanceof Map) {
                type = TYPE.Map;
            } else if (value instanceof Collection) {
                type = TYPE.Collection;
            } else if (value instanceof BigInteger) {
                type = TYPE.BigInteger;
            } else if (value instanceof BigDecimal) {
                type = TYPE.BigDecimal;
            } else if (value instanceof Date) {
                type = TYPE.Date;
            } else if (value instanceof ObjectName) {
                type = TYPE.ObjectName;
            } else {
                out.write(NULL);
                return;
            }
        }
        switch (type) {
            case Byte: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: 
            case BigInteger: 
            case BigDecimal: {
                this.writeSimpleString(out, value.toString());
                return;
            }
            case String: {
                this.writeStringInternal(out, (String)value);
                return;
            }
            case ObjectName: {
                this.writeObjectName(out, (ObjectName)value);
                return;
            }
            case Date: {
                this.writeLongInternal(out, ((Date)value).getTime());
                return;
            }
            case Object: {
                this.writeSimpleString(out, "");
                return;
            }
            case Character: {
                this.writeStringInternal(out, value.toString());
                return;
            }
            case Collection: {
                this.writeStartArray(out);
                for (Object o : (Collection)value) {
                    this.writeArrayItem(out);
                    this.writePOJOValue(out, o);
                }
                this.writeEndArray(out);
                return;
            }
            case Map: {
                Map map = (Map)value;
                if (map.isEmpty()) {
                    this.writeStartObject(out);
                    this.writeEndObject(out);
                    return;
                }
                boolean simpleKey = true;
                for (Object k : map.keySet()) {
                    if (k != null && SimpleKeys.contains(k.getClass())) continue;
                    simpleKey = false;
                    break;
                }
                if (simpleKey) {
                    this.writeStartObject(out);
                    for (Map.Entry entry : map.entrySet()) {
                        Object key = entry.getKey();
                        Object v = entry.getValue();
                        if (key instanceof String) {
                            this.escapeFieldName(out, (String)key);
                        } else {
                            this.writeSimpleFieldName(out, key.toString());
                        }
                        this.writePOJOValue(out, v);
                    }
                    this.writeEndObject(out);
                } else {
                    this.writeStartArray(out);
                    for (Map.Entry entry : map.entrySet()) {
                        Object key = entry.getKey();
                        this.writeArrayItem(out);
                        this.writeStartObject(out);
                        this.writeFieldName(out, OM_KEY);
                        this.writePOJOValue(out, key);
                        this.writeFieldName(out, OM_VALUE);
                        this.writePOJOValue(out, entry.getValue());
                        this.writeEndObject(out);
                    }
                    this.writeEndArray(out);
                }
                return;
            }
            case CompositeData: {
                CompositeData composite = (CompositeData)value;
                this.writeStartObject(out);
                for (String key : composite.getCompositeType().keySet()) {
                    this.escapeFieldName(out, key);
                    this.writePOJOValue(out, composite.get(key));
                }
                this.writeEndObject(out);
                return;
            }
            case TabularData: {
                TabularData tabularData = (TabularData)value;
                this.writeStartArray(out);
                for (Object item : tabularData.values()) {
                    this.writeArrayItem(out);
                    this.writePOJOValue(out, item);
                }
                this.writeEndArray(out);
                return;
            }
        }
    }

    private void writePrimitiveArray(OutputStream out, Object value, Class<?> component) throws IOException {
        switch (SupportedClasses.get(component)) {
            case _Byte: {
                this.writeStartArray(out);
                for (byte v : (byte[])value) {
                    this.writeArrayItem(out);
                    this.writeIntInternal(out, v);
                }
                this.writeEndArray(out);
                break;
            }
            case _Short: {
                this.writeStartArray(out);
                for (short v : (short[])value) {
                    this.writeArrayItem(out);
                    this.writeIntInternal(out, v);
                }
                this.writeEndArray(out);
                break;
            }
            case _Integer: {
                this.writeStartArray(out);
                for (int v : (int[])value) {
                    this.writeArrayItem(out);
                    this.writeIntInternal(out, v);
                }
                this.writeEndArray(out);
                break;
            }
            case _Long: {
                this.writeStartArray(out);
                for (long v : (long[])value) {
                    this.writeArrayItem(out);
                    this.writeLongInternal(out, v);
                }
                this.writeEndArray(out);
                break;
            }
            case _Float: {
                this.writeStartArray(out);
                for (Float v : (Float[])value) {
                    this.writeArrayItem(out);
                    this.writeSimpleString(out, Float.toString(v.floatValue()));
                }
                this.writeEndArray(out);
                break;
            }
            case _Double: {
                this.writeStartArray(out);
                for (Double v : (Double[])value) {
                    this.writeArrayItem(out);
                    this.writeSimpleString(out, Double.toString(v));
                }
                this.writeEndArray(out);
                break;
            }
            case _Character: {
                this.writeStartArray(out);
                for (char v : (char[])value) {
                    this.writeArrayItem(out);
                    this.writeIntInternal(out, v);
                }
                this.writeEndArray(out);
                break;
            }
            case _Boolean: {
                this.writeStartArray(out);
                for (boolean v : (boolean[])value) {
                    this.writeArrayItem(out);
                    out.write(v ? TRUE : FALSE);
                }
                this.writeEndArray(out);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writePOJOType(OutputStream out, Object value, List<OpenType<?>> openTypes) throws IOException {
        if (value == null) {
            out.write(NULL);
            return;
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            void var9_17;
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isPrimitive()) {
                this.writeSimpleString(out, clazz.getName());
                return;
            }
            Class<?> leaf = componentType;
            while (leaf.isArray()) {
                leaf = leaf.getComponentType();
            }
            if (SupportedClasses.get(leaf) == null) {
                this.writeStartObject(out);
                this.writeSimpleStringField(out, OM_CLASSNAME, clazz.getName());
                this.writeSerializedField(out, OM_VALUE, value);
                this.writeEndObject(out);
                return;
            }
            if (SimpleArrays.contains(leaf)) {
                this.writeSimpleString(out, clazz.getName());
                return;
            }
            this.writeStartObject(out);
            this.writeSimpleStringField(out, OM_CLASSNAME, clazz.getName());
            this.writeFieldName(out, OM_ITEMS);
            this.writeStartArray(out);
            Object[] arr$ = (Object[])value;
            int len$ = arr$.length;
            boolean bl = false;
            while (var9_17 < len$) {
                Object o = arr$[var9_17];
                this.writeArrayItem(out);
                this.writePOJOType(out, o, openTypes);
                ++var9_17;
            }
            this.writeEndArray(out);
            this.writeEndObject(out);
            return;
        }
        TYPE type = SupportedClasses.get(clazz);
        if (type == null) {
            this.writeStartObject(out);
            this.writeSimpleStringField(out, OM_CLASSNAME, clazz.getName());
            this.writeSerializedField(out, OM_VALUE, value);
            this.writeEndObject(out);
            return;
        }
        switch (type) {
            case Byte: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Character: 
            case Boolean: 
            case String: 
            case BigInteger: 
            case BigDecimal: 
            case Date: 
            case Object: 
            case ObjectName: {
                this.writeSimpleString(out, clazz.getName());
                return;
            }
            case Collection: {
                this.writeStartObject(out);
                this.writeSimpleStringField(out, OM_CLASSNAME, clazz.getName());
                this.writeFieldName(out, OM_ITEMS);
                this.writeStartArray(out);
                for (Object o : (Collection)value) {
                    this.writeArrayItem(out);
                    this.writePOJOType(out, o, openTypes);
                }
                this.writeEndArray(out);
                this.writeEndObject(out);
                return;
            }
            case Map: {
                Map map = (Map)value;
                this.writeStartObject(out);
                this.writeSimpleStringField(out, OM_CLASSNAME, clazz.getName());
                if (map.isEmpty()) {
                    this.writeEndObject(out);
                    return;
                }
                boolean simpleKey = true;
                for (Object k : map.keySet()) {
                    if (k != null && SimpleKeys.contains(k.getClass())) continue;
                    simpleKey = false;
                    break;
                }
                this.writeBooleanField(out, OM_SIMPLEKEY, simpleKey);
                this.writeFieldName(out, OM_ENTRIES);
                this.writeStartArray(out);
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    this.writeArrayItem(out);
                    this.writeStartObject(out);
                    if (simpleKey) {
                        if (key instanceof String) {
                            this.writeStringField(out, OM_KEY, (String)key);
                        } else {
                            this.writeSimpleStringField(out, OM_KEY, key.toString());
                        }
                    }
                    this.writeFieldName(out, OM_KEYTYPE);
                    this.writePOJOType(out, key, openTypes);
                    this.writeFieldName(out, OM_VALUE);
                    this.writePOJOType(out, entry.getValue(), openTypes);
                    this.writeEndObject(out);
                }
                this.writeEndArray(out);
                this.writeEndObject(out);
                return;
            }
            case CompositeData: {
                CompositeData composite = (CompositeData)value;
                this.writeStartObject(out);
                this.writeSimpleStringField(out, OM_CLASSNAME, clazz.getName());
                CompositeType compositeType = composite.getCompositeType();
                this.writeOpenTypeField(out, OM_OPENTYPE, compositeType, openTypes);
                this.writeEndObject(out);
                return;
            }
            case TabularData: {
                TabularData tabular = (TabularData)value;
                this.writeStartObject(out);
                this.writeSimpleStringField(out, OM_CLASSNAME, clazz.getName());
                TabularType tt = tabular.getTabularType();
                this.writeOpenTypeField(out, OM_OPENTYPE, tt, openTypes);
                this.writeEndObject(out);
            }
        }
    }

    private void writeOpenTypeField(OutputStream out, byte[] name, OpenType<?> openType, List<OpenType<?>> openTypes) throws IOException {
        int idx = openTypes.indexOf(openType);
        if (idx < 0) {
            this.writeIntField(out, name, openTypes.size());
            openTypes.add(openType);
        } else {
            this.writeIntField(out, name, idx);
        }
    }

    private void writeOpenTypes(OutputStream out, List<OpenType<?>> openTypes) throws IOException {
        if (openTypes.isEmpty()) {
            return;
        }
        this.writeFieldName(out, OM_OPENTYPES);
        this.writeStartArray(out);
        for (int i = 0; i < openTypes.size(); ++i) {
            this.writeArrayItem(out);
            OpenType<?> ot = openTypes.get(i);
            Class<?> clazz = ot.getClass();
            if (clazz == SimpleType.class) {
                this.writeSimpleString(out, ((SimpleType)ot).getTypeName());
                continue;
            }
            this.writeStartObject(out);
            this.writeSimpleStringField(out, OM_OPENTYPECLASS, clazz.getName());
            this.writeSimpleStringField(out, OM_CLASSNAME, ot.getClassName());
            this.writeStringField(out, OM_TYPENAME, ot.getTypeName());
            this.writeStringField(out, OM_DESCRIPTION, ot.getDescription());
            if (clazz == ArrayType.class) {
                ArrayType at = (ArrayType)ot;
                this.writeIntField(out, OM_DIMENSION, at.getDimension());
                OpenType<?> elemntType = at.getElementOpenType();
                this.writeOpenTypeField(out, OM_ELEMENTTYPE, elemntType, openTypes);
            } else if (clazz == CompositeType.class) {
                CompositeType ct = (CompositeType)ot;
                this.writeFieldName(out, OM_ITEMS);
                this.writeStartArray(out);
                for (String key : ct.keySet()) {
                    this.writeArrayItem(out);
                    this.writeStartObject(out);
                    this.writeStringField(out, OM_KEY, key);
                    this.writeStringField(out, OM_DESCRIPTION, ct.getDescription(key));
                    this.writeOpenTypeField(out, OM_TYPE, ct.getType(key), openTypes);
                    this.writeEndObject(out);
                }
                this.writeEndArray(out);
            } else if (clazz == TabularType.class) {
                TabularType tt = (TabularType)ot;
                this.writeOpenTypeField(out, OM_ROWTYPE, tt.getRowType(), openTypes);
                this.writeFieldName(out, OM_INDEXNAMES);
                this.writeStartArray(out);
                for (String name : tt.getIndexNames()) {
                    this.writeArrayItem(out);
                    this.writeStringInternal(out, name);
                }
                this.writeEndArray(out);
            } else {
                this.writeSerializedField(out, OM_SERIALIZED, ot);
            }
            this.writeEndObject(out);
        }
        this.writeEndArray(out);
    }

    private Object readPOJOInternal(Object in) throws ConversionException, ClassNotFoundException {
        JSONObject json;
        Object o;
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONObject)) {
            this.throwConversionException("readPOJOInternal() expects a JSONObject.", in);
        }
        if ((o = (json = (JSONObject)in).get(N_SERIALIZED)) != null) {
            return this.readSerialized(o);
        }
        OpenType<?>[] openTypes = this.readOpenTypes(json.get(N_OPENTYPES));
        return this.readPOJOValue(json.get(N_VALUE), json.get(N_TYPE), openTypes);
    }

    private OpenType<?>[] readOpenTypes(Object in) throws ConversionException, ClassNotFoundException {
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONArray)) {
            this.throwConversionException("readOpenTypes() expects a JSONArray.", in);
        }
        JSONArray json = (JSONArray)in;
        int size = json.size();
        OpenType[] openTypes = new OpenType[size];
        try {
            for (int i = 0; i < size; ++i) {
                this.readOpenType(json, i, openTypes);
            }
        }
        catch (OpenDataException e) {
            this.throwConversionException(e, in);
        }
        return openTypes;
    }

    private OpenType<?> readOpenType(JSONArray json, int i, OpenType<?>[] openTypes) throws ConversionException, ClassNotFoundException, OpenDataException {
        JSONObject type;
        Object serialized;
        if (openTypes[i] != null) {
            return openTypes[i];
        }
        Object o = json.get(i);
        if (o instanceof String) {
            openTypes[i] = Name2SimpleTypes.get(o);
            if (openTypes[i] == null) {
                this.throwConversionException("readOpenType() received an unknown simple type name.", o);
            }
            return openTypes[i];
        }
        if (!(o instanceof JSONObject)) {
            this.throwConversionException("readOpenType() expects a JSONObject.", o);
        }
        if ((serialized = (type = (JSONObject)o).get(N_SERIALIZED)) != null) {
            Object ret = this.readSerialized(serialized);
            if (!(ret instanceof OpenType)) {
                this.throwConversionException("readOpenType() expects an OpenType.", serialized);
            }
            openTypes[i] = (OpenType)ret;
            return openTypes[i];
        }
        String openTypeClass = this.readStringInternal(type.get(N_OPENTYPECLASS));
        if ("javax.management.openmbean.ArrayType".equals(openTypeClass)) {
            int dimension = this.readIntInternal(type.get(N_DIMENSION));
            int elementType = this.readIntInternal(type.get(N_ELEMENTTYPE));
            if (elementType < 0 || elementType >= openTypes.length) {
                this.throwConversionException("readOpenType() receives an out-of-range open type index.", type.get(N_ELEMENTTYPE));
            }
            OpenType<?> etype = this.readOpenType(json, elementType, openTypes);
            openTypes[i] = new ArrayType(dimension, etype);
            return openTypes[i];
        }
        if ("javax.management.openmbean.CompositeType".equals(openTypeClass)) {
            String typeName = this.readStringInternal(type.get(N_TYPENAME));
            String description = this.readStringInternal(type.get(N_DESCRIPTION));
            o = type.get(N_ITEMS);
            if (!(o instanceof JSONArray)) {
                this.throwConversionException("readOpenType() expects a JSONArray.", o);
            }
            JSONArray items = (JSONArray)o;
            int size = items.size();
            String[] itemNames = new String[size];
            String[] itemDescriptions = new String[size];
            OpenType[] itemTypes = new OpenType[size];
            for (int p = 0; p < size; ++p) {
                o = items.get(p);
                if (!(o instanceof JSONObject)) {
                    this.throwConversionException("readOpenType() expects a JSONObject.", o);
                }
                JSONObject item = (JSONObject)o;
                itemNames[p] = this.readStringInternal(item.get(N_KEY));
                itemDescriptions[p] = this.readStringInternal(item.get(N_DESCRIPTION));
                int itemType = this.readIntInternal(item.get(N_TYPE));
                if (itemType < 0 || itemType >= openTypes.length) {
                    this.throwConversionException("readOpenType() receives an out-of-range open type index.", item.get(N_TYPE));
                }
                itemTypes[p] = this.readOpenType(json, itemType, openTypes);
            }
            openTypes[i] = new CompositeType(typeName, description, itemNames, itemDescriptions, itemTypes);
            return openTypes[i];
        }
        if ("javax.management.openmbean.TabularType".equals(openTypeClass)) {
            OpenType<?> rtype;
            String typeName = this.readStringInternal(type.get(N_TYPENAME));
            String description = this.readStringInternal(type.get(N_DESCRIPTION));
            int rowType = this.readIntInternal(type.get(N_ROWTYPE));
            if (rowType < 0 || rowType >= openTypes.length) {
                this.throwConversionException("readOpenType() receives an out-of-range open type index.", type.get(N_ROWTYPE));
            }
            if (!((rtype = this.readOpenType(json, rowType, openTypes)) instanceof CompositeType)) {
                this.throwConversionException("readOpenType() expects a CompositeType.", rtype);
            }
            if (!((o = type.get(N_INDEXNAMES)) instanceof JSONArray)) {
                this.throwConversionException("readOpenType() expects a JSONArray.", o);
            }
            JSONArray names = (JSONArray)o;
            int size = names.size();
            String[] indexNames = new String[size];
            for (int p = 0; p < size; ++p) {
                indexNames[i] = this.readStringInternal(names.get(p));
            }
            openTypes[i] = new TabularType(typeName, description, (CompositeType)rtype, indexNames);
            return openTypes[i];
        }
        this.throwConversionException("readOpenType() received an unknown open type class.", (Object)openTypeClass);
        return null;
    }

    private Object readPOJOValue(Object value, Object type, OpenType<?>[] openTypes) throws ConversionException, ClassNotFoundException {
        String className;
        TYPE t;
        JSONObject tjson;
        Object o;
        if (type == null) {
            return null;
        }
        if (type instanceof String) {
            String tstr = (String)type;
            TYPE t2 = SimpleValues.get(tstr);
            if (t2 == null) {
                if (tstr.length() > 0 && tstr.charAt(0) == '[') {
                    return this.readSimpleArray(value, Class.forName(tstr));
                }
                this.throwConversionException("readPOJOValue() received an unknown class name.", type);
            }
            return this.readSimpleValue(value, t2);
        }
        if (!(type instanceof JSONObject)) {
            this.throwConversionException("readPOJOValue() expects a JSONObject.", type);
        }
        if ((o = (tjson = (JSONObject)type).get(N_VALUE)) != null) {
            return this.readSerialized(o);
        }
        o = tjson.get(N_CLASSNAME);
        if (o == null || !(o instanceof String)) {
            this.throwConversionException("readPOJOValue() expects a String.", o);
        }
        if ((t = StructuredClasses.get(className = (String)o)) == null) {
            if (className.length() > 0 && className.charAt(0) == '[') {
                return this.readComplexArray(value, Class.forName(className), tjson.get(N_ITEMS), openTypes);
            }
            this.throwConversionException("readPOJOValue() received an unknown class name.", o);
        }
        switch (t) {
            case ArrayList: {
                return this.readCollectionValue(value, tjson, new ArrayList<Object>(), openTypes);
            }
            case LinkedList: {
                return this.readCollectionValue(value, tjson, new LinkedList<Object>(), openTypes);
            }
            case Vector: {
                return this.readCollectionValue(value, tjson, new Vector<Object>(), openTypes);
            }
            case HashSet: {
                return this.readCollectionValue(value, tjson, new HashSet<Object>(), openTypes);
            }
            case HashMap: {
                return this.readMapValue(value, tjson, new HashMap<Object, Object>(), openTypes);
            }
            case Hashtable: {
                return this.readMapValue(value, tjson, new Hashtable<Object, Object>(), openTypes);
            }
            case TreeMap: {
                return this.readMapValue(value, tjson, new TreeMap<Object, Object>(), openTypes);
            }
            case CompositeDataSupport: 
            case TabularDataSupport: {
                int ot = this.readIntInternal(tjson.get(N_OPENTYPE));
                return this.readOpenData(value, openTypes[ot]);
            }
        }
        return null;
    }

    private Object readSimpleValue(Object value, TYPE t) throws ConversionException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            this.throwConversionException("readSimpleValue() expects a String.", value);
        }
        String vstr = (String)value;
        switch (t) {
            case Byte: {
                return Byte.valueOf(vstr);
            }
            case Short: {
                return Short.valueOf(vstr);
            }
            case Integer: {
                return Integer.valueOf(vstr);
            }
            case Long: {
                return Long.valueOf(vstr);
            }
            case Float: {
                return Float.valueOf(vstr);
            }
            case Double: {
                return Double.valueOf(vstr);
            }
            case Character: {
                if (vstr.length() != 1) {
                    this.throwConversionException("readSimpleValue() expects a String of length 1 for Characgter.", value);
                }
                return Character.valueOf(vstr.charAt(0));
            }
            case Boolean: {
                return Boolean.valueOf(vstr);
            }
            case String: {
                return vstr;
            }
            case BigInteger: {
                return new BigInteger(vstr);
            }
            case BigDecimal: {
                return new BigDecimal(vstr);
            }
            case Date: {
                return new Date(this.readLongInternal(vstr));
            }
            case ObjectName: {
                return this.readObjectName(vstr);
            }
            case Object: {
                if (vstr.length() != 0) {
                    this.throwConversionException("readSimpleValue() expects an empty String for Object.", value);
                }
                return OBJECT;
            }
        }
        return null;
    }

    private Object readSimpleArray(Object value, Class<?> array) throws ConversionException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof JSONArray)) {
            this.throwConversionException("readSimpleArray() expects a JSONArray.", value);
        }
        JSONArray json = (JSONArray)value;
        int size = json.size();
        Class<?> component = array.getComponentType();
        if (component.isArray()) {
            Object[] ret = (Object[])Array.newInstance(component, size);
            for (int i = 0; i < size; ++i) {
                ret[i] = this.readSimpleArray(json.get(i), component);
            }
            return ret;
        }
        if (component.isPrimitive()) {
            return this.readPrimitiveArray(json, SupportedClasses.get(component));
        }
        Object[] ret = (Object[])Array.newInstance(component, size);
        for (int i = 0; i < size; ++i) {
            ret[i] = this.readSimpleValue(json.get(i), SupportedClasses.get(component));
        }
        return ret;
    }

    private Object readPrimitiveArray(JSONArray value, TYPE type) throws ConversionException {
        int size = value.size();
        switch (type) {
            case _Byte: {
                byte[] bytes = new byte[size];
                for (int i = 0; i < size; ++i) {
                    bytes[i] = this.readByteInternal(value.get(i));
                }
                return bytes;
            }
            case _Short: {
                short[] shorts = new short[size];
                for (int i = 0; i < size; ++i) {
                    shorts[i] = this.readShortInternal(value.get(i));
                }
                return shorts;
            }
            case _Integer: {
                int[] ints = new int[size];
                for (int i = 0; i < size; ++i) {
                    ints[i] = this.readIntInternal(value.get(i));
                }
                return ints;
            }
            case _Long: {
                long[] longs = new long[size];
                for (int i = 0; i < size; ++i) {
                    longs[i] = this.readLongInternal(value.get(i));
                }
                return longs;
            }
            case _Float: {
                float[] floats = new float[size];
                for (int i = 0; i < size; ++i) {
                    floats[i] = this.readFloatInternal(value.get(i));
                }
                return floats;
            }
            case _Double: {
                double[] doubles = new double[size];
                for (int i = 0; i < size; ++i) {
                    doubles[i] = this.readDoubleInternal(value.get(i));
                }
                return doubles;
            }
            case _Character: {
                char[] chars = new char[size];
                for (int i = 0; i < size; ++i) {
                    chars[i] = this.readCharInternal(value.get(i));
                }
                return chars;
            }
            case _Boolean: {
                boolean[] bools = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    bools[i] = this.readBooleanInternal(value.get(i));
                }
                return bools;
            }
        }
        return null;
    }

    private Object readComplexArray(Object value, Class<?> array, Object type, OpenType<?>[] openTypes) throws ConversionException, ClassNotFoundException {
        if (!(value instanceof JSONArray)) {
            this.throwConversionException("readComplexArray() expects a JSONArray.", value);
        }
        if (!(type instanceof JSONArray)) {
            this.throwConversionException("readComplexArray() expects a JSONArray.", type);
        }
        JSONArray vjson = (JSONArray)value;
        JSONArray tjson = (JSONArray)type;
        int size = tjson.size();
        if (size != vjson.size()) {
            this.throwConversionException("readComplexArray() expects same size from value and type arrays.", null);
        }
        Object[] ret = (Object[])Array.newInstance(array.getComponentType(), size);
        for (int i = 0; i < size; ++i) {
            ret[i] = this.readPOJOValue(vjson.get(i), tjson.get(i), openTypes);
        }
        return ret;
    }

    private Object readCollectionValue(Object value, JSONObject t, Collection<Object> ret, OpenType<?>[] openTypes) throws ConversionException, ClassNotFoundException {
        Object type = t.get(N_ITEMS);
        if (!(value instanceof JSONArray)) {
            this.throwConversionException("readCollectionValue() expects a JSONArray.", value);
        }
        if (!(type instanceof JSONArray)) {
            this.throwConversionException("readCollectionValue() expects a JSONArray.", type);
        }
        JSONArray vjson = (JSONArray)value;
        JSONArray tjson = (JSONArray)type;
        if (vjson.size() != tjson.size()) {
            this.throwConversionException("readCollectionValue() expects same size from value and type arrays.", null);
        }
        for (int i = 0; i < tjson.size(); ++i) {
            ret.add(this.readPOJOValue(vjson.get(i), tjson.get(i), openTypes));
        }
        return ret;
    }

    private Object readMapValue(Object value, JSONObject t, Map<Object, Object> ret, OpenType<?>[] openTypes) throws ConversionException, ClassNotFoundException {
        Object simple = t.get(N_SIMPLEKEY);
        if (!(simple instanceof Boolean)) {
            this.throwConversionException("readMapValue() expects a Boolean.", simple);
        }
        boolean simpleKey = (Boolean)simple;
        Object type = t.get(N_ENTRIES);
        if (!(type instanceof JSONArray)) {
            this.throwConversionException("readMapValue() expects a JSONArray.", type);
        }
        JSONArray tjson = (JSONArray)type;
        if (simpleKey) {
            if (!(value instanceof JSONObject)) {
                this.throwConversionException("readMapValue() expects a JSONObject.", value);
            }
            JSONObject vjson = (JSONObject)value;
            if (tjson.size() != vjson.size()) {
                this.throwConversionException("readMapValue() expects same size from value and type arrays.", null);
            }
            for (Object e : tjson) {
                JSONObject entry;
                Object k;
                if (!(e instanceof JSONObject)) {
                    this.throwConversionException("readMapValue() expects a JSONObject.", e);
                }
                if (!((k = (entry = (JSONObject)e).get(N_KEY)) instanceof String)) {
                    this.throwConversionException("readMapValue() expects a String.", k);
                }
                String key = (String)k;
                ret.put(this.readPOJOValue(key, entry.get(N_KEYTYPE), openTypes), this.readPOJOValue(vjson.get(key), entry.get(N_VALUE), openTypes));
            }
        } else {
            if (!(value instanceof JSONArray)) {
                this.throwConversionException("readMapValue() expects a JSONArray.", value);
            }
            JSONArray vjson = (JSONArray)value;
            if (tjson.size() != vjson.size()) {
                this.throwConversionException("readMapValue() expects same size from value and type arrays.", null);
            }
            for (int i = 0; i < tjson.size(); ++i) {
                Object te = tjson.get(i);
                if (!(te instanceof JSONObject)) {
                    this.throwConversionException("readMapValue() expects a JSONObject.", te);
                }
                JSONObject tentry = (JSONObject)te;
                Object ve = vjson.get(i);
                if (!(ve instanceof JSONObject)) {
                    this.throwConversionException("readMapValue() expects a JSONObject.", ve);
                }
                JSONObject ventry = (JSONObject)ve;
                ret.put(this.readPOJOValue(ventry.get(N_KEY), tentry.get(N_KEYTYPE), openTypes), this.readPOJOValue(ventry.get(N_VALUE), tentry.get(N_VALUE), openTypes));
            }
        }
        return ret;
    }

    private Object readOpenData(Object value, OpenType<?> openType) throws ConversionException {
        if (value == null) {
            return null;
        }
        if (openType instanceof SimpleType) {
            return this.readSimpleValue(value, SimpleOpenTypes.get(openType));
        }
        if (openType instanceof ArrayType) {
            ArrayType at = (ArrayType)openType;
            OpenType<?> elementOT = at.getElementOpenType();
            Class<?> elementType = null;
            try {
                elementType = Class.forName(elementOT.getClassName());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (!(value instanceof JSONArray)) {
                this.throwConversionException("readOpenData() expects a JSONArray.", value);
            }
            JSONArray json = (JSONArray)value;
            if (at.isPrimitiveArray()) {
                return this.readPrimitiveArray(json, SupportedClasses.get(elementType));
            }
            int size = json.size();
            Object[] ret = (Object[])Array.newInstance(elementType, size);
            for (int i = 0; i < size; ++i) {
                ret[i] = this.readOpenData(json.get(i), elementOT);
            }
            return ret;
        }
        if (openType instanceof CompositeType) {
            return this.readCompositeData(value, (CompositeType)openType);
        }
        if (openType instanceof TabularType) {
            TabularType tt = (TabularType)openType;
            CompositeType row = tt.getRowType();
            if (!(value instanceof JSONArray)) {
                this.throwConversionException("readOpenData() expects a JSONArray.", value);
            }
            JSONArray json = (JSONArray)value;
            TabularDataSupport ret = new TabularDataSupport(tt);
            for (Object o : json) {
                ret.put(this.readCompositeData(o, row));
            }
            return ret;
        }
        return null;
    }

    private CompositeData readCompositeData(Object value, CompositeType ct) throws ConversionException {
        Set<String> keys = ct.keySet();
        if (!(value instanceof JSONObject)) {
            this.throwConversionException("readCompositeData() expects a JSONObject.", value);
        }
        JSONObject json = (JSONObject)value;
        int size = keys.size();
        if (size != json.size()) {
            this.throwConversionException("readCompositeData() expects the same number of entries as in the type.", (Object)json);
        }
        String[] names = new String[size];
        Object[] values = new Object[size];
        int i = 0;
        Iterator<String> i$ = keys.iterator();
        while (i$.hasNext()) {
            String key;
            names[i] = key = i$.next();
            values[i++] = this.readOpenData(json.get(key), ct.getType(key));
        }
        try {
            return new CompositeDataSupport(ct, names, values);
        }
        catch (OpenDataException e) {
            return null;
        }
    }

    private void writePOJOArrayField(OutputStream out, byte[] name, Object[] value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writePOJOArray(out, value);
    }

    private void writePOJOArray(OutputStream out, Object[] value) throws IOException {
        this.writeStartArray(out);
        for (Object o : value) {
            this.writeArrayItem(out);
            this.writePOJOInternal(out, o);
        }
        this.writeEndArray(out);
    }

    private Object[] readPOJOArray(Object in) throws ConversionException, ClassNotFoundException {
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONArray)) {
            this.throwConversionException("readPOJOArray() expects a JSONArray.", in);
        }
        JSONArray json = (JSONArray)in;
        int size = json.size();
        Object[] ret = new Object[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.readPOJOInternal(json.get(i));
        }
        return ret;
    }

    private void writeObjectNameListField(OutputStream out, byte[] name, List<ObjectName> value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeStartArray(out);
        for (ObjectName item : value) {
            this.writeArrayItem(out);
            this.writeObjectName(out, item);
        }
        this.writeEndArray(out);
    }

    private List<ObjectName> readObjectNameList(Object in) throws ConversionException {
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONArray)) {
            this.throwConversionException("readObjectNameList() expects a JSONArray.", in);
        }
        JSONArray json = (JSONArray)in;
        int size = json.size();
        ArrayList<ObjectName> ret = new ArrayList<ObjectName>(size);
        for (Object o : json) {
            ret.add(this.readObjectName(o));
        }
        return ret;
    }

    private void writeObjectNameField(OutputStream out, byte[] name, ObjectName value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeObjectName(out, value);
    }

    private void writeObjectName(OutputStream out, ObjectName value) throws IOException {
        this.writeStringInternal(out, value.toString());
    }

    private ObjectName readObjectName(Object in) throws ConversionException {
        if (in == null) {
            return null;
        }
        try {
            return new ObjectName(this.readStringInternal(in));
        }
        catch (MalformedObjectNameException e) {
            this.throwConversionException(e, in);
            return null;
        }
    }

    private ObjectInstanceWrapper readObjectInstanceInternal(Object in) throws ConversionException {
        if (!(in instanceof JSONObject)) {
            this.throwConversionException("readObjectInstanceInternal() expects a JSONObject.", in);
        }
        JSONObject json = (JSONObject)in;
        ObjectName objectName = this.readObjectName(json.get(N_OBJECTNAME));
        String className = this.readStringInternal(json.get(N_CLASSNAME));
        ObjectInstanceWrapper ret = new ObjectInstanceWrapper();
        ret.objectInstance = new ObjectInstance(objectName, className);
        ret.mbeanInfoURL = this.readStringInternal(json.get(N_URL));
        return ret;
    }

    private void writeDescriptor(OutputStream out, byte[] name, Descriptor value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeStartObject(out);
        String[] names = value.getFieldNames();
        this.writeStringArrayField(out, OM_NAMES, names);
        this.writePOJOArrayField(out, OM_VALUES, value.getFieldValues(names));
        this.writeEndObject(out);
    }

    private Descriptor readDescriptor(Object in) throws ConversionException, ClassNotFoundException {
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONObject)) {
            this.throwConversionException("readDescriptor() expects a JSONObject.", in);
        }
        JSONObject json = (JSONObject)in;
        String[] names = this.readStringArrayInternal(json.get(N_NAMES));
        Object[] values = this.readPOJOArray(json.get(N_VALUES));
        return new ImmutableDescriptor(names, values);
    }

    private void writeAttributes(OutputStream out, byte[] name, MBeanAttributeInfo[] value, Map<String, String> urls) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeStartArray(out);
        for (MBeanAttributeInfo item : value) {
            this.writeArrayItem(out);
            this.writeStartObject(out);
            this.writeStringField(out, OM_NAME, item.getName());
            this.writeStringField(out, OM_TYPE, item.getType());
            this.writeStringField(out, OM_DESCRIPTION, item.getDescription());
            this.writeDescriptor(out, OM_DESCRIPTOR, item.getDescriptor());
            this.writeBooleanField(out, OM_ISIS, item.isIs());
            this.writeBooleanField(out, OM_ISREADABLE, item.isReadable());
            this.writeBooleanField(out, OM_ISWRITABLE, item.isWritable());
            assert (urls.containsKey(item.getName()));
            this.writeStringField(out, OM_URL, urls.get(item.getName()));
            this.writeEndObject(out);
        }
        this.writeEndArray(out);
    }

    private MBeanAttributeInfo[] readAttributes(Object in, Map<String, String> urls) throws ConversionException, ClassNotFoundException {
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONArray)) {
            this.throwConversionException("readAttributes() expects a JSONArray.", in);
        }
        JSONArray json = (JSONArray)in;
        MBeanAttributeInfo[] ret = new MBeanAttributeInfo[json.size()];
        int pos = 0;
        for (Object item : json) {
            if (!(item instanceof JSONObject)) {
                this.throwConversionException("readAttributes() expects a JSONObject.", item);
            }
            JSONObject value = (JSONObject)item;
            String name = this.readStringInternal(value.get(N_NAME));
            String type = this.readStringInternal(value.get(N_TYPE));
            String description = this.readStringInternal(value.get(N_DESCRIPTION));
            boolean isReadable = this.readBooleanInternal(value.get(N_ISREADABLE));
            boolean isWritable = this.readBooleanInternal(value.get(N_ISWRITABLE));
            boolean isIs = this.readBooleanInternal(value.get(N_ISIS));
            Descriptor descriptor = this.readDescriptor(value.get(N_DESCRIPTOR));
            ret[pos++] = new MBeanAttributeInfo(name, type, description, isReadable, isWritable, isIs, descriptor);
            urls.put(name, this.readStringInternal(value.get(N_URL)));
        }
        return ret;
    }

    private void writeConstructors(OutputStream out, byte[] name, MBeanConstructorInfo[] value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeStartArray(out);
        for (MBeanConstructorInfo item : value) {
            this.writeArrayItem(out);
            this.writeStartObject(out);
            this.writeStringField(out, OM_NAME, item.getName());
            this.writeStringField(out, OM_DESCRIPTION, item.getDescription());
            this.writeDescriptor(out, OM_DESCRIPTOR, item.getDescriptor());
            this.writeParameters(out, OM_SIGNATURE, item.getSignature());
            this.writeEndObject(out);
        }
        this.writeEndArray(out);
    }

    private MBeanConstructorInfo[] readConstructors(Object in) throws ConversionException, ClassNotFoundException {
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONArray)) {
            this.throwConversionException("readConstructors() expects a JSONArray.", in);
        }
        JSONArray json = (JSONArray)in;
        MBeanConstructorInfo[] ret = new MBeanConstructorInfo[json.size()];
        int pos = 0;
        for (Object item : json) {
            if (!(item instanceof JSONObject)) {
                this.throwConversionException("readConstructors() expects a JSONObject.", item);
            }
            JSONObject value = (JSONObject)item;
            String name = this.readStringInternal(value.get(N_NAME));
            String description = this.readStringInternal(value.get(N_DESCRIPTION));
            MBeanParameterInfo[] signature = this.readParameters(value.get(N_SIGNATURE));
            Descriptor descriptor = this.readDescriptor(value.get(N_DESCRIPTOR));
            ret[pos++] = new MBeanConstructorInfo(name, description, signature, descriptor);
        }
        return ret;
    }

    private void writeParameters(OutputStream out, byte[] name, MBeanParameterInfo[] value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeStartArray(out);
        for (MBeanParameterInfo item : value) {
            this.writeArrayItem(out);
            this.writeStartObject(out);
            this.writeStringField(out, OM_NAME, item.getName());
            this.writeStringField(out, OM_TYPE, item.getType());
            this.writeStringField(out, OM_DESCRIPTION, item.getDescription());
            this.writeDescriptor(out, OM_DESCRIPTOR, item.getDescriptor());
            this.writeEndObject(out);
        }
        this.writeEndArray(out);
    }

    private MBeanParameterInfo[] readParameters(Object in) throws ConversionException, ClassNotFoundException {
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONArray)) {
            this.throwConversionException("readParameters() expects a JSONArray.", in);
        }
        JSONArray json = (JSONArray)in;
        MBeanParameterInfo[] ret = new MBeanParameterInfo[json.size()];
        int pos = 0;
        for (Object item : json) {
            if (!(item instanceof JSONObject)) {
                this.throwConversionException("readParameters() expects a JSONObject.", item);
            }
            JSONObject value = (JSONObject)item;
            String name = this.readStringInternal(value.get(N_NAME));
            String type = this.readStringInternal(value.get(N_TYPE));
            String description = this.readStringInternal(value.get(N_DESCRIPTION));
            Descriptor descriptor = this.readDescriptor(value.get(N_DESCRIPTOR));
            ret[pos++] = new MBeanParameterInfo(name, type, description, descriptor);
        }
        return ret;
    }

    private void writeNotifications(OutputStream out, byte[] name, MBeanNotificationInfo[] value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeStartArray(out);
        for (MBeanNotificationInfo item : value) {
            this.writeArrayItem(out);
            this.writeStartObject(out);
            this.writeStringField(out, OM_NAME, item.getName());
            this.writeStringField(out, OM_DESCRIPTION, item.getDescription());
            this.writeDescriptor(out, OM_DESCRIPTOR, item.getDescriptor());
            this.writeStringArrayField(out, OM_NOTIFTYPES, item.getNotifTypes());
            this.writeEndObject(out);
        }
        this.writeEndArray(out);
    }

    private MBeanNotificationInfo[] readNotifications(Object in) throws ConversionException, ClassNotFoundException {
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONArray)) {
            this.throwConversionException("readNotifications() expects a JSONArray.", in);
        }
        JSONArray json = (JSONArray)in;
        MBeanNotificationInfo[] ret = new MBeanNotificationInfo[json.size()];
        int pos = 0;
        for (Object item : json) {
            if (!(item instanceof JSONObject)) {
                this.throwConversionException("readNotifications() expects a JSONObject.", item);
            }
            JSONObject value = (JSONObject)item;
            String name = this.readStringInternal(value.get(N_NAME));
            String description = this.readStringInternal(value.get(N_DESCRIPTION));
            String[] notifTypes = this.readStringArrayInternal(value.get(N_NOTIFTYPES));
            Descriptor descriptor = this.readDescriptor(value.get(N_DESCRIPTOR));
            ret[pos++] = new MBeanNotificationInfo(notifTypes, name, description, descriptor);
        }
        return ret;
    }

    private void writeOperations(OutputStream out, byte[] name, MBeanOperationInfo[] value, Map<String, String> urls) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeStartArray(out);
        for (MBeanOperationInfo item : value) {
            this.writeArrayItem(out);
            this.writeStartObject(out);
            this.writeStringField(out, OM_NAME, item.getName());
            this.writeStringField(out, OM_DESCRIPTION, item.getDescription());
            this.writeDescriptor(out, OM_DESCRIPTOR, item.getDescriptor());
            this.writeIntField(out, OM_IMPACT, item.getImpact());
            this.writeStringField(out, OM_RETURNTYPE, item.getReturnType());
            this.writeParameters(out, OM_SIGNATURE, item.getSignature());
            assert (urls.containsKey(item.getName()));
            this.writeStringField(out, OM_URL, urls.get(item.getName()));
            this.writeEndObject(out);
        }
        this.writeEndArray(out);
    }

    private MBeanOperationInfo[] readOperations(Object in, Map<String, String> urls) throws ConversionException, ClassNotFoundException {
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONArray)) {
            this.throwConversionException("readOperations() expects a JSONArray.", in);
        }
        JSONArray json = (JSONArray)in;
        MBeanOperationInfo[] ret = new MBeanOperationInfo[json.size()];
        int pos = 0;
        for (Object item : json) {
            if (!(item instanceof JSONObject)) {
                this.throwConversionException("readOperations() expects a JSONObject.", item);
            }
            JSONObject value = (JSONObject)item;
            String description = this.readStringInternal(value.get(N_DESCRIPTION));
            String name = this.readStringInternal(value.get(N_NAME));
            int impact = this.readIntInternal(value.get(N_IMPACT));
            String returnType = this.readStringInternal(value.get(N_RETURNTYPE));
            MBeanParameterInfo[] signature = this.readParameters(value.get(N_SIGNATURE));
            Descriptor descriptor = this.readDescriptor(value.get(N_DESCRIPTOR));
            ret[pos++] = new MBeanOperationInfo(name, description, signature, returnType, impact, descriptor);
            urls.put(name, this.readStringInternal(value.get(N_URL)));
        }
        return ret;
    }

    private void writeNotificationFiltersField(OutputStream out, byte[] name, NotificationFilter[] value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeNotificationFiltersInternal(out, value);
    }

    private void writeNotificationFiltersInternal(OutputStream out, NotificationFilter[] value) throws IOException {
        this.writeStartArray(out);
        if (value != null) {
            for (NotificationFilter item : value) {
                this.writeArrayItem(out);
                this.writeNotificationFilterInternal(out, item, false);
            }
        }
        this.writeEndArray(out);
    }

    private void writeNotificationFilterInternal(OutputStream out, NotificationFilter value, boolean allowOther) throws IOException {
        assert (value != null);
        this.writeStartObject(out);
        Class<?> clazz = value.getClass();
        this.writeSimpleStringField(out, OM_CLASSNAME, clazz.getName());
        if (clazz == AttributeChangeNotificationFilter.class) {
            this.writeFieldName(out, OM_ENABLED);
            this.writeStartArray(out);
            for (String e : ((AttributeChangeNotificationFilter)value).getEnabledAttributes()) {
                this.writeArrayItem(out);
                this.writeStringInternal(out, e);
            }
            this.writeEndArray(out);
        } else if (clazz == MBeanServerNotificationFilter.class) {
            MBeanServerNotificationFilter filter = (MBeanServerNotificationFilter)value;
            byte[] fieldName = OM_ENABLED;
            Vector<ObjectName> list = filter.getEnabledObjectNames();
            if (list == null) {
                fieldName = OM_DISABLED;
                list = filter.getDisabledObjectNames();
            }
            this.writeFieldName(out, fieldName);
            this.writeStartArray(out);
            for (ObjectName objectName : list) {
                this.writeArrayItem(out);
                this.writeStringInternal(out, objectName.toString());
            }
            this.writeEndArray(out);
            this.writeFieldName(out, OM_TYPES);
            this.writeStartArray(out);
            for (String string : ((MBeanServerNotificationFilter)value).getEnabledTypes()) {
                this.writeArrayItem(out);
                this.writeStringInternal(out, string);
            }
            this.writeEndArray(out);
        } else if (clazz == NotificationFilterSupport.class) {
            this.writeFieldName(out, OM_TYPES);
            this.writeStartArray(out);
            for (String e : ((NotificationFilterSupport)value).getEnabledTypes()) {
                this.writeArrayItem(out);
                this.writeStringInternal(out, e);
            }
            this.writeEndArray(out);
        } else if (allowOther) {
            this.writeSerializedField(out, OM_SERIALIZED, value);
        } else assert (false);
        this.writeEndObject(out);
    }

    private void writeNotificationFilterField(OutputStream out, byte[] name, NotificationFilter value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeFieldName(out, name);
        this.writeNotificationFilterInternal(out, value, true);
    }

    private NotificationFilter[] readNotificationFiltersInternal(Object in) throws ConversionException, ClassNotFoundException {
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONArray)) {
            this.throwConversionException("readNotificationFiltersInternal() expects a JSONArray.", in);
        }
        JSONArray json = (JSONArray)in;
        NotificationFilter[] ret = new NotificationFilter[json.size()];
        int pos = 0;
        for (Object item : json) {
            ret[pos++] = this.readNotificationFilterInternal(item, false);
            if (ret[pos++] != null) continue;
            this.throwConversionException("readNotificationFilterInternal() received a null NotificationListener.", in);
        }
        return ret;
    }

    private NotificationFilter readNotificationFilterInternal(Object in, boolean allowOther) throws ConversionException, ClassNotFoundException {
        JSONObject json;
        String className;
        if (in == null) {
            return null;
        }
        if (!(in instanceof JSONObject)) {
            this.throwConversionException("readNotificationFilterInternal() expects a JSONObject.", in);
        }
        if ("javax.management.AttributeChangeNotificationFilter".equals(className = this.readStringInternal((json = (JSONObject)in).get(N_CLASSNAME)))) {
            String[] enabled;
            AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
            for (String item : enabled = this.readStringArrayInternal(json.get(N_ENABLED))) {
                filter.enableAttribute(item);
            }
            return filter;
        }
        if ("javax.management.relation.MBeanServerNotificationFilter".equals(className)) {
            String[] types;
            MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
            String[] enabled = this.readStringArrayInternal(json.get(N_ENABLED));
            if (enabled != null) {
                for (String item : enabled) {
                    filter.enableObjectName(this.readObjectName(item));
                }
            } else {
                String[] disabled;
                for (String item : disabled = this.readStringArrayInternal(json.get(N_DISABLED))) {
                    filter.disableObjectName(this.readObjectName(item));
                }
            }
            for (String item : types = this.readStringArrayInternal(json.get(N_TYPES))) {
                filter.enableType(item);
            }
            return filter;
        }
        if ("javax.management.NotificationFilterSupport".equals(className)) {
            String[] types;
            NotificationFilterSupport filter = new NotificationFilterSupport();
            for (String item : types = this.readStringArrayInternal(json.get(N_TYPES))) {
                filter.enableType(item);
            }
            return filter;
        }
        if (allowOther) {
            Object o = this.readSerialized(json.get(N_SERIALIZED));
            if (!(o instanceof NotificationFilter)) {
                this.throwConversionException("readNotificationFilterInternal() expects a NotificationFilter.", in);
            }
            return (NotificationFilter)o;
        }
        this.throwConversionException("readNotificationFilterInternal() received an unknown filter class.", (Object)className);
        return null;
    }

    private void utf8EncodeError(Object json) throws ConversionException {
        this.throwConversionException("encodeStringAsBase64Internal() can't encode the value in UTF-8.", json);
    }

    private void base64DecodeError(Object json) throws ConversionException {
        this.throwConversionException("readSerialized() received invalid base64 string.", json);
    }

    private String combineErrorMessage(String message, Object json) throws ConversionException {
        try {
            if (json instanceof JSONArtifact) {
                message = message + "\n\t" + ((JSONArtifact)json).serialize(true);
            } else if (json != null) {
                message = message + "\n\t" + json.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return message;
    }

    private void throwConversionException(String message, Object json) throws ConversionException {
        throw new ConversionException(this.combineErrorMessage(message, json));
    }

    private void throwConversionException(Throwable t, Object json) throws ConversionException {
        throw new ConversionException(this.combineErrorMessage(t.getMessage(), json), t);
    }

    static {
        int i;
        SupportedClasses = new HashMap();
        SupportedClasses.put(Byte.TYPE, TYPE._Byte);
        SupportedClasses.put(Short.TYPE, TYPE._Short);
        SupportedClasses.put(Integer.TYPE, TYPE._Integer);
        SupportedClasses.put(Long.TYPE, TYPE._Long);
        SupportedClasses.put(Float.TYPE, TYPE._Float);
        SupportedClasses.put(Double.TYPE, TYPE._Double);
        SupportedClasses.put(Character.TYPE, TYPE._Character);
        SupportedClasses.put(Boolean.TYPE, TYPE._Boolean);
        SupportedClasses.put(Byte.class, TYPE.Byte);
        SupportedClasses.put(Short.class, TYPE.Short);
        SupportedClasses.put(Integer.class, TYPE.Integer);
        SupportedClasses.put(Long.class, TYPE.Long);
        SupportedClasses.put(Float.class, TYPE.Float);
        SupportedClasses.put(Double.class, TYPE.Double);
        SupportedClasses.put(Character.class, TYPE.Character);
        SupportedClasses.put(Boolean.class, TYPE.Boolean);
        SupportedClasses.put(String.class, TYPE.String);
        SupportedClasses.put(BigInteger.class, TYPE.BigInteger);
        SupportedClasses.put(BigDecimal.class, TYPE.BigDecimal);
        SupportedClasses.put(Date.class, TYPE.Date);
        SupportedClasses.put(ObjectName.class, TYPE.ObjectName);
        SupportedClasses.put(Object.class, TYPE.Object);
        SupportedClasses.put(Collection.class, TYPE.Collection);
        SupportedClasses.put(Map.class, TYPE.Map);
        SupportedClasses.put(CompositeData.class, TYPE.CompositeData);
        SupportedClasses.put(TabularData.class, TYPE.TabularData);
        SupportedClasses.put(List.class, TYPE.Collection);
        SupportedClasses.put(Set.class, TYPE.Collection);
        SupportedClasses.put(ArrayList.class, TYPE.Collection);
        SupportedClasses.put(LinkedList.class, TYPE.Collection);
        SupportedClasses.put(Vector.class, TYPE.Collection);
        SupportedClasses.put(HashMap.class, TYPE.Map);
        SupportedClasses.put(Hashtable.class, TYPE.Map);
        SupportedClasses.put(TreeMap.class, TYPE.Map);
        SupportedClasses.put(HashSet.class, TYPE.Collection);
        SupportedClasses.put(CompositeDataSupport.class, TYPE.CompositeData);
        SupportedClasses.put(TabularDataSupport.class, TYPE.TabularData);
        SimpleKeys = new HashSet();
        SimpleKeys.add(Byte.class);
        SimpleKeys.add(Short.class);
        SimpleKeys.add(Integer.class);
        SimpleKeys.add(Long.class);
        SimpleKeys.add(Float.class);
        SimpleKeys.add(Double.class);
        SimpleKeys.add(Character.class);
        SimpleKeys.add(Boolean.class);
        SimpleKeys.add(String.class);
        SimpleKeys.add(BigInteger.class);
        SimpleKeys.add(BigDecimal.class);
        SimpleKeys.add(Date.class);
        SimpleKeys.add(ObjectName.class);
        SimpleArrays = new HashSet();
        SimpleArrays.add(Byte.TYPE);
        SimpleArrays.add(Short.TYPE);
        SimpleArrays.add(Integer.TYPE);
        SimpleArrays.add(Long.TYPE);
        SimpleArrays.add(Float.TYPE);
        SimpleArrays.add(Double.TYPE);
        SimpleArrays.add(Character.TYPE);
        SimpleArrays.add(Boolean.TYPE);
        SimpleArrays.add(Byte.class);
        SimpleArrays.add(Short.class);
        SimpleArrays.add(Integer.class);
        SimpleArrays.add(Long.class);
        SimpleArrays.add(Float.class);
        SimpleArrays.add(Double.class);
        SimpleArrays.add(Character.class);
        SimpleArrays.add(Boolean.class);
        SimpleArrays.add(String.class);
        SimpleValues = new HashMap<String, TYPE>();
        SimpleValues.put(Byte.class.getName(), TYPE.Byte);
        SimpleValues.put(Short.class.getName(), TYPE.Short);
        SimpleValues.put(Integer.class.getName(), TYPE.Integer);
        SimpleValues.put(Long.class.getName(), TYPE.Long);
        SimpleValues.put(Float.class.getName(), TYPE.Float);
        SimpleValues.put(Double.class.getName(), TYPE.Double);
        SimpleValues.put(Character.class.getName(), TYPE.Character);
        SimpleValues.put(Boolean.class.getName(), TYPE.Boolean);
        SimpleValues.put(String.class.getName(), TYPE.String);
        SimpleValues.put(BigInteger.class.getName(), TYPE.BigInteger);
        SimpleValues.put(BigDecimal.class.getName(), TYPE.BigDecimal);
        SimpleValues.put(Date.class.getName(), TYPE.Date);
        SimpleValues.put(Object.class.getName(), TYPE.Object);
        SimpleValues.put(ObjectName.class.getName(), TYPE.ObjectName);
        Name2SimpleTypes = new HashMap();
        Name2SimpleTypes.put(Byte.class.getName(), SimpleType.BYTE);
        Name2SimpleTypes.put(Short.class.getName(), SimpleType.SHORT);
        Name2SimpleTypes.put(Integer.class.getName(), SimpleType.INTEGER);
        Name2SimpleTypes.put(Long.class.getName(), SimpleType.LONG);
        Name2SimpleTypes.put(Float.class.getName(), SimpleType.FLOAT);
        Name2SimpleTypes.put(Double.class.getName(), SimpleType.DOUBLE);
        Name2SimpleTypes.put(Character.class.getName(), SimpleType.CHARACTER);
        Name2SimpleTypes.put(Boolean.class.getName(), SimpleType.BOOLEAN);
        Name2SimpleTypes.put(String.class.getName(), SimpleType.STRING);
        Name2SimpleTypes.put(BigInteger.class.getName(), SimpleType.BIGINTEGER);
        Name2SimpleTypes.put(BigDecimal.class.getName(), SimpleType.BIGDECIMAL);
        Name2SimpleTypes.put(Date.class.getName(), SimpleType.DATE);
        Name2SimpleTypes.put(ObjectName.class.getName(), SimpleType.OBJECTNAME);
        SimpleOpenTypes = new HashMap();
        SimpleOpenTypes.put(SimpleType.BYTE, TYPE.Byte);
        SimpleOpenTypes.put(SimpleType.SHORT, TYPE.Short);
        SimpleOpenTypes.put(SimpleType.INTEGER, TYPE.Integer);
        SimpleOpenTypes.put(SimpleType.LONG, TYPE.Long);
        SimpleOpenTypes.put(SimpleType.FLOAT, TYPE.Float);
        SimpleOpenTypes.put(SimpleType.DOUBLE, TYPE.Double);
        SimpleOpenTypes.put(SimpleType.CHARACTER, TYPE.Character);
        SimpleOpenTypes.put(SimpleType.BOOLEAN, TYPE.Boolean);
        SimpleOpenTypes.put(SimpleType.STRING, TYPE.String);
        SimpleOpenTypes.put(SimpleType.BIGINTEGER, TYPE.BigInteger);
        SimpleOpenTypes.put(SimpleType.BIGDECIMAL, TYPE.BigDecimal);
        SimpleOpenTypes.put(SimpleType.DATE, TYPE.Date);
        SimpleOpenTypes.put(SimpleType.OBJECTNAME, TYPE.ObjectName);
        StructuredClasses = new HashMap<String, TYPE>();
        StructuredClasses.put(ArrayList.class.getName(), TYPE.ArrayList);
        StructuredClasses.put(LinkedList.class.getName(), TYPE.LinkedList);
        StructuredClasses.put(Vector.class.getName(), TYPE.Vector);
        StructuredClasses.put(HashMap.class.getName(), TYPE.HashMap);
        StructuredClasses.put(Hashtable.class.getName(), TYPE.Hashtable);
        StructuredClasses.put(TreeMap.class.getName(), TYPE.TreeMap);
        StructuredClasses.put(HashSet.class.getName(), TYPE.HashSet);
        StructuredClasses.put(CompositeDataSupport.class.getName(), TYPE.CompositeDataSupport);
        StructuredClasses.put(TabularDataSupport.class.getName(), TYPE.TabularDataSupport);
        OM_ATTRIBUTENAME = new byte[]{34, 97, 116, 116, 114, 105, 98, 117, 116, 101, 78, 97, 109, 101, 34, 58};
        OM_ATTRIBUTES = new byte[]{34, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 34, 58};
        OM_ATTRIBUTES_URL = new byte[]{34, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 95, 85, 82, 76, 34, 58};
        OM_ATTRIBUTETYPE = new byte[]{34, 97, 116, 116, 114, 105, 98, 117, 116, 101, 84, 121, 112, 101, 34, 58};
        OM_CLASSNAME = new byte[]{34, 99, 108, 97, 115, 115, 78, 97, 109, 101, 34, 58};
        OM_CONNECTIONID = new byte[]{34, 99, 111, 110, 110, 101, 99, 116, 105, 111, 110, 73, 100, 34, 58};
        OM_CONSTRUCTORS = new byte[]{34, 99, 111, 110, 115, 116, 114, 117, 99, 116, 111, 114, 115, 34, 58};
        OM_CREATEMBEAN = new byte[]{34, 99, 114, 101, 97, 116, 101, 77, 66, 101, 97, 110, 34, 58};
        OM_DEFAULTDOMAIN = new byte[]{34, 100, 101, 102, 97, 117, 108, 116, 68, 111, 109, 97, 105, 110, 34, 58};
        OM_DELIVERYINTERVAL = new byte[]{34, 100, 101, 108, 105, 118, 101, 114, 121, 73, 110, 116, 101, 114, 118, 97, 108, 34, 58};
        OM_DESCRIPTION = new byte[]{34, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 34, 58};
        OM_DESCRIPTOR = new byte[]{34, 100, 101, 115, 99, 114, 105, 112, 116, 111, 114, 34, 58};
        OM_DIMENSION = new byte[]{34, 100, 105, 109, 101, 110, 115, 105, 111, 110, 34, 58};
        OM_DISABLED = new byte[]{34, 100, 105, 115, 97, 98, 108, 101, 100, 34, 58};
        OM_DOMAINS = new byte[]{34, 100, 111, 109, 97, 105, 110, 115, 34, 58};
        OM_ELEMENTTYPE = new byte[]{34, 101, 108, 101, 109, 101, 110, 116, 84, 121, 112, 101, 34, 58};
        OM_ENABLED = new byte[]{34, 101, 110, 97, 98, 108, 101, 100, 34, 58};
        OM_ENTRIES = new byte[]{34, 101, 110, 116, 114, 105, 101, 115, 34, 58};
        OM_FILTER = new byte[]{34, 102, 105, 108, 116, 101, 114, 34, 58};
        OM_FILTERID = new byte[]{34, 102, 105, 108, 116, 101, 114, 73, 68, 34, 58};
        OM_FILTERS = new byte[]{34, 102, 105, 108, 116, 101, 114, 115, 34, 58};
        OM_HANDBACK = new byte[]{34, 104, 97, 110, 100, 98, 97, 99, 107, 34, 58};
        OM_HANDBACKID = new byte[]{34, 104, 97, 110, 100, 98, 97, 99, 107, 73, 68, 34, 58};
        OM_IMPACT = new byte[]{34, 105, 109, 112, 97, 99, 116, 34, 58};
        OM_INBOX = new byte[]{34, 105, 110, 98, 111, 120, 34, 58};
        OM_INBOXEXPIRTY = new byte[]{34, 105, 110, 98, 111, 120, 69, 120, 112, 105, 114, 121, 34, 58};
        OM_INDEXNAMES = new byte[]{34, 105, 110, 100, 101, 120, 78, 97, 109, 101, 115, 34, 58};
        OM_INSTANCEOF = new byte[]{34, 105, 110, 115, 116, 97, 110, 99, 101, 79, 102, 34, 58};
        OM_ISIS = new byte[]{34, 105, 115, 73, 115, 34, 58};
        OM_ISREADABLE = new byte[]{34, 105, 115, 82, 101, 97, 100, 97, 98, 108, 101, 34, 58};
        OM_ISWRITABLE = new byte[]{34, 105, 115, 87, 114, 105, 116, 97, 98, 108, 101, 34, 58};
        OM_ITEMS = new byte[]{34, 105, 116, 101, 109, 115, 34, 58};
        OM_LISTENER = new byte[]{34, 108, 105, 115, 116, 101, 110, 101, 114, 34, 58};
        OM_LOADERNAME = new byte[]{34, 108, 111, 97, 100, 101, 114, 78, 97, 109, 101, 34, 58};
        OM_KEY = new byte[]{34, 107, 101, 121, 34, 58};
        OM_KEYTYPE = new byte[]{34, 107, 101, 121, 84, 121, 112, 101, 34, 58};
        OM_MBEANCOUNT = new byte[]{34, 109, 98, 101, 97, 110, 67, 111, 117, 110, 116, 34, 58};
        OM_MBEANNAME = new byte[]{34, 109, 98, 101, 97, 110, 78, 97, 109, 101, 34, 58};
        OM_MBEANS = new byte[]{34, 109, 98, 101, 97, 110, 115, 34, 58};
        OM_MBEANSTOUNREGISTER = new byte[]{34, 109, 98, 101, 97, 110, 115, 84, 111, 85, 110, 114, 101, 103, 105, 115, 116, 101, 114, 34, 58};
        OM_MESSAGE = new byte[]{34, 109, 101, 115, 115, 97, 103, 101, 34, 58};
        OM_NAME = new byte[]{34, 110, 97, 109, 101, 34, 58};
        OM_NAMES = new byte[]{34, 110, 97, 109, 101, 115, 34, 58};
        OM_NEWROLEVALUE = new byte[]{34, 110, 101, 119, 82, 111, 108, 101, 86, 97, 108, 117, 101, 34, 58};
        OM_NEWVALUE = new byte[]{34, 110, 101, 119, 86, 97, 108, 117, 101, 34, 58};
        OM_NOTIFICATIONID = new byte[]{34, 110, 111, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 73, 68, 34, 58};
        OM_NOTIFICATIONS = new byte[]{34, 110, 111, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 115, 34, 58};
        OM_NOTIFTYPES = new byte[]{34, 110, 111, 116, 105, 102, 84, 121, 112, 101, 115, 34, 58};
        OM_OBJECTNAME = new byte[]{34, 111, 98, 106, 101, 99, 116, 78, 97, 109, 101, 34, 58};
        OM_OLDROLEVALUE = new byte[]{34, 111, 108, 100, 82, 111, 108, 101, 86, 97, 108, 117, 101, 34, 58};
        OM_OLDVALUE = new byte[]{34, 111, 108, 100, 86, 97, 108, 117, 101, 34, 58};
        OM_OPENTYPE = new byte[]{34, 111, 112, 101, 110, 84, 121, 112, 101, 34, 58};
        OM_OPENTYPECLASS = new byte[]{34, 111, 112, 101, 110, 84, 121, 112, 101, 67, 108, 97, 115, 115, 34, 58};
        OM_OPENTYPES = new byte[]{34, 111, 112, 101, 110, 84, 121, 112, 101, 115, 34, 58};
        OM_OPERATION = new byte[]{34, 111, 112, 101, 114, 97, 116, 105, 111, 110, 34, 58};
        OM_OPERATIONS = new byte[]{34, 111, 112, 101, 114, 97, 116, 105, 111, 110, 115, 34, 58};
        OM_PARAMS = new byte[]{34, 112, 97, 114, 97, 109, 115, 34, 58};
        OM_QUERYEXP = new byte[]{34, 113, 117, 101, 114, 121, 69, 120, 112, 34, 58};
        OM_REGISTRATIONS = new byte[]{34, 114, 101, 103, 105, 115, 116, 114, 97, 116, 105, 111, 110, 115, 34, 58};
        OM_RELATIONID = new byte[]{34, 114, 101, 108, 97, 116, 105, 111, 110, 73, 100, 34, 58};
        OM_RELATIONTYPENAME = new byte[]{34, 114, 101, 108, 97, 116, 105, 111, 110, 84, 121, 112, 101, 78, 97, 109, 101, 34, 58};
        OM_RETURNTYPE = new byte[]{34, 114, 101, 116, 117, 114, 110, 84, 121, 112, 101, 34, 58};
        OM_ROLENAME = new byte[]{34, 114, 111, 108, 101, 78, 97, 109, 101, 34, 58};
        OM_ROWTYPE = new byte[]{34, 114, 111, 119, 84, 121, 112, 101, 34, 58};
        OM_SEQUENCENUMBER = new byte[]{34, 115, 101, 113, 117, 101, 110, 99, 101, 78, 117, 109, 98, 101, 114, 34, 58};
        OM_SERIALIZED = new byte[]{34, 115, 101, 114, 105, 97, 108, 105, 122, 101, 100, 34, 58};
        OM_SERVERREGISTRATIONS = new byte[]{34, 115, 101, 114, 118, 101, 114, 82, 101, 103, 105, 115, 116, 114, 97, 116, 105, 111, 110, 115, 34, 58};
        OM_SIGNATURE = new byte[]{34, 115, 105, 103, 110, 97, 116, 117, 114, 101, 34, 58};
        OM_SIMPLEKEY = new byte[]{34, 115, 105, 109, 112, 108, 101, 75, 101, 121, 34, 58};
        OM_SOURCE = new byte[]{34, 115, 111, 117, 114, 99, 101, 34, 58};
        OM_STACKTRACE = new byte[]{34, 115, 116, 97, 99, 107, 84, 114, 97, 99, 101, 34, 58};
        OM_THROWABLE = new byte[]{34, 116, 104, 114, 111, 119, 97, 98, 108, 101, 34, 58};
        OM_TIMESTAMP = new byte[]{34, 116, 105, 109, 101, 83, 116, 97, 109, 112, 34, 58};
        OM_TYPE = new byte[]{34, 116, 121, 112, 101, 34, 58};
        OM_TYPENAME = new byte[]{34, 116, 121, 112, 101, 78, 97, 109, 101, 34, 58};
        OM_TYPES = new byte[]{34, 116, 121, 112, 101, 115, 34, 58};
        OM_URL = new byte[]{34, 85, 82, 76, 34, 58};
        OM_USELOADER = new byte[]{34, 117, 115, 101, 76, 111, 97, 100, 101, 114, 34, 58};
        OM_USERDATA = new byte[]{34, 117, 115, 101, 114, 68, 97, 116, 97, 34, 58};
        OM_USESIGNATURE = new byte[]{34, 117, 115, 101, 83, 105, 103, 110, 97, 116, 117, 114, 101, 34, 58};
        OM_VALUE = new byte[]{34, 118, 97, 108, 117, 101, 34, 58};
        OM_VALUES = new byte[]{34, 118, 97, 108, 117, 101, 115, 34, 58};
        OM_VERSION = new byte[]{34, 118, 101, 114, 115, 105, 111, 110, 34, 58};
        LONG_MIN = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
        INT_MIN = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};
        TRUE = new byte[]{116, 114, 117, 101};
        FALSE = new byte[]{102, 97, 108, 115, 101};
        NULL = new byte[]{110, 117, 108, 108};
        OBJECT = new Object();
        BASE64 = new byte[64];
        BASE64_D = new byte[128];
        for (i = 0; i < 128; ++i) {
            JSONConverter.BASE64_D[i] = -1;
        }
        for (i = 0; i < 26; i = (int)((byte)(i + 1))) {
            JSONConverter.BASE64[i] = (byte)(i + 65);
            JSONConverter.BASE64_D[i + 65] = i;
        }
        for (i = 0; i < 26; ++i) {
            JSONConverter.BASE64[i + 26] = (byte)(i + 97);
            JSONConverter.BASE64_D[i + 97] = (byte)(i + 26);
        }
        for (i = 0; i < 10; ++i) {
            JSONConverter.BASE64[i + 52] = (byte)(i + 48);
            JSONConverter.BASE64_D[i + 48] = (byte)(i + 52);
        }
        JSONConverter.BASE64[62] = 43;
        JSONConverter.BASE64[63] = 47;
        JSONConverter.BASE64_D[43] = 62;
        JSONConverter.BASE64_D[47] = 63;
        JSONConverter.BASE64_D[61] = 0;
        POOL = new Stack();
    }

    private class Base64OutputStream
    extends OutputStream {
        private OutputStream out;
        private int count;

        private Base64OutputStream() {
        }

        private void start(OutputStream out) {
            this.out = out;
            this.count = 0;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.count == JSONConverter.this.BYTE_BUFFER.length) {
                this.encodeBase64();
                this.count = 0;
            }
            ((JSONConverter)JSONConverter.this).BYTE_BUFFER[this.count++] = (byte)b;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int left = JSONConverter.this.BYTE_BUFFER.length - this.count;
            while (len > left) {
                System.arraycopy(b, off, JSONConverter.this.BYTE_BUFFER, this.count, left);
                this.count = JSONConverter.this.BYTE_BUFFER.length;
                this.encodeBase64();
                len -= left;
                off += left;
                left = JSONConverter.this.BYTE_BUFFER.length;
            }
            System.arraycopy(b, off, JSONConverter.this.BYTE_BUFFER, this.count, len);
            this.count += len;
        }

        @Override
        public void flush() throws IOException {
            if (this.count > 0) {
                this.encodeBase64();
            }
        }

        private void end() throws IOException {
            this.flush();
            this.out = null;
        }

        private void encodeBase64() throws IOException {
            byte b2;
            byte b1;
            int left = this.count % 3;
            int pos = 0;
            while (pos < this.count - left) {
                b1 = JSONConverter.this.BYTE_BUFFER[pos++];
                b2 = JSONConverter.this.BYTE_BUFFER[pos++];
                byte b3 = JSONConverter.this.BYTE_BUFFER[pos++];
                this.out.write(BASE64[b1 >> 2 & 0x3F]);
                this.out.write(BASE64[(b1 & 3) << 4 | b2 >> 4 & 0xF]);
                this.out.write(BASE64[(b2 & 0xF) << 2 | b3 >> 6 & 3]);
                this.out.write(BASE64[b3 & 0x3F]);
            }
            if (left == 1) {
                b1 = JSONConverter.this.BYTE_BUFFER[pos];
                this.out.write(BASE64[b1 >> 2 & 0x3F]);
                this.out.write(BASE64[(b1 & 3) << 4]);
                this.out.write(61);
                this.out.write(61);
            } else if (left == 2) {
                b1 = JSONConverter.this.BYTE_BUFFER[pos++];
                b2 = JSONConverter.this.BYTE_BUFFER[pos++];
                this.out.write(BASE64[b1 >> 2 & 0x3F]);
                this.out.write(BASE64[(b1 & 3) << 4 | b2 >> 4 & 0xF]);
                this.out.write(BASE64[(b2 & 0xF) << 2]);
                this.out.write(61);
            }
            this.count = 0;
        }
    }

    private static enum TYPE {
        _Byte,
        _Short,
        _Integer,
        _Long,
        _Float,
        _Double,
        _Character,
        _Boolean,
        Byte,
        Short,
        Integer,
        Long,
        Float,
        Double,
        Character,
        Boolean,
        String,
        BigInteger,
        BigDecimal,
        Date,
        ObjectName,
        Object,
        Collection,
        Map,
        CompositeData,
        TabularData,
        List,
        Set,
        ArrayList,
        LinkedList,
        Vector,
        HashMap,
        Hashtable,
        TreeMap,
        HashSet,
        CompositeDataSupport,
        TabularDataSupport;

    }
}

