package com.urbancode.air.plugin.websphereliberty;
import com.urbancode.air.CommandHelper;

public class WebSphereLibertyHelper extends AbstractWebSphereLibertyFileSystemHelper {
   def ch

   public WebSphereLibertyHelper(String wlpHome) {
       super(wlpHome);
       ch = new CommandHelper(new File("."));
   }

   public void deployViaDropins(String serverName, String source) {
       def serverDir = getServerDirectory(serverName);
       def toDir = new File(serverDir, "dropins"); 
       def ant = new AntBuilder();
       ant.copy(verbose:"true", todir:toDir, overwrite:"true", file: source, failonerror:"true");
   }

   public void uninstallViaDropins(String serverName, String sourceName) {
       System.out.println("Deleting application ${sourceName}");

       def serverDir = getServerDirectory(serverName);
       def dropinsDir = new File(serverDir, "dropins");
       def ant = new AntBuilder();
       ant.delete(verbose:"true", failonerror:"true", includeemptydirs:'true') {
           fileset(dir:dropinsDir.absolutePath, defaultexcludes:'false', followsymlinks: 'true') {
               include(name:"${sourceName}");
           }
       }
   }

   public void createServer(String serverName, def isWindows) {
       runServerCommand(serverName, isWindows, "create", "Creating new server named " + serverName);
   }

   public void startServer(String serverName, def isWindows) {
       runServerCommand(serverName, isWindows, "start", "Starting server named " + serverName);
   }

   public void stopServer(String serverName, def isWindows) {
       runServerCommand(serverName, isWindows, "stop", "Stopping server named " + serverName);
   }

   public void deleteServer(String serverName) {
       System.out.println("Deleting server ${serverName}");
       def serverDir = getServerDirectory(serverName);
       def ant = new AntBuilder();
       ant.delete(verbose:"true", failonerror:"true", includeemptydirs:'true') {
           fileset(dir:serverDir.parentFile.absolutePath, defaultexcludes:'false', followsymlinks: 'true') {
               include(name:"${serverName}/**/*");
               include(name:"${serverName}");
           }
       }
   }

   public void installServerArchive(String source) {
       System.out.println("Unzipping server archive in : " + wlpHomeFile.absolutePath);
       def ant = new AntBuilder();
       ant.unzip(src:source, dest:wlpHomeFile.absolutePath);
   }
}

