package com.urbancode.air.plugin.websphereliberty;

public abstract class AbstractWebSphereLibertyFileSystemHelper {
   def wlpHomeFile

   protected AbstractWebSphereLibertyFileSystemHelper(String wlpHome) {
       wlpHomeFile = new File(wlpHome);
       if (!wlpHomeFile.isDirectory()) {
           System.out.println("WebSphere Liberty Home Directory does not exist or is not a file! " + wlpHome);
           System.exit(1);
       }
   }

   protected File getServerExecutable(def isWindows) {
       def binDir = new File(wlpHomeFile, "bin");
       def serverExecutableName = "server" + (isWindows ? ".bat":"");
       def serverExecutable = new File(binDir, serverExecutableName);
       return serverExecutable
   }

   protected File getServerDirectory(String serverName) {
       def usrDir = new File(wlpHomeFile, "usr");
       def serversDir = new File(usrDir, "servers");
       def serverDir = new File(serversDir, serverName);
       if (!wlpHomeFile.isDirectory()) {
           System.out.println("Expected Server Directory does not exist or is not a file! " + serverDir.absolutePath);
           System.exit(1);
       }
       return serverDir;
   }

   protected void runServerCommand(String serverName, def isWindows, String command, String message) {
       runServerCommand(serverName, isWindows, command, message, null);
   }

   protected void runServerCommand(String serverName, def isWindows, String command, String message, Closure clos) {
       def serverExecutable = getServerExecutable(isWindows);
       def cmdArgs = [serverExecutable.absolutePath, command, serverName];

       if (isWindows) {
           ch.addEnvironmentVariable("EXIT_ALL", "1");
       }

       ch.runCommand(message, cmdArgs, clos);
   }
}
