package com.urbancode.air.plugin.websphereliberty;
import com.urbancode.air.CommandHelper;
import groovy.xml.StreamingMarkupBuilder;
import groovy.util.slurpersupport.NoChildren;
import groovy.xml.XmlUtil;
import com.urbancode.commons.util.IO;

public class WebSphereLibertyServerXmlHelper extends AbstractWebSphereLibertyFileSystemHelper {
   def ch
   def serverDirFile
   def serverXmlFile

   public WebSphereLibertyServerXmlHelper(String wlpHome, String serverName) { 
       super(wlpHome);
       ch = new CommandHelper(new File("."));
       serverDirFile = getServerDirectory(serverName);
       serverXmlFile = new File(serverDirFile, "server.xml");
       if (!serverXmlFile.isFile()) {
           throw new IllegalArgumentException("server.xml file not located at location : " + serverXmlFile.absolutePath);
       }
   }

   public void installOrUpdateApplicationIntoXml(String loc, String name, String type, String context, boolean autoStart) {
      def serverXml = new XmlSlurper().parse(serverXmlFile);
      def curApp = serverXml.application.find { it.@name.text() == name };
      if (curApp != null && !(curApp instanceof NoChildren)) {
          System.out.println("Found currently installed App with name ${name}! Updating ...");
          def args = [:];
          args.location = loc;
          args.name = name;
          args.type = type;
          if (context) {
              args."context-root" = context;
          }
          args.autoStart = String.valueOf(autoStart);
          curApp.replaceNode { node ->
              application(args);
          }
      }
      else {
          System.out.println("Application not found in server.xml! Installing...");
          def args = [:];
          args.location = loc;
          args.name = name;
          args.type = type;
          if (context) {
              args."context-root" = context;
          }
          args.autoStart = String.valueOf(autoStart);
          serverXml.appendNode() {
              application(args);
          }
      }
      writeXml(serverXml);
   }

   public void uninstallApplicationFromXml(String name) {
      def serverXml = new XmlSlurper().parse(serverXmlFile);
      def curApp = serverXml.application.find { it.@name.text() == name };
      if (curApp != null && !(curApp instanceof NoChildren)) {
          System.out.println("Found currently installed application with name ${name}! Removing...");
          curApp.replaceNode() {};
          writeXml(serverXml);
      }
      else {
          System.out.println("Application named ${name} not found in server.xml!");
      }
   }

   private void writeXml(def serverXml) {
       System.out.println("Server.xml has changed! Writing out...");
       File newServerFile = File.createTempFile("server", ".xml");
       newServerFile.deleteOnExit();
       String result = XmlUtil.serialize(new StreamingMarkupBuilder().bind { mkp.yield serverXml });
       println result; 
       newServerFile << result; 
       IO.move(newServerFile, serverXmlFile);
       System.out.println("Server.xml updated!");
   }
   
}
   
