/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.client.rest.internal;

import com.ibm.ws.jmx.connector.client.rest.internal.ClientConstants;
import com.ibm.ws.jmx.connector.client.rest.internal.Connector;
import com.ibm.ws.jmx.connector.client.rest.internal.DelayedURL;
import com.ibm.ws.jmx.connector.client.rest.internal.NotificationRegistry;
import com.ibm.ws.jmx.connector.client.rest.internal.resources.RESTClientMessagesUtil;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.CreateMBean;
import com.ibm.ws.jmx.connector.datatypes.Invocation;
import com.ibm.ws.jmx.connector.datatypes.JMXServerInfo;
import com.ibm.ws.jmx.connector.datatypes.MBeanInfoWrapper;
import com.ibm.ws.jmx.connector.datatypes.MBeanQuery;
import com.ibm.ws.jmx.connector.datatypes.ObjectInstanceWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

class RESTMBeanServerConnection
implements MBeanServerConnection {
    private static final Logger logger = Logger.getLogger(RESTMBeanServerConnection.class.getName());
    private final Connector connector;
    private boolean disconnected = false;
    private final DelayedURL rootURL;
    private DelayedURL mbeansURL;
    private DelayedURL createMBeanURL;
    private DelayedURL instanceOfURL;
    private DelayedURL mbeanCountURL;
    private DelayedURL defaultDomainURL;
    private DelayedURL domainsURL;
    private DelayedURL notificationsURL;
    private final Map<ObjectName, DelayedURL> mbeanInfoURLMap;
    private final Map<ObjectName, DelayedURL> mbeanAttributesURLMap;
    private final Map<ObjectName, Map<String, DelayedURL>> mbeanAttributeURLsMap;
    private final Map<ObjectName, Map<String, DelayedURL>> mbeanOperationURLsMap;
    final JSONConverter converter = JSONConverter.getConverter();
    private final NotificationRegistry notificationRegistry;
    private final HostnameVerifier hostnameVerificationDisabler;

    RESTMBeanServerConnection(Connector connector) throws IOException {
        this.connector = connector;
        JMXServiceURL url = connector.getServiceURL();
        int port = url.getPort();
        this.rootURL = new DelayedURL(null, "https://" + url.getHost() + (port > 0 ? ":" + port : "") + url.getURLPath());
        this.hostnameVerificationDisabler = connector.isHostnameVerificationDisabled() ? new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        } : null;
        this.loadJMXServerInfo();
        this.mbeanInfoURLMap = new HashMap<ObjectName, DelayedURL>();
        this.mbeanAttributesURLMap = new HashMap<ObjectName, DelayedURL>();
        this.mbeanAttributeURLsMap = new HashMap<ObjectName, Map<String, DelayedURL>>();
        this.mbeanOperationURLsMap = new HashMap<ObjectName, Map<String, DelayedURL>>();
        this.notificationRegistry = new NotificationRegistry(this);
    }

    private void loadJMXServerInfo() throws IOException {
        String sourceMethod = "loadJMXServerInfo";
        this.checkConnection();
        URL rootURL = null;
        HttpsURLConnection connection = null;
        try {
            rootURL = this.getRootURL();
            connection = this.getConnection(rootURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("loadJMXServerInfo", io, rootURL);
        }
        JMXServerInfo jmx = null;
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    jmx = this.converter.readJMX(connection.getInputStream());
                    break;
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("loadJMXServerInfo", e, rootURL);
                }
            }
            case 400: 
            case 500: {
                Throwable t = this.getServerThrowable("loadJMXServerInfo", connection);
                IOException ioe = t instanceof IOException ? (IOException)t : new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                throw ioe;
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
            default: {
                throw this.getResponseCodeErrorException("loadJMXServerInfo", responseCode, connection);
            }
        }
        this.mbeansURL = new DelayedURL(rootURL, jmx.mbeansURL);
        this.createMBeanURL = new DelayedURL(rootURL, jmx.createMBeanURL);
        this.instanceOfURL = new DelayedURL(rootURL, jmx.instanceOfURL);
        this.mbeanCountURL = new DelayedURL(rootURL, jmx.mbeanCountURL);
        this.defaultDomainURL = new DelayedURL(rootURL, jmx.defaultDomainURL);
        this.domainsURL = new DelayedURL(rootURL, jmx.domainsURL);
        this.notificationsURL = new DelayedURL(rootURL, jmx.notificationsURL);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            return this.createMBean(className, name, null, null, null, false, false);
        }
        catch (InstanceNotFoundException inf) {
            throw new IOException(inf);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return this.createMBean(className, name, loaderName, null, null, true, false);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            return this.createMBean(className, name, null, params, signature, false, true);
        }
        catch (InstanceNotFoundException inf) {
            throw new IOException(inf);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return this.createMBean(className, name, loaderName, params, signature, true, true);
    }

    private ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature, boolean useLoader, boolean useSignature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        String sourceMethod = "createMBean";
        this.checkConnection();
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.class.name.null", new Object[0])));
        }
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name)));
        }
        URL createURL = null;
        HttpsURLConnection connection = null;
        try {
            createURL = this.getCreateMBeanURL();
            connection = this.getConnection(createURL, ClientConstants.HttpMethod.POST);
            CreateMBean createMBean = new CreateMBean();
            createMBean.className = className;
            createMBean.objectName = name;
            createMBean.loaderName = loaderName;
            createMBean.params = params;
            createMBean.signature = signature;
            createMBean.useLoader = useLoader;
            createMBean.useSignature = useSignature;
            OutputStream output = connection.getOutputStream();
            this.converter.writeCreateMBean(output, createMBean);
            output.flush();
            output.close();
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (IOException io) {
            throw this.getRequestErrorException("createMBean", io, createURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    ObjectInstanceWrapper wrapper = this.converter.readObjectInstance(connection.getInputStream());
                    this.mbeanInfoURLMap.put(wrapper.objectInstance.getObjectName(), new DelayedURL(createURL, wrapper.mbeanInfoURL));
                    return wrapper.objectInstance;
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("createMBean", e, createURL);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("createMBean", connection);
                }
                catch (RuntimeOperationsException roe) {
                    throw roe;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (InstanceAlreadyExistsException iae) {
                    throw iae;
                }
                catch (MBeanRegistrationException mbr) {
                    throw mbr;
                }
                catch (MBeanException me) {
                    throw me;
                }
                catch (RuntimeMBeanException rme) {
                    throw rme;
                }
                catch (NotCompliantMBeanException ncm) {
                    throw ncm;
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("createMBean", responseCode, connection);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        String sourceMethod = "unregisterMBean";
        this.checkConnection();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        URL mbeanURL = null;
        HttpsURLConnection connection = null;
        try {
            mbeanURL = this.getMBeanURL(name);
            connection = this.getConnection(mbeanURL, ClientConstants.HttpMethod.DELETE);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("unregisterMBean", io, mbeanURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 204: {
                this.purgeMBeanURLs(name);
                return;
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("unregisterMBean", connection);
                }
                catch (MBeanRegistrationException mbr) {
                    throw mbr;
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("unregisterMBean", responseCode, connection);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        this.checkConnection();
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        Set results = this.queryMBeans(name, null, null, true);
        if (results.size() == 1) {
            return results.toArray(new ObjectInstance[1])[0];
        }
        throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.instance.not.found", name));
    }

    private Set queryMBeans(ObjectName name, QueryExp query, String className, boolean objectInstance) throws IOException {
        String sourceMethod = "queryMBeans";
        boolean usePOST = query != null;
        URL baseMBeansURL = null;
        URL mbeansURL = null;
        HttpsURLConnection connection = null;
        try {
            baseMBeansURL = this.getMBeansURL();
            mbeansURL = usePOST ? baseMBeansURL : this.getMBeansURL(name, className);
            connection = this.getConnection(mbeansURL, usePOST ? ClientConstants.HttpMethod.POST : ClientConstants.HttpMethod.GET);
            if (usePOST) {
                MBeanQuery mbeanQuery = new MBeanQuery();
                mbeanQuery.objectName = name;
                mbeanQuery.queryExp = query;
                mbeanQuery.className = className;
                OutputStream output = connection.getOutputStream();
                this.converter.writeMBeanQuery(output, mbeanQuery);
                output.flush();
                output.close();
            }
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (IOException io) {
            throw this.getRequestErrorException("queryMBeans", io, mbeansURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    ObjectInstanceWrapper[] wrappers = this.converter.readObjectInstances(connection.getInputStream());
                    HashSet<Serializable> mbeans = new HashSet<Serializable>(wrappers.length);
                    HashMap<ObjectName, String> tempMBeanInfoURLMap = new HashMap<ObjectName, String>(wrappers.length);
                    for (ObjectInstanceWrapper wrapper : wrappers) {
                        tempMBeanInfoURLMap.put(wrapper.objectInstance.getObjectName(), wrapper.mbeanInfoURL);
                        if (objectInstance) {
                            mbeans.add(wrapper.objectInstance);
                            continue;
                        }
                        mbeans.add(wrapper.objectInstance.getObjectName());
                    }
                    this.processMBeanInfoURLs(tempMBeanInfoURLMap, baseMBeansURL, name == null && query == null && className == null);
                    return mbeans;
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("queryMBeans", e, mbeansURL);
                }
            }
            case 400: 
            case 500: {
                Throwable t = this.getServerThrowable("queryMBeans", connection);
                IOException ioe = t instanceof IOException ? (IOException)t : new IOException("jmx.rest.client.unexpected.server.throwable", t);
                throw ioe;
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("queryMBeans", responseCode, connection);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
        this.checkConnection();
        return this.queryMBeans(name, query, null, true);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
        this.checkConnection();
        return this.queryMBeans(name, query, null, false);
    }

    @Override
    public boolean isRegistered(ObjectName name) throws IOException {
        this.checkConnection();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            return false;
        }
        Set results = this.queryMBeans(name, null, null, true);
        return results.size() == 1;
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        String sourceMethod = "getMBeanCount";
        this.checkConnection();
        URL mbeanCountURL = null;
        HttpsURLConnection connection = null;
        try {
            mbeanCountURL = this.getMBeanCountURL();
            connection = this.getConnection(mbeanCountURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getMBeanCount", io, mbeanCountURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    return this.converter.readInt(connection.getInputStream());
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("getMBeanCount", e, mbeanCountURL);
                }
            }
            case 400: 
            case 500: {
                Throwable t = this.getServerThrowable("getMBeanCount", connection);
                IOException ioe = t instanceof IOException ? (IOException)t : new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                throw ioe;
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("getMBeanCount", responseCode, connection);
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        String sourceMethod = "getAttribute";
        this.checkConnection();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.attribute.name.null", new Object[0])));
        }
        URL attributeURL = null;
        HttpsURLConnection connection = null;
        try {
            attributeURL = this.getAttributeURL(name, attribute);
            connection = this.getConnection(attributeURL, ClientConstants.HttpMethod.GET);
        }
        catch (IntrospectionException intro) {
            throw this.getRequestErrorException("getAttribute", intro, attributeURL);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getAttribute", io, attributeURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    return this.converter.readPOJO(connection.getInputStream());
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.result.exception", new Object[0]), cnf);
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("getAttribute", e, attributeURL);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("getAttribute", connection);
                }
                catch (MBeanException me) {
                    throw me;
                }
                catch (AttributeNotFoundException anf) {
                    throw anf;
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("getAttribute", responseCode, connection);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        String sourceMethod = "getAttributes";
        this.checkConnection();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.attribute.names.null", new Object[0])));
        }
        URL attributesURL = null;
        HttpsURLConnection connection = null;
        try {
            attributesURL = this.getAttributesURL(name, attributes);
            connection = this.getConnection(attributesURL, ClientConstants.HttpMethod.GET);
        }
        catch (IntrospectionException intro) {
            throw this.getRequestErrorException("getAttributes", intro, attributesURL);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getAttributes", io, attributesURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    return this.converter.readAttributeList(connection.getInputStream());
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.result.exception", new Object[0]), cnf);
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("getAttributes", e, attributesURL);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("getAttributes", connection);
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("getAttributes", responseCode, connection);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        String sourceMethod = "setAttribute";
        this.checkConnection();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.attribute.null", new Object[0])));
        }
        URL attributeURL = null;
        HttpsURLConnection connection = null;
        try {
            attributeURL = this.getAttributeURL(name, attribute.getName());
            connection = this.getConnection(attributeURL, ClientConstants.HttpMethod.PUT);
            OutputStream output = connection.getOutputStream();
            this.converter.writePOJO(output, attribute.getValue());
            output.flush();
            output.close();
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (IntrospectionException intro) {
            this.getRequestErrorException("setAttribute", intro, attributeURL);
            throw new IOException(intro);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("setAttribute", io, attributeURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 204: {
                return;
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("setAttribute", connection);
                }
                catch (MBeanException me) {
                    throw me;
                }
                catch (RuntimeMBeanException rme) {
                    throw rme;
                }
                catch (AttributeNotFoundException anf) {
                    throw anf;
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (InvalidAttributeValueException iav) {
                    throw iav;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("setAttribute", responseCode, connection);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        String sourceMethod = "setAttributes";
        this.checkConnection();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.null", new Object[0])));
        }
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.attribute.list.null", new Object[0])));
        }
        URL attributesURL = null;
        HttpsURLConnection connection = null;
        try {
            attributesURL = this.getAttributesURL(name);
            connection = this.getConnection(attributesURL, ClientConstants.HttpMethod.POST);
            OutputStream output = connection.getOutputStream();
            this.converter.writeAttributeList(output, attributes);
            output.flush();
            output.close();
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (IntrospectionException intro) {
            throw this.getRequestErrorException("setAttributes", intro, attributesURL);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("setAttributes", io, attributesURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    return this.converter.readAttributeList(connection.getInputStream());
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.result.exception", new Object[0]), cnf);
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("setAttributes", e, attributesURL);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("setAttributes", connection);
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("setAttributes", responseCode, connection);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        String sourceMethod = "invoke";
        this.checkConnection();
        URL invokeURL = null;
        HttpsURLConnection connection = null;
        try {
            invokeURL = this.getOperationURL(name, operationName);
            connection = this.getConnection(invokeURL, ClientConstants.HttpMethod.POST);
            Invocation invocation = new Invocation();
            invocation.params = params;
            invocation.signature = signature;
            OutputStream output = connection.getOutputStream();
            this.converter.writeInvocation(output, invocation);
            output.flush();
            output.close();
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (IntrospectionException intro) {
            throw this.getRequestErrorException("invoke", intro, invokeURL);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("invoke", io, invokeURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    return this.converter.readPOJO(connection.getInputStream());
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.result.exception", new Object[0]), cnf);
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("invoke", e, invokeURL);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("invoke", connection);
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (RuntimeMBeanException rme) {
                    throw rme;
                }
                catch (MBeanException me) {
                    throw me;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("invoke", responseCode, connection);
    }

    @Override
    public String getDefaultDomain() throws IOException {
        String sourceMethod = "getDefaultDomain";
        this.checkConnection();
        URL defaultDomainURL = null;
        HttpsURLConnection connection = null;
        try {
            defaultDomainURL = this.getDefaultDomainURL();
            connection = this.getConnection(defaultDomainURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getDefaultDomain", io, defaultDomainURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    return this.converter.readString(connection.getInputStream());
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("getDefaultDomain", e, defaultDomainURL);
                }
            }
            case 400: 
            case 500: {
                Throwable t = this.getServerThrowable("getDefaultDomain", connection);
                IOException ioe = t instanceof IOException ? (IOException)t : new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                throw ioe;
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("getDefaultDomain", responseCode, connection);
    }

    @Override
    public String[] getDomains() throws IOException {
        String sourceMethod = "getDomains";
        this.checkConnection();
        URL domainsURL = null;
        HttpsURLConnection connection = null;
        try {
            domainsURL = this.getDomainsURL();
            connection = this.getConnection(domainsURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getDomains", io, domainsURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    return this.converter.readStringArray(connection.getInputStream());
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("getDomains", e, domainsURL);
                }
            }
            case 400: 
            case 500: {
                Throwable t = this.getServerThrowable("getDomains", connection);
                IOException ioe = t instanceof IOException ? (IOException)t : new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                throw ioe;
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("getDomains", responseCode, connection);
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.checkConnection();
        this.notificationRegistry.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.checkConnection();
        this.notificationRegistry.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.checkConnection();
        this.notificationRegistry.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.checkConnection();
        this.notificationRegistry.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.checkConnection();
        this.notificationRegistry.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.checkConnection();
        this.notificationRegistry.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        String sourceMethod = "getMBeanInfo";
        this.checkConnection();
        URL mbeanURL = null;
        HttpsURLConnection connection = null;
        try {
            mbeanURL = this.getMBeanURL(name);
            connection = this.getConnection(mbeanURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("getMBeanInfo", io, mbeanURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    boolean updateOperations;
                    boolean updateAttributes;
                    MBeanInfoWrapper wrapper = this.converter.readMBeanInfo(connection.getInputStream());
                    this.mbeanAttributesURLMap.put(name, new DelayedURL(mbeanURL, wrapper.attributesURL));
                    Map<String, DelayedURL> attributeURLsMap = this.mbeanAttributeURLsMap.get(name);
                    boolean bl = updateAttributes = attributeURLsMap != null;
                    if (!updateAttributes) {
                        attributeURLsMap = new HashMap<String, DelayedURL>();
                        this.mbeanAttributeURLsMap.put(name, attributeURLsMap);
                    }
                    this.processAttributeOrOperationURLs(attributeURLsMap, wrapper.attributeURLs, mbeanURL, updateAttributes);
                    Map<String, DelayedURL> operationURLsMap = this.mbeanOperationURLsMap.get(name);
                    boolean bl2 = updateOperations = operationURLsMap != null;
                    if (!updateOperations) {
                        operationURLsMap = new HashMap<String, DelayedURL>();
                        this.mbeanOperationURLsMap.put(name, operationURLsMap);
                    }
                    this.processAttributeOrOperationURLs(operationURLsMap, wrapper.operationURLs, mbeanURL, updateOperations);
                    return wrapper.mbeanInfo;
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.result.exception", new Object[0]), cnf);
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("getMBeanInfo", e, mbeanURL);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("getMBeanInfo", connection);
                }
                catch (IntrospectionException ie) {
                    throw ie;
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (ReflectionException re) {
                    throw re;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("getMBeanInfo", responseCode, connection);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        String sourceMethod = "isInstanceOf";
        this.checkConnection();
        if (name.isPattern()) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.object.name.pattern", name));
        }
        URL instanceOfURL = null;
        HttpsURLConnection connection = null;
        try {
            instanceOfURL = this.getInstanceOfURL(name, className);
            connection = this.getConnection(instanceOfURL, ClientConstants.HttpMethod.GET);
        }
        catch (IOException io) {
            throw this.getRequestErrorException("isInstanceOf", io, instanceOfURL);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                try {
                    return this.converter.readBoolean(connection.getInputStream());
                }
                catch (Exception e) {
                    throw this.getResponseErrorException("isInstanceOf", e, instanceOfURL);
                }
            }
            case 400: 
            case 500: {
                try {
                    throw this.getServerThrowable("isInstanceOf", connection);
                }
                catch (ClassNotFoundException cnf) {
                    throw new IOException(cnf);
                }
                catch (InstanceNotFoundException inf) {
                    throw inf;
                }
                catch (Throwable t) {
                    throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.unexpected.server.throwable", new Object[0]), t);
                }
            }
            case 401: 
            case 403: {
                throw this.getBadCredentialsException(responseCode, connection);
            }
        }
        throw this.getResponseCodeErrorException("isInstanceOf", responseCode, connection);
    }

    private URL getRootURL() throws IOException {
        return this.rootURL.getURL();
    }

    private URL getDefaultDomainURL() throws IOException {
        return this.defaultDomainURL.getURL();
    }

    private URL getDomainsURL() throws IOException {
        return this.domainsURL.getURL();
    }

    URL getNotificationsURL() throws IOException {
        return this.notificationsURL.getURL();
    }

    private URL getMBeanCountURL() throws IOException {
        return this.mbeanCountURL.getURL();
    }

    private URL getAttributeURL(ObjectName name, String attributeName) throws IOException, AttributeNotFoundException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (!this.mbeanAttributeURLsMap.containsKey(name)) {
            this.getMBeanInfo(name);
        }
        if (!this.mbeanAttributeURLsMap.containsKey(name)) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.instance.not.found", name));
        }
        if (!this.mbeanAttributeURLsMap.get(name).containsKey(attributeName)) {
            throw new AttributeNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.attribute.not.found", name, attributeName));
        }
        return this.mbeanAttributeURLsMap.get(name).get(attributeName).getURL();
    }

    private URL getAttributesURL(ObjectName name) throws IOException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (!this.mbeanAttributesURLMap.containsKey(name)) {
            this.getMBeanInfo(name);
        }
        if (!this.mbeanAttributesURLMap.containsKey(name)) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.instance.not.found", name));
        }
        return this.mbeanAttributesURLMap.get(name).getURL();
    }

    private URL getAttributesURL(ObjectName name, String[] attributes) throws IOException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (attributes != null && attributes.length > 0) {
            StringBuilder sb = new StringBuilder();
            int length = attributes.length;
            for (int i = 0; i < length - 1; ++i) {
                sb.append("attribute=");
                sb.append(URLEncoder.encode(attributes[i], "UTF-8"));
                sb.append("&");
            }
            sb.append("attribute=");
            sb.append(URLEncoder.encode(attributes[length - 1], "UTF-8"));
            String attributeList = sb.toString();
            return new URL(this.getAttributesURL(name).toString() + "?" + attributeList);
        }
        return this.getAttributesURL(name);
    }

    private URL getOperationURL(ObjectName name, String operationName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        if (!this.mbeanOperationURLsMap.containsKey(name)) {
            this.getMBeanInfo(name);
        }
        if (!this.mbeanOperationURLsMap.containsKey(name) || !this.mbeanOperationURLsMap.get(name).containsKey(operationName)) {
            throw new ReflectionException(new IllegalArgumentException(RESTClientMessagesUtil.getMessage("jmx.rest.client.operation.not.found", name, operationName)));
        }
        return this.mbeanOperationURLsMap.get(name).get(operationName).getURL();
    }

    private URL getCreateMBeanURL() throws IOException {
        return this.createMBeanURL.getURL();
    }

    private URL getInstanceOfURL() throws IOException {
        return this.instanceOfURL.getURL();
    }

    private URL getInstanceOfURL(ObjectName name, String className) throws IOException {
        return new URL(this.getInstanceOfURL().toString() + "?" + (name != null ? "objectName=" + URLEncoder.encode(name.getCanonicalName(), "UTF-8") + "&" : "") + (className != null ? "className=" + URLEncoder.encode(className, "UTF-8") : ""));
    }

    private URL getMBeansURL() throws IOException {
        return this.mbeansURL.getURL();
    }

    private URL getMBeansURL(ObjectName name, String instanceOf) throws IOException {
        return new URL(this.getMBeansURL().toString() + "?" + (name != null ? "objectName=" + URLEncoder.encode(name.getCanonicalName(), "UTF-8") + "&" : "") + (instanceOf != null ? "className=" + URLEncoder.encode(instanceOf, "UTF-8") : ""));
    }

    private URL getMBeanURL(ObjectName name) throws IOException, InstanceNotFoundException {
        if (!this.mbeanInfoURLMap.containsKey(name)) {
            this.queryMBeans(name, null, null, true);
        }
        if (!this.mbeanInfoURLMap.containsKey(name)) {
            throw new InstanceNotFoundException(RESTClientMessagesUtil.getMessage("jmx.rest.client.instance.not.found", name));
        }
        return this.mbeanInfoURLMap.get(name).getURL();
    }

    private void purgeMBeanURLs(ObjectName name) {
        this.mbeanInfoURLMap.remove(name);
        this.mbeanAttributesURLMap.remove(name);
        this.mbeanAttributeURLsMap.remove(name);
        this.mbeanOperationURLsMap.remove(name);
    }

    private void processAttributeOrOperationURLs(Map<String, DelayedURL> destination, Map<String, String> source, URL parentURL, boolean update) {
        if (update) {
            HashSet<String> missingKeys = new HashSet<String>(destination.keySet());
            missingKeys.removeAll(source.keySet());
            for (String missingKey : missingKeys) {
                destination.remove(missingKey);
            }
        }
        for (Map.Entry<String, String> e : source.entrySet()) {
            if (update && destination.containsKey(e.getKey()) && destination.get(e.getKey()).getString().equals(e.getValue())) continue;
            destination.put(e.getKey(), new DelayedURL(parentURL, e.getValue()));
        }
    }

    private void processMBeanInfoURLs(Map<ObjectName, String> source, URL parentURL, boolean complete) {
        if (complete) {
            HashSet<ObjectName> missingKeys = new HashSet<ObjectName>(this.mbeanInfoURLMap.keySet());
            missingKeys.removeAll(source.keySet());
            for (ObjectName missingKey : missingKeys) {
                this.purgeMBeanURLs(missingKey);
            }
        }
        for (Map.Entry<ObjectName, String> e : source.entrySet()) {
            if (this.mbeanInfoURLMap.containsKey(e.getKey()) && this.mbeanInfoURLMap.get(e.getKey()).getString().equals(e.getValue())) continue;
            if (this.mbeanInfoURLMap.containsKey(e.getKey())) {
                this.purgeMBeanURLs(e.getKey());
            }
            this.mbeanInfoURLMap.put(e.getKey(), new DelayedURL(parentURL, e.getValue()));
        }
    }

    synchronized void logSevereException(String sourceMethod, String errorMsg, Exception e) {
        logger.logp(Level.SEVERE, logger.getName(), sourceMethod, errorMsg, e);
    }

    synchronized IOException getRequestErrorException(String sourceMethod, Exception e, URL url) {
        String errorMsg = RESTClientMessagesUtil.getMessage("jmx.rest.client.request.error", url.toString(), this.connector.getConnectionId());
        logger.logp(Level.SEVERE, logger.getName(), sourceMethod, errorMsg, e);
        return new IOException(errorMsg, e);
    }

    synchronized IOException getResponseErrorException(String sourceMethod, Exception e, URL url) {
        String errorMsg = RESTClientMessagesUtil.getMessage("jmx.rest.client.response.error", url.toString(), this.connector.getConnectionId());
        logger.logp(Level.SEVERE, logger.getName(), sourceMethod, errorMsg, e);
        return new IOException(errorMsg, e);
    }

    synchronized IOException getResponseCodeErrorException(String methodName, int responseCode, HttpsURLConnection connection) {
        String responseMessage = null;
        try {
            responseMessage = connection.getResponseMessage();
        }
        catch (IOException io) {
            // empty catch block
        }
        String errorMsg = RESTClientMessagesUtil.getMessage("jmx.rest.client.response.code.error", responseCode, responseMessage, connection.getURL().toString(), this.connector.getConnectionId());
        logger.logp(Level.SEVERE, logger.getName(), methodName, errorMsg);
        return new IOException(errorMsg);
    }

    synchronized Throwable getServerThrowable(String methodName, HttpsURLConnection connection) {
        Throwable t;
        try {
            t = this.converter.readThrowable(connection.getErrorStream());
        }
        catch (ClassNotFoundException cnf) {
            t = new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.throwable.exception", new Object[0]), cnf);
        }
        catch (Exception e) {
            this.getResponseErrorException(methodName, e, connection.getURL());
            t = new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.server.throwable.exception", new Object[0]), e);
        }
        return t;
    }

    IOException getBadCredentialsException(int responseCode, HttpsURLConnection connection) {
        String responseMessage = null;
        try {
            responseMessage = connection.getResponseMessage();
        }
        catch (IOException io) {
            // empty catch block
        }
        return new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.bad.credentials", responseCode, responseMessage));
    }

    void close() throws IOException {
        this.disconnect();
        JSONConverter.returnConverter(this.converter);
        this.notificationRegistry.close();
    }

    synchronized void connectionFailed(Throwable t) {
        this.disconnect();
        JSONConverter.returnConverter(this.converter);
        this.connector.connectionFailed(t);
    }

    private synchronized void disconnect() {
        this.disconnected = true;
    }

    synchronized boolean isConnected() {
        return !this.disconnected;
    }

    private void checkConnection() throws IOException {
        if (!this.isConnected()) {
            throw new IOException(RESTClientMessagesUtil.getMessage("jmx.rest.client.not.connected", new Object[0]));
        }
    }

    HttpsURLConnection getConnection(URL url, ClientConstants.HttpMethod method) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(method == ClientConstants.HttpMethod.POST || method == ClientConstants.HttpMethod.PUT);
        connection.setUseCaches(false);
        connection.setRequestMethod(method.toString());
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setReadTimeout(this.connector.getReadTimeout());
        connection.setRequestProperty("Authorization", this.connector.getBasicAuthHeader());
        if (this.connector.isHostnameVerificationDisabled()) {
            connection.setHostnameVerifier(this.hostnameVerificationDisabler);
        }
        return connection;
    }

    Connector getConnector() {
        return this.connector;
    }
}

