/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphereliberty.WebSphereLibertyHelper;
import com.urbancode.air.plugin.websphereliberty.WebSphereLibertyServerXmlHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1])

def props = apTool.getStepProperties();

def wlpHome = props['wlpHome'];
def server = props['server'];
def controllerHostName = props['controllerHostName'];
def controllerPort = props['controllerPort'];
def adminUser = props['adminUser'];
def adminPassword = props['adminPassword'];
def keystorePassword = props['keystorePassword'];
def optionalArgs = props['optionalArgs'];

def wslh = new WebSphereLibertyHelper(wlpHome);
String configFileName = wslh.joinCollective(server, controllerHostName, controllerPort, adminUser, adminPassword, keystorePassword, optionalArgs, apTool.isWindows);

// Update server.xml with include referencing configFileName
def wslxh = new WebSphereLibertyServerXmlHelper(wlpHome, server);
wslxh.appendIncludeInServerXml(configFileName);

