/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphereliberty.WebSphereLibertyHelper;
import com.urbancode.air.plugin.websphereliberty.WebSphereLibertyServerXmlHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1])

def props = apTool.getStepProperties();

def wlpHome = props['wlpHome'];
def serverName = props['server'];
def keystorePassword = props['keystorePassword'];
def user = props['user'];
def password = props['password'];
def optionalArgs = props['optionalArgs'];

def wslh = new WebSphereLibertyHelper(wlpHome);
String configFileName = wslh.createCollective(serverName, keystorePassword, optionalArgs, apTool.isWindows);

// Update quickStartSecurity node in configFileName with supplied user/password
def wslxh = new WebSphereLibertyServerXmlHelper(wlpHome, serverName);
String encodedPw = wslxh.encode(password, apTool.isWindows);
wslxh.updateQuickStartSecurity(user, encodedPw, configFileName);

// Update server.xml with include referencing configFileName
wslxh.appendIncludeInServerXml(configFileName);

