/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.websphereliberty.WebSphereLibertyHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1])

def props       = apTool.getStepProperties();
def wlpHome     = props['wlpHome'].trim();
def wlpUserDir  = props['wlpUserDir'].trim();
def sourcePath  = props['sourcePath'].trim();
def targetPath  = props['targetPath'].trim();

// use '|' as the string delimiter for parsing arguments
def options="--sourcePath=" + sourcePath + "|--targetPath=" + targetPath;

def wslh = new WebSphereLibertyHelper(wlpHome, wlpUserDir);
wslh.mergePluginConfig(options, apTool.isWindows);
