import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

final def isWindows = apTool.isWindows;

def startQCmd = isWindows ? "runmqsc.exe" : "runmqsc.sh"
def queueManagerName = props["queueManagerName"];
def queueName = props["queueName"];
def commandDir = props['commandDir'];
def arguments = props['arguments'];

def comDirFile = new File(commandDir);
def startQFile = new File(comDirFile, startQCmd)

def cmdArgs = [startQFile.absolutePath];
cmdArgs << arguments
cmdArgs << queueManagerName

def scriptData = "ALTER QMGR PERFMEV(ENABLED)\n";

scriptData += "DEFINE QLOCAL('" + queueName + "')";
println "about to run the command " + scriptData;

def helper = new MQHelper(cmdArgs, scriptData)
helper.runCommandScript("Defining a Queue")