import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

final def isWindows = apTool.isWindows;

def runQScript = isWindows ? "runmqsc.exe" : "runmqsc.sh"
def queueName = props["queueName"];
def queueManagerName = props["queueManagerName"];
def depthHigh = props["depthHigh"];
def depthLow = props["depthLow"];
def depthMax = props["depthMax"];
def commandDir = props['commandDir'];
def arguments = props['arguments'];

def comDirFile = new File(commandDir);
def runQFile = new File(comDirFile, runQScript);

def cmdArgs = [runQFile.absolutePath];
cmdArgs << arguments;
cmdArgs << queueManagerName;
println "Command args are " + cmdArgs

def scriptData = "ALTER QMGR PERFMEV(ENABLED)\n";

scriptData += " ALTER QLOCAL('" + queueName + "')";

if (depthHigh != "") {
    scriptData += " QDEPTHHI(" + depthHigh + ")"
    scriptData += " QDPHIEV(ENABLED)"
}

if (depthLow != "") {
    scriptData += " QDEPTHLO(" + depthLow + ")"
    scriptData += " QDPLOEV(ENABLED)"
}

if (depthMax != "") {
    scriptData += " MAXDEPTH(" + depthMax + ")"
    scriptData += " QDPMAXEV(ENABLED)"
}

println "About to run the command";
println "ScriptData is " + scriptData

def helper = new MQHelper(cmdArgs, scriptData)
helper.runCommandScript("Editing Depth Information")

apTool.storeOutputProperties();//write the output properties to the file