import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

final def isWindows = apTool.isWindows;

def propValue = props['propName'];
def queueName = props['queueName'];
def queueText = props['queueText'];
def commandDir = props['commandDir'];
def arguments = props['arguments'];

def createQCmd = isWindows ? "crtmqm.exe" : "crtmqm.sh"

def comDirFile = new File(commandDir);
def createQFile = new File(comDirFile, createQCmd);

def cmdArgs = [createQFile.absolutePath];
println "Checking description";
if (queueText != "") {
    cmdArgs << "-c";
    cmdArgs << queueText;
}

cmdArgs << arguments;
cmdArgs << queueName;

def helper = new MQHelper(cmdArgs)
helper.runCommand("Creating a Queue Manager")

apTool.storeOutputProperties();//write the output properties to the file

System.exit(0);