/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

final def isWindows = apTool.isWindows;

def queueName = props["queueName"];
def trgType = props['trgType']
def trgData = props['trgData']

def helper = MQScriptHelper.newInstance(props);
helper.startCommand("ALTER");
helper.addKeyValueToCommand("QLOCAL",queueName);
helper.addSingletonElementToCommand("TRIGGER");

helper.addUnquotedKeyValueToCommand("TRIGTYPE", trgType);
helper.addKeyValueToCommand("TRIGDATA", trgData);

helper.writeCommand();
helper.execute();
