/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

final def isWindows = apTool.isWindows;

def aliasName      = props["aliasName"];
def queueName      = props["queueName"];
def descr          = props["description"];
def get            = props["get"];
def put            = props["put"];
def replace        = props["replace"];
def additionalArgs = props["additionalArgs"].split('\n').join(',').split(',')
                            .findAll{it && it.trim().size() > 0} as String[];
println "Additional Arguments: " + additionalArgs

// Hidden Variables
def clusnl      = props["clusnl"];
def cluster     = props["cluster"];
def clwlprty    = props["clwlprty"];
def clwlrank    = props["clwlrank"];
def defbind     = props["defbind"];
def defpsist    = props["defpsist"];
def defprty     = props["defprty"];
def defpresp    = props["defpresp"];
def defreada    = props["defreada"];
def propctl     = props["propctl"];
def scope       = props["scope"];
def targtype    = props["targtype"];


def helper = MQScriptHelper.newInstance(props)
helper.startCommand("DEFINE");
helper.addKeyValueToCommand("QALIAS", aliasName);
helper.addKeyValueToCommand("TARGET", queueName);

if (descr) {
    helper.addKeyValueToCommand("DESCR", descr);
}
if (get != "IGNORE") {
    helper.addUnquotedKeyValueToCommand("GET", get);
}
if (put != "IGNORE") {
    helper.addUnquotedKeyValueToCommand("PUT", put);
}
if (replace != "IGNORE") {
    helper.addSingletonElementToCommand(replace);
}

// Hidden Variables
if (clusnl && cluster) {
    println "[Error] Cannot specify both 'Cluster' and 'Cluster Namelist' properties."
    println "\tPlease review the Define Queue Alias step and correct its properties."
    System.exit(1)
}
if (clusnl) {
    helper.addKeyValueToCommand("CLUSNL", clusnl);
}
if (cluster) {
    helper.addKeyValueToCommand("CLUSTER", cluster);
}
if (clwlprty) {
    helper.addUnquotedKeyValueToCommand("CLWLPRTY", clwlprty);
}
if (clwlrank) {
    helper.addUnquotedKeyValueToCommand("CLWLRANK", clwlrank);
}
if (defbind != "IGNORE") {
    helper.addUnquotedKeyValueToCommand("DEFBIND", defbind);
}
if (defpsist != "IGNORE") {
    helper.addUnquotedKeyValueToCommand("DEFPSIST", defpsist);
}
if (defpresp != "IGNORE") {
    helper.addUnquotedKeyValueToCommand("DEFPRESP", defpresp);
}
if (defreada != "IGNORE") {
    helper.addUnquotedKeyValueToCommand("DEFREADA", defreada);
}
if (propctl != "IGNORE") {
    helper.addUnquotedKeyValueToCommand("PROPCTL", propctl);
}
if (scope != "IGNORE") {
    helper.addUnquotedKeyValueToCommand("SCOPE", scope);
}
if (targtype != "IGNORE") {
    helper.addUnquotedKeyValueToCommand("TARGTYPE", targtype);
}

// Add all Additional Variables

for (def arg : additionalArgs) {
    helper.addSingletonElementToCommand(arg);
}

helper.writeCommand();
helper.execute();
