/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

// Topic Properties
def queueName      = props["queueName"];
def description    = props["description"];
def force          = Boolean.valueOf(props["force"]);
def get            = props["get"];
def maxdepth       = props["maxdepth"];
def maxmsgl        = props["maxmsgl"];
def msgdlvsq       = props["msgdlvsq"];
def put            = props["put"];
def share          = props["share"];
def trigger        = props["trigger"];
def usage          = props["usage"];
def additionalArgs = props["additionalArgs"].split('\n').join(',').split(',')
                            .findAll{it && it.trim().size() > 0} as String[];
println "Additional Arguments: " + additionalArgs

def helper         = MQScriptHelper.newInstance(props)

helper.startCommand("ALTER");
helper.addKeyValueToCommand("QLOCAL", queueName);

if (description) {
    helper.addKeyValueToCommand("DESCR", description);
}
if (force) {
    helper.addSingletonElementToCommand("FORCE");
}
if (get != "NONE") {
    helper.addUnquotedKeyValueToCommand("GET", get);
}
if (maxdepth) {
    helper.addUnquotedKeyValueToCommand("MAXDEPTH", maxdepth);
}
if (maxmsgl) {
    helper.addUnquotedKeyValueToCommand("MAXMSGL", maxmsgl);
}
if (msgdlvsq != "NONE") {
    helper.addUnquotedKeyValueToCommand("MSGDLVSQ", msgdlvsq);
}
if (put != "NONE") {
    helper.addUnquotedKeyValueToCommand("PUT", put);
}
if (share != "NONE") {
    helper.addSingletonElementToCommand(share);
}
if (trigger != "NONE") {
    helper.addSingletonElementToCommand(trigger);
}
if (usage != "NONE") {
    helper.addUnquotedKeyValueToCommand("USAGE", usage);
}
for (def arg : additionalArgs) {
    helper.addSingletonElementToCommand(arg);
}

helper.writeCommand();
helper.execute();
