/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

// Topic Properties
def channelName    = props["channelName"];
def description    = props["description"];
def discint        = props["discint"];
def maxinst        = props["maxinst"];
def maxinstc       = props["maxinstc"];
def maxmsgl        = props["maxmsgl"];
def trptype        = props["trptype"];
def additionalArgs = props["additionalArgs"].split('\n').join(',').split(',')
                            .findAll{it && it.trim().size() > 0} as String[];
println "Additional Arguments: " + additionalArgs

def helper         = MQScriptHelper.newInstance(props)

helper.startCommand("ALTER");
helper.addKeyValueToCommand("CHANNEL", channelName);
helper.addUnquotedKeyValueToCommand("CHLTYPE", "SVRCONN");

if (description) {
    helper.addKeyValueToCommand("DESCR", description);
}
if (discint) {
    helper.addUnquotedKeyValueToCommand("DISCINT", discint);
}
if (maxinst) {
    helper.addUnquotedKeyValueToCommand("MAXINST", maxinst);
}
if (maxinstc) {
helper.addUnquotedKeyValueToCommand("MAXINSTC", maxinstc);
}
if (maxmsgl) {
helper.addUnquotedKeyValueToCommand("MAXMSGL", maxmsgl);
}
if (trptype != "NONE") {
helper.addUnquotedKeyValueToCommand("TRPTYPE", trptype);
}
for (def arg : additionalArgs) {
    helper.addSingletonElementToCommand(arg);
}

helper.writeCommand();
helper.execute();
