/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

final def isWindows = apTool.isWindows;

def subName        = props["subName"];
def topicString    = props['topicString'];
def destQueueName  = props['destQueueName']
def destqmgr       = props['destqmgr']
def msgProp        = props['msgProp']
def selector       = props['selector']
def wschema        = props['wschema']
def additionalArgs = props["additionalArgs"].split('\n').join(',').split(',')
                            .findAll{it && it.trim().size() > 0} as String[];
println "Additional Arguments: " + additionalArgs

def helper = MQScriptHelper.newInstance(props)
helper.startCommand("DEFINE");
helper.addKeyValueToCommand("SUB", subName);
helper.addKeyValueToCommand("TOPICSTR", topicString);
helper.addKeyValueToCommand("DEST", destQueueName);
helper.addUnquotedKeyValueToCommand("PSPROP", msgProp);
if (destqmgr) {
    helper.addKeyValueToCommand("DESTQMGR", destqmgr);
}
if (selector) {
    helper.addKeyValueToCommand("SELECTOR", selector);
}
if (wschema != "NONE") {
    helper.addUnquotedKeyValueToCommand("WSCHEMA", wschema);
}
for (def arg : additionalArgs) {
    helper.addSingletonElementToCommand(arg);
}

helper.writeCommand();
helper.execute();
