/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

final def isWindows = apTool.isWindows;

def queueManagerName = props["queueManagerName"];
def commandDir = props['commandDir'];
def arguments = props['arguments'];

def baseCmd = "endmqm"
def cmdFile;
def comDirFile = new File(commandDir);
if (isWindows) {
    cmdFile = new File(comDirFile, baseCmd + ".exe");
}
else {
    cmdFile = new File(comDirFile, baseCmd);
    if (!cmdFile.isFile()) {
        cmdFile = new File(comDirFile, baseCmd+".sh");
    }
}

if (!cmdFile.isFile()) {
    System.out.println("Cannot find endmqm execuatable " + cmdFile.absolutePath);
    System.exit(1);
}

def cmdArgs = [cmdFile.absolutePath];
if (arguments) {
    arguments.eachLine { line ->
        cmdArgs << line.trim();
    }
}
cmdArgs << queueManagerName

def helper = new MQHelper(cmdArgs)
helper.runCommand("Stopping the Queue Manager")
