/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

// Topic Properties
def clusterName    = props["topicName"];
def defprty        = props["defprty"];
def defpsist       = props["defpsist"];
def defpresp       = props["defpresp"];
def description    = props["description"];
def mcast          = props["mcast"];
def npmsgdlv       = props["npmsgdlv"];
def pmsgdlv        = props["pmsgdlv"];
def proxysub       = props["proxysub"];
def pub            = props["pub"];
def sub            = props["sub"];
def topicName      = props["topicName"];
def type           = props["type"];
def additionalArgs = props["additionalArgs"].split('\n').join(',').split(',')
                            .findAll{it && it.trim().size() > 0} as String[];
println "Additional Arguments: " + additionalArgs

def helper         = MQScriptHelper.newInstance(props);

helper.startCommand("ALTER");
helper.addKeyValueToCommand("TOPIC", topicName);

if (type != "NONE") {
    helper.addUnquotedKeyValueToCommand("TYPE", type);
}
if (defprty != "NONE") {
    helper.addUnquotedKeyValueToCommand("DEFPRTY", defprty);
}
if (defpsist != "NONE") {
    helper.addUnquotedKeyValueToCommand("DEFPSIST", defpsist);
}
if (defpresp != "NONE") {
    helper.addUnquotedKeyValueToCommand("DEFPRESP", defpresp);
}
if (description) {
    helper.addKeyValueToCommand("DESCR", description);
}
if (mcast != "NONE") {
    helper.addUnquotedKeyValueToCommand("MCAST", mcast);
}
if (npmsgdlv != "NONE") {
    helper.addUnquotedKeyValueToCommand("NPMSGDLV", npmsgdlv);
}
if (pmsgdlv != "NONE") {
    helper.addUnquotedKeyValueToCommand("PMSGDLV", pmsgdlv);
}
if (proxysub != "NONE") {
    helper.addUnquotedKeyValueToCommand("PROXYSUB", proxysub);
}
if (pub != "NONE") {
    helper.addUnquotedKeyValueToCommand("PUB", pub);
}
if (sub != "NONE") {
    helper.addUnquotedKeyValueToCommand("SUB", sub);
}
for (def arg : additionalArgs) {
    helper.addSingletonElementToCommand(arg);
}

helper.writeCommand();
helper.execute();
