/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.urbancode.air.plugin.webspheremq.helper;
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;

public class MQHelper {
    def workDir = new File(".").canonicalFile
    final def cmdHelper = new CommandHelper(workDir)
    def cmdArgs = []
    def scriptData
    def out = System.out

    public MQHelper(def cmdArgsIn) {
        cmdArgs = cmdArgsIn;
    }

    public MQHelper(def cmdArgsIn, def scriptDataIn) {
        cmdArgs = cmdArgsIn
        scriptData = scriptDataIn
    }

    def runCommand(def message) {
        cmdHelper.runCommand(message, cmdArgs);
    }

    def runCommandScript(def message) {
        cmdHelper.runCommand(message, cmdArgs) {proc ->
            proc.withWriter{it << scriptData};
            proc.consumeProcessOutput(out, out);
        }
    }
}
