/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();
def propsCopy = apTool.getStepProperties();

final def isWindows = apTool.isWindows;

def channelName = props["channelName"];
def monLvl = props['monLvl']
def channelType = null;

propsCopy['scriptFile'] = props['scriptFile']+"-display";
propsCopy['deleteOnExecute'] = "true";

def helper = MQScriptHelper.newInstance(propsCopy)
helper.startCommand("DISPLAY");
helper.addKeyValueToCommand("CHANNEL", channelName); 
helper.writeCommand();
helper.executeNow() { proc ->
    proc.consumeProcessErrorStream(System.out);
    BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getIn()));
    String line;
    while ((line = reader.readLine()) != null) {
        if (channelType == null) {
            def matcher = line =~ /CHLTYPE\((.*?)\)/
            if (matcher.find()) {
                channelType = matcher.group(1);
            }
        }
    }
    proc.waitForProcessOutput(System.out, System.out);
}

if (channelType == null) {
   throw new IllegalArgumentException("Cannot determin channel type!");
}


helper.startCommand("ALTER");
helper.addKeyValueToCommand("CHANNEL", channelName); 
helper.addUnquotedKeyValueToCommand("CHLTYPE", channelType);
helper.addUnquotedKeyValueToCommand("MONCHL", monLvl);
helper.writeCommand();
helper.execute();

