/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

final def isWindows = apTool.isWindows;

def queueName = props["queueName"];
def depthHigh = props["depthHigh"];
def depthLow = props["depthLow"];
def depthMax = props["depthMax"];

def helper = MQScriptHelper.newInstance(props);
helper.startCommand("ALTER");
helper.addKeyValueToCommand("QLOCAL",queueName);

if (depthHigh != "") {
    helper.addUnquotedKeyValueToCommand("QDEPTHHI", depthHigh);
    helper.addUnquotedKeyValueToCommand("QDPHIEV", "ENABLED");
}

if (depthLow != "") {
    helper.addUnquotedKeyValueToCommand("QDEPTHLO", depthLow);
    helper.addUnquotedKeyValueToCommand("QDPLOEV", "ENABLED");
}

if (depthMax != "") {
    helper.addUnquotedKeyValueToCommand("MAXDEPTH", depthMax);
    helper.addUnquotedKeyValueToCommand("QDPMAXEV","ENABLED");
}

helper.writeCommand();
helper.execute();
