/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

// Topic Properties
def channelName    = props["channelName"];
def batchsz        = props["batchsz"];
def description    = props["description"];
def maxmsgl        = props["maxmsgl"];
def npmspeed       = props["npmspeed"];
def trptype        = props["trptype"];
def additionalArgs = props["additionalArgs"].split('\n').join(',').split(',')
                            .findAll{it && it.trim().size() > 0} as String[];
println "Additional Arguments: " + additionalArgs

def helper      = MQScriptHelper.newInstance(props)

helper.startCommand("ALTER");
helper.addKeyValueToCommand("CHANNEL", channelName);
helper.addUnquotedKeyValueToCommand("CHLTYPE", "RCVR");

if (batchsz) {
    helper.addUnquotedKeyValueToCommand("BATCHSZ", batchsz);
}
if (description) {
    helper.addKeyValueToCommand("DESCR", description);
}
if (maxmsgl) {
helper.addUnquotedKeyValueToCommand("MAXMSGL", maxmsgl);
}
if (npmspeed != "NONE") {
    helper.addUnquotedKeyValueToCommand("NPMSPEED", npmspeed);
}
if (trptype != "NONE") {
    helper.addUnquotedKeyValueToCommand("TRPTYPE", trptype);
}
for (def arg : additionalArgs) {
    helper.addSingletonElementToCommand(arg);
}

helper.writeCommand();
helper.execute();
