/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

final def isWindows = apTool.isWindows;

 
def queueManagerName = props["queueManagerName"];
def commandDir = props['commandDir'];
def arguments = props['arguments'];

def baseCmd = "strmqm"
def cmdFile;
def comDirFile = new File(commandDir);
if (isWindows) {
    cmdFile = new File(comDirFile, baseCmd + ".exe");
}
else {
    cmdFile = new File(comDirFile, baseCmd);
    if (!cmdFile.isFile()) {
        cmdFile = new File(comDirFile, baseCmd+".sh");
    }
}

if (!cmdFile.isFile()) {
    System.out.println("Cannot find strmqm execuatable " + cmdFile.absolutePath);
    System.exit(1);
}

def cmdArgs = [cmdFile.absolutePath];
if (arguments) {
    arguments.eachLine { line ->
        cmdArgs << line.trim();
    }
}
cmdArgs << queueManagerName

def helper = new MQHelper(cmdArgs)
helper.runCommand("Starting the Queue Manager")
