/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQPermissionsHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

//allow the invoker to specify the objectType outside of the input props for reuse
if (this.args.length > 2) {
    def objectType = this.args[2]?.trim();
    if (objectType) {
        props['objectType'] = objectType;
    }
}

final def isWindows = apTool.isWindows;

def helper = MQPermissionsHelper.newInstance(props);
helper.execute();
