/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.plugin.webspheremq.helper.MQScriptHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]) //assuming that args[0] is input props file and args[1] is output props file

def props = apTool.getStepProperties();

def nlName = props["nlName"];
def description = props['description']
def namesStr = props['names']

def names = ""
if (namesStr) {
    StringBuilder builder = new StringBuilder()
    // Trim and separate all input into a String array
    namesStr.eachLine {
        for ( name in it.trim().split(',')) {
            // Replace all spaces with "" (Note: all empty strings are ignored by MQ)
            name = name.replaceAll("\\s","")
            builder.append("\'"+ name + "\',")
        }
    }
    // Remove the last ','
    builder.replace(builder.length()-1, builder.length(), "")
    names = builder.toString()
}

def helper = MQScriptHelper.newInstance(props)
helper.startCommand("DEFINE");
helper.addUnquotedKeyValueToCommand("NAMELIST", nlName);
helper.addKeyValueToCommand("DESCR", description);
helper.addUnquotedKeyValueToCommand("NAMES", names);
helper.writeCommand();
helper.execute();
