/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.logging;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@BridgeMethodsAdded
public class Log4jPrintStream
extends PrintStream {
    private static final ThreadLocal<Boolean> inStream = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private Logger logger;
    private Priority level;
    private ThreadLocal<StringBuffer> buffer = new ThreadLocal();

    public Log4jPrintStream(String loggerName, Priority level) {
        this(Logger.getLogger((String)loggerName), level);
    }

    public Log4jPrintStream(Logger logger, Priority level) {
        super(new ByteArrayOutputStream(0));
        this.logger = logger;
        this.level = level;
    }

    public void flush() {
        if (this.getBuffer().length() > 0) {
            this.println("");
        }
    }

    public void print(String s) {
        this.getBuffer().append(s);
    }

    public void println() {
        this.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String s) {
        if (!inStream.get().booleanValue()) {
            inStream.set(true);
            try {
                this.getBuffer().append(s);
                this.logger.log(this.level, (Object)this.getBuffer().toString());
                this.resetBuffer();
            }
            finally {
                inStream.set(false);
            }
        }
    }

    public void close() {
        this.logger = null;
    }

    public void print(boolean b) {
        this.print(String.valueOf(b));
    }

    public void print(char c) {
        this.print(String.valueOf(c));
    }

    public void print(char[] s) {
        this.print(new String(s));
    }

    public void print(double d) {
        this.print(String.valueOf(d));
    }

    public void print(float f) {
        this.print(String.valueOf(f));
    }

    public void print(int i) {
        this.print(String.valueOf(i));
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    public void println(boolean b) {
        this.println(String.valueOf(b));
    }

    public void println(char c) {
        this.println(String.valueOf(c));
    }

    public void println(char[] s) {
        this.println(String.valueOf(s));
    }

    public void println(double d) {
        this.println(String.valueOf(d));
    }

    public void println(float f) {
        this.println(String.valueOf(f));
    }

    public void println(int i) {
        this.println(String.valueOf(i));
    }

    public void println(long l) {
        this.println(String.valueOf(l));
    }

    public void println(Object obj) {
        this.println(String.valueOf(obj));
    }

    public void write(byte[] buf, int off, int len) {
        this.println(new String(buf, off, len));
    }

    public void write(int b) {
        throw new UnsupportedOperationException("method is not supported");
    }

    private StringBuffer getBuffer() {
        if (this.buffer.get() == null) {
            this.resetBuffer();
        }
        return this.buffer.get();
    }

    private void resetBuffer() {
        this.buffer.set(new StringBuffer());
    }
}

