/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.sandboxedjsruntime;

import com.urbancode.commons.sandboxedjsruntime.SandboxedContextFactory;
import com.urbancode.commons.sandboxedjsruntime.SandboxedJavaPackage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SandboxedJSRuntime {
    private static Set<String> keepMe;
    Context cx = Context.enter();
    ScriptableObject scope = this.cx.initStandardObjects();
    Map<String, SandboxedJavaPackage> topLevelPackages;

    public SandboxedJSRuntime() {
        this.setupPackages();
    }

    public void addContextObject(String varName, Object obj) {
        Object cxObj = Context.javaToJS((Object)obj, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)varName, (Object)cxObj);
    }

    public Object evaluateString(String script, String name) {
        return this.cx.evaluateString((Scriptable)this.scope, script, name, 1, null);
    }

    public Object callFunction(Function fn, Scriptable thisObj, Object[] args) {
        return fn.call(this.cx, fn.getParentScope(), thisObj, args);
    }

    public void exit() {
        Context.exit();
    }

    public void addVisibleClass(Class<?> clazz) {
        String name = clazz.getName();
        String[] parts = name.split("\\.");
        SandboxedJavaPackage pack = this.lookupOrCreateSanboxedJavaPackage(parts);
        NativeJavaClass nativeClass = new NativeJavaClass((Scriptable)this.scope, clazz);
        pack.addClass(parts[parts.length - 1], nativeClass);
    }

    private void removeCurrentScopeItems() {
        for (Object obj : this.scope.getAllIds()) {
            String str;
            if (!(obj instanceof String) || keepMe.contains(str = (String)obj)) continue;
            this.scope.delete(str);
        }
    }

    private void setupPackages() {
        this.topLevelPackages = new HashMap<String, SandboxedJavaPackage>();
        this.removeCurrentScopeItems();
        this.addVisibleClass(Properties.class);
    }

    private SandboxedJavaPackage lookupOrCreateSanboxedJavaPackage(String[] parts) {
        SandboxedJavaPackage result = null;
        SandboxedJavaPackage prev = null;
        SandboxedJavaPackage cur = null;
        int lastSeenPart = 0;
        int i = 0;
        while (i < parts.length - 1) {
            prev = cur;
            cur = i == 0 ? this.topLevelPackages.get(parts[i]) : prev.getSubPackage(parts[i]);
            if (cur == null) break;
            lastSeenPart = i++;
        }
        if (cur == null) {
            SandboxedJavaPackage newPackage = this.createPackages(parts, lastSeenPart + 1);
            if (prev != null) {
                prev.addSubPackage(parts[lastSeenPart + 1], newPackage);
            } else {
                this.topLevelPackages.put(parts[0], newPackage);
                this.addContextObject(parts[0], newPackage);
            }
            result = this.lookupOrCreateSanboxedJavaPackage(parts);
        } else {
            result = cur;
        }
        return result;
    }

    private SandboxedJavaPackage createPackages(String[] parts, int i) {
        if (i > parts.length - 2) {
            throw new IllegalArgumentException("index must be at most 1 less than lenght of parts");
        }
        SandboxedJavaPackage pack = new SandboxedJavaPackage();
        if (i < parts.length - 2) {
            SandboxedJavaPackage curPack = this.createPackages(parts, i + 1);
            pack.addSubPackage(parts[i + 1], curPack);
        }
        return pack;
    }

    static {
        ContextFactory.initGlobal((ContextFactory)new SandboxedContextFactory());
        keepMe = new HashSet<String>();
        keepMe.add("Function");
        keepMe.add("Object");
        keepMe.add("Error");
        keepMe.add("isNaN");
        keepMe.add("NaN");
        keepMe.add("isFinite");
        keepMe.add("parseFloat");
        keepMe.add("parseInt");
        keepMe.add("Infinity");
        keepMe.add("undefined");
        keepMe.add("Array");
        keepMe.add("String");
        keepMe.add("Boolean");
        keepMe.add("Number");
        keepMe.add("Date");
        keepMe.add("Math");
        keepMe.add("JSON");
        keepMe.add("RegExp");
    }
}

