/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.crypto.FIPSHelper;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

@BridgeMethodsAdded
public class SecureRandomHelper {
    private static String FIPS_SECURE_RANDOM_ALG = "FIPSPRNG";
    private static String SHA1_SECURE_RANDOM_ALG = "SHA1PRNG";
    private static SecureRandom secureRandom = null;

    public static String getSecureRandomAlg() {
        String result = FIPSHelper.isFipsRequested() ? FIPS_SECURE_RANDOM_ALG : SHA1_SECURE_RANDOM_ALG;
        return result;
    }

    public static synchronized SecureRandom getSecureRandom() {
        if (secureRandom == null) {
            secureRandom = SecureRandomHelper.createNewSecureRandom();
        }
        return secureRandom;
    }

    public static SecureRandom createNewSecureRandom() {
        SecureRandom result;
        if (FIPSHelper.isFipsRequested()) {
            FIPSHelper.enableFips();
        }
        try {
            result = SecureRandom.getInstance(SecureRandomHelper.getSecureRandomAlg());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find secure random algorithm: " + SecureRandomHelper.getSecureRandomAlg(), e);
        }
        return result;
    }

    private SecureRandomHelper() {
    }
}

