/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import java.util.*;
import java.util.zip.*;
import java.io.*;

def isEmpty(value) {
	return value == null || value.equals("")
}

def extractWAR(war, workDirString) {
	def zis = new ZipInputStream(new FileInputStream(war))
	def warEntry = zis.getNextEntry()
	while (warEntry != null) {
		def fileName = warEntry.getName()
		if (fileName =~ /(?i)web.xml/) {
			def newFile = new File(workDirString + File.separator + fileName)
			new File(newFile.getParent()).mkdirs()
			def outstream = new FileOutputStream(newFile)
			def buf = new byte[1024]
			def len = 0;
			while ((len = zis.read(buf)) > 0) {
				outstream.write(buf, 0, len);
			}
			outstream.close()
		}
		zis.closeEntry()
		warEntry = zis.getNextEntry()
	}
	zis.close()
}

def getWebModuleName(war, workDirString) {
	extractWAR(war, workDirString)
	def webXML = new File(workDirString + "WEB-INF" + File.separator + "web.xml")
	def webModName = ''
	if (webXML.exists()) {
		def webApp = new XmlParser(false, false).parse(webXML)
		def displayName = webApp."display-name"[0]
		if (!isEmpty(displayName)) {
			webModName = displayName.value()[0]
		}
	}
	return webModName
}

def findApplicationOID(name, tool, props) {
	def wpUser = props['wpUser']
	def wpPass = props['wpPass']
	
	File tempFile = new File("temp.py")
	tempFile.deleteOnExit();
	BufferedWriter temp = new BufferedWriter(new FileWriter(tempFile))
	temp.writeLine("Portal.login('" + wpUser + "', '" + wpPass + "')")
	temp.writeLine("try:")
	temp.writeLine("\tprint Portlet.find('webmodule', 'name', '" + name + "')")
	temp.writeLine("except:")
	temp.writeLine("\tprint 'Not Found'")
	temp.writeLine("Portal.logout()")
	temp.close()
	
	def commandArgs = []
	commandArgs << tool
	commandArgs << "-username"
	commandArgs << wpUser
	commandArgs << "-password"
	commandArgs << wpPass
	commandArgs << "-lang"
	commandArgs << "jython"
	commandArgs << "-f"
	commandArgs << "temp.py"
	
	def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
	def procBuilder = new ProcessBuilder(commandArgs)
	if (isWindows) {
		def envMap = procBuilder.environment()
		envMap.put("PROFILE_CONFIG_ACTION", "true")
	}

	def statusProc = procBuilder.start()
	def reader = new BufferedReader(new InputStreamReader(statusProc.getInputStream()))
	def outputLines = []
	def line = reader.readLine()
	while (line != null) {
		outputLines << line
		line = reader.readLine()
	}
	
	def result = outputLines[2]
	if (!(result.equals("Not Found"))) {
		/* No exception caught searching for the OID */
		return result
	} else {
		return '' /* An exception caught searching for the OID */
	}
}

def computeURL(props) {
	def host = props['vpHost']
	if (isEmpty(host)) {
		host = System.getenv("HOSTNAME");
	}
	
	def urlString = "http://" + host + ":" + props['wpPort'] + "/wps/config"

	def urlContext = props['vpContext']
	if (! isEmpty(urlContext)) {
		if (!urlContext.startsWith("/")) {
			urlContext = "/" + urlContext
		}
		urlString = urlString + urlContext
	}
	
	return urlString
}

////////////// MAIN ////////////////////
def xmlScript = '''
<request
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:noNamespaceSchemaLocation="PortalConfig_6.1.0.xsd"
	type="update">
	
	<portal action="locate">
		<web-app active="true" removable="true">
		</web-app>
	</portal>

</request>
'''
final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
def wpscript = isWindows ? "wpscript.bat" : "wpscript.sh"
def xmlaccess = isWindows ? "xmlaccess.bat" : "xmlaccess.sh"

final def props = new Properties()
final def inputPropsFile = new File(args[0])
final def inputPropsStream = null
try {
    inputPropsStream = new FileInputStream(inputPropsFile)
    props.load(inputPropsStream)
}
catch (IOException e) {
    throw new RuntimeException(e)
}

def componentName = new File(".").getCanonicalFile().name
def workDirString = new File(".").getCanonicalPath() + File.separator

def portalHome = props['portalHome']
if (!(portalHome.endsWith("\\") || portalHome.endsWith("/"))) {
	portalHome = portalHome + File.separator
}

def profHome = props['profHome']
if (!(profHome.endsWith("\\") || profHome.endsWith("/"))) {
	profHome = profHome + File.separator
}

def war = props['war']
if (isEmpty(war)) {
	war = componentName
}
if (!(war =~ /(?i)\.war/)) {
	war = war + ".war"
}

def webModName = getWebModuleName(war, workDirString)
if (isEmpty(webModName)) {
	webModName = componentName
}

def displayName = props['displayName']
if (isEmpty(displayName)) {
	displayName = "PA_" + webModName.replaceAll("\\s+", "_")
}
def contextRoot = props['contextRoot']
if (isEmpty(contextRoot)) {
	contextRoot = "/wps/" + displayName
}
if (!contextRoot.startsWith("/")) {
	contextRoot = "/" + contextRoot
}

def request = new XmlParser(false, false).parseText(xmlScript)
def portal = request.portal[0]
def webapp = portal.children()[0]

webapp.appendNode("url", "file://localhost" + workDirString + war)//TODO for windows
webapp.appendNode("context-root", contextRoot)
webapp.appendNode("display-name", displayName)

def application_oid = findApplicationOID(webModName, portalHome + "bin" + File.separator + wpscript, props)
if (!isEmpty(application_oid)) {
	webapp.@action = "update"
	webapp.@objectid = application_oid.toString()
} else {
	webapp.@action = "create"
}

def inputScript = "xmlAccessScript.xml"
def xmlNodePrinter = new XmlNodePrinter(new PrintWriter(new FileWriter(inputScript)))
xmlNodePrinter.with {
	preserveWhitespace = true
}
xmlNodePrinter.print(request)

def configPath = profHome + "PortalServer" + File.separator + "bin" + File.separator + xmlaccess
def deployWARCommandArgs = [configPath]
if (props['useSOAPProps'].equals("true")) {
	deployWARCommandArgs.add("-useEncryptedCredentials")
	deployWARCommandArgs.add(profHome + "properties" + File.separator + "soap.client.props")
} else {
	deployWARCommandArgs.add("-user")
	deployWARCommandArgs.add(props['wpUser'])
	deployWARCommandArgs.add("-password")
	deployWARCommandArgs.add(props['wpPass'])
}

def urlString = computeURL(props)

deployWARCommandArgs.add("-url")
deployWARCommandArgs.add(urlString)
deployWARCommandArgs.add("-in")
deployWARCommandArgs.add(workDirString + inputScript)
deployWARCommandArgs.add("-out")
deployWARCommandArgs.add(workDirString + (inputScript.substring(0, inputScript.length() - 4) + "_out.xml"))

println deployWARCommandArgs.join(' ');
def procBuilder = new ProcessBuilder(deployWARCommandArgs);

if (isWindows) {
	def envMap = procBuilder.environment();
	envMap.put("PROFILE_CONFIG_ACTION", "true");
}

def statusProc = procBuilder.start();
def outPrint = new PrintStream(System.out, true);
statusProc.waitForProcessOutput(outPrint, outPrint);
System.exit(statusProc.exitValue());
