/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

def isEmpty(value) {
	return value == null || value.equals("")
}

def findFile(parent, fileToSearch) {
	File parentDir = new File(parent)
	File[] contents = parentDir.listFiles()
	def searchedFile = ""
	for (File file : contents) {
		if (file.isDirectory()) {
			searchedFile = findFile(file.getAbsolutePath(), fileToSearch)
			if (! isEmpty(searchedFile)) {
				return searchedFile
			}
		}
		else if (file.getName().equals(fileToSearch)) {
			return file.getAbsolutePath()
		}
	}
	return searchedFile
}

def runProcess(commandArgs) {
	def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
	def out = System.out
	def procBuilder = new ProcessBuilder(commandArgs)

	if (isWindows) {
		def envMap = procBuilder.environment()
		envMap.put("PROFILE_CONFIG_ACTION", "true")
	}

	def statusProc = procBuilder.start()
	def outPrint = new PrintStream(out, true)
	statusProc.waitForProcessOutput(outPrint, outPrint)

	return statusProc.exitValue()
}

def installPAA(commandArgs, props) {
	def componentName = new File(".").getCanonicalFile().name
	def appName = props['appName']
	if (isEmpty(appName)) {
		appName = componentName
	}
	if (!(appName =~ /(?i)\.paa$/)) {
		appName = appName + ".paa"
	}

	def wcmDetect = props['wcmdetect'] /* This is never null because of the default-value assigned */
	def installCommandList = []
	def paaLocation = findFile(new File(".").getCanonicalPath(), appName)
	installCommandList.addAll(commandArgs)
	installCommandList.add(1, "install-paa")
	installCommandList.add("-DPAALocation=" + paaLocation)

	if (wcmDetect.equals("true")) {
		installCommandList.add("-Dwcmdetect=true")
	}

	return runProcess(installCommandList)
}

def deployPAA(commandArgs, props) {
	def deployCommandList = []
	def componentName = new File(".").getCanonicalFile().name

	deployCommandList.addAll(commandArgs)
	deployCommandList.add(1, "deploy-paa")
	if (! isEmpty(props['assemblyName'])) {
		deployCommandList.add("-DappName=" + props['assemblyName'])
	} else {
		deployCommandList.add("-DappName=" + componentName)
	}

	if (! isEmpty(props['vpHost'])) deployCommandList.add("-DVirtualPortalHostName=" + props['vpHost'])
	if (! isEmpty(props['vpContext'])) deployCommandList.add("-DVirtualPortalContext=" + props['vpContext'])
	if (! isEmpty(props['maxTimeToWait'])) deployCommandList.add("-DmaxTimeToWait=" + props['maxTimeToWait'])
	if (! isEmpty(props['maxAppTimeToWait'])) deployCommandList.add("-DmaxAppTimeToWait=" + props['maxAppTimeToWait'])

        def additionalArgs = props["additionalArgs"]

        if (additionalArgs) {
            additionalArgs.split('\n').each { arg ->
                deployCommandList << arg
            }
        }
        
        

	return runProcess(deployCommandList)
}

////////////// MAIN ////////////////////
final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()

def configEngine = isWindows ? "ConfigEngine.bat" : "ConfigEngine.sh"
def wpPass = props['wpPass']
def wasPass = props['wasPass']
def profHome = props['profHome']
if (!(profHome.endsWith("\\") || profHome.endsWith("/"))) {
	profHome = profHome + File.separator
}
def configPath = profHome + "ConfigEngine" + File.separator + configEngine

def commandArgs = []
if (props['useWKPLCProps'].equals("true")) {
	commandArgs = [configPath]
} else {
	commandArgs = [
		configPath,
		"-DPortalAdminPwd=" + wpPass,
		"-DWasPassword=" + wasPass
	]
}

def exitValue = installPAA(commandArgs, props)
if (exitValue == 0) {
	exitValue = deployPAA(commandArgs, props)
}
System.exit(exitValue)
