/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

def isEmpty(value) {
	return value == null || value.equals("")
}

////////////// MAIN ////////////////////
final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
def componentName = new File(".").getCanonicalFile().name

def configEngine = isWindows ? "ConfigEngine.bat" : "ConfigEngine.sh"
def wpPass = props['wpPass']
def wasPass = props['wasPass']
def profHome = props['profHome']
if (!(profHome.endsWith("\\") || profHome.endsWith("/"))) {
	profHome = profHome + File.separator
}
def configPath = profHome + "ConfigEngine" + File.separator + configEngine

def commandArgs = []
if (props['useWKPLCProps'].equals("true")) {
	commandArgs = [configPath]
} else {
	commandArgs = [
		configPath,
		"-DPortalAdminPwd=" + wpPass,
		"-DWasPassword=" + wasPass
	]
}

def configCommand = props['configCommand']
if (isEmpty(configCommand)) {
	configCommand = componentName
}
commandArgs.add(1, configCommand)

def options = props['options']
if (!isEmpty(options)) {
	try {
		def pairs = options.split(",")
		for (pair in pairs) {
			def nameValue = pair.split("=")
			commandArgs << "-D" + nameValue[0].trim() + "=" + nameValue[1].trim()
		}
	}
	catch (Exception e) {
		throw new IllegalArgumentException("Options to the ConfigEngine command are not entered in the required format")
	}
}
println commandArgs.join(' ');
def procBuilder = new ProcessBuilder(commandArgs);

if (isWindows) {
	def envMap = procBuilder.environment();
	envMap.put("PROFILE_CONFIG_ACTION", "true");
}

def statusProc = procBuilder.start();
def outPrint = new PrintStream(System.out, true);
statusProc.waitForProcessOutput(outPrint, outPrint);
System.exit(statusProc.exitValue());
