/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

def isEmpty(value) {
    return value == null || value.equals("")
}

def findFile(parent, fileToSearch) {
    File parentDir = new File(parent)
    File[] contents = parentDir.listFiles()
    def searchedFile = ""
    for (File file : contents) {
        if (file.isDirectory()) {
            searchedFile = findFile(file.getAbsolutePath(), fileToSearch)
            if (! isEmpty(searchedFile)) {
                return searchedFile
            }
        }
        else if (file.getName().equals(fileToSearch)) {
            return file.getAbsolutePath()
        }
    }
    return searchedFile
}

def computeURL(props) {
    def host = props['vpHost']
    if (isEmpty(host)) {
        host = System.getenv("HOSTNAME");
    }

    def wpContextRoot = props['wpContextRoot']
    if (! isEmpty(wpContextRoot)) {
        if (!wpContextRoot.startsWith("/")) {
            wpContextRoot = "/" + wpContextRoot
        }else if(wpContextRoot.equals("/")){
           wpContextRoot ="" 
        }
    } else {
        wpContextRoot = "/wps"
    }

    def urlString = "http://" + host + ":" + props['vpPort'] + wpContextRoot + "/config"

    def urlContext = props['vpContext']
    if (! isEmpty(urlContext)) {
        if (!urlContext.startsWith("/")) {
            urlContext = "/" + urlContext
        }
        urlString = urlString + urlContext
    }

    return urlString
}

////////////// MAIN ////////////////////
final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
def componentName = new File(".").getCanonicalFile().name
def xmlaccess = isWindows ? "xmlaccess.bat" : "xmlaccess.sh"

def scriptFile = props['xmlscript']
if (isEmpty(scriptFile)) {
    scriptFile = componentName
}
if (!(scriptFile =~ /(?i)\.xml$/)) {
    scriptFile = scriptFile + ".xml"
}

def inputScript = findFile(new File(".").getCanonicalPath(), scriptFile)
if (isEmpty(inputScript)) {
    throw new IllegalArgumentException("The XML Script file with the name '" + scriptFile + "' could not be found")
}

def profHome = props['profHome']
if (!(profHome.endsWith("\\") || profHome.endsWith("/"))) {
    profHome = profHome + File.separator
}

def configPath = profHome + "PortalServer" + File.separator + "bin" + File.separator + xmlaccess
def commandArgs = [configPath]
if (props['useSOAPProps'].equals("true")) {
    commandArgs.add("-useEncryptedCredentials")
    commandArgs.add(profHome + "properties" + File.separator + "soap.client.props")
} else {
    commandArgs.add("-user")
    commandArgs.add(props['wpUser'])
    commandArgs.add("-password")
    commandArgs.add(props['wpPass'])
}

def urlString = computeURL(props)

commandArgs.add("-url")
commandArgs.add(urlString)
commandArgs.add("-in")
commandArgs.add(inputScript)
commandArgs.add("-out")
commandArgs.add(inputScript.substring(0, inputScript.length() - 4) + "_out.xml")

println commandArgs.join(' ');
def procBuilder = new ProcessBuilder(commandArgs);

if (isWindows) {
    def envMap = procBuilder.environment();
    envMap.put("PROFILE_CONFIG_ACTION", "true");
}

def statusProc = procBuilder.start();
def outPrint = new PrintStream(System.out, true);
statusProc.waitForProcessOutput(outPrint, outPrint);
System.exit(statusProc.exitValue());
