/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import java.io.*;
import java.util.*;
import com.urbancode.air.plugin.websphere.WebSphereCmdLineHelper

final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
out = System.out;
def wsadmin = isWindows ? "wsadmin.bat" : "wsadmin.sh"

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def PLUGIN_HOME= System.getenv("PLUGIN_HOME");
def pluginHome = new File(PLUGIN_HOME);
def scriptsDir = new File(pluginHome, "jythonScripts")
def scriptFile = new File(scriptsDir, "addTargetToCompUnit.jython");
def scriptPath = scriptFile.absolutePath; 
def node = props['node']
def server = props['server']
def cluster = props['cluster']

String newTarget = "WebSphere:";
if (server == null || server.startsWith('${p:') || server.trim() == "") {
    newTarget += "cluster=" + cluster;
}
else {
    newTarget += "node=" + node + ",server=" + server;
}

WebSphereCmdLineHelper helper = new WebSphereCmdLineHelper(props);
helper.runWSAdminScript(scriptPath, "Adding ${newTarget} to Composition Unit", this.args[0].replace("\\","\\\\"), newTarget);
